/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api;

import com.example.modloader.CustomBlock;
import com.example.modloader.CustomBlockRegistry;
import com.example.modloader.CustomCommandRegistry;
import com.example.modloader.CustomEventListenerRegistry;
import com.example.modloader.CustomItemRegistry;
import com.example.modloader.CustomMob;
import com.example.modloader.CustomMobRegistry;
import com.example.modloader.CustomRecipeRegistry;
import com.example.modloader.CustomWorldGeneratorRegistry;
import com.example.modloader.api.CustomWorldPopulator;
import com.example.modloader.api.ModAPI;
import com.example.modloader.api.ModCommandExecutor;
import com.example.modloader.api.mob.CustomMobSpawner;
import com.example.modloader.api.world.CustomOreGenerator;
import com.example.modloader.api.world.CustomStructureGenerator;
import com.example.modloader.api.world.CustomTreeGenerator;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class ModAPIImpl
implements ModAPI {
    private final CustomItemRegistry itemRegistry;
    private final CustomMobRegistry mobRegistry;
    private final CustomBlockRegistry blockRegistry;
    private final CustomCommandRegistry commandRegistry;
    private final CustomEventListenerRegistry eventListenerRegistry;
    private final CustomRecipeRegistry recipeRegistry;
    private final CustomWorldGeneratorRegistry worldGeneratorRegistry;

    public ModAPIImpl(CustomItemRegistry itemRegistry, CustomMobRegistry mobRegistry, CustomBlockRegistry blockRegistry, CustomCommandRegistry commandRegistry, CustomEventListenerRegistry eventListenerRegistry, CustomRecipeRegistry recipeRegistry, CustomWorldGeneratorRegistry worldGeneratorRegistry) {
        this.itemRegistry = itemRegistry;
        this.mobRegistry = mobRegistry;
        this.blockRegistry = blockRegistry;
        this.commandRegistry = commandRegistry;
        this.eventListenerRegistry = eventListenerRegistry;
        this.recipeRegistry = recipeRegistry;
        this.worldGeneratorRegistry = worldGeneratorRegistry;
    }

    @Override
    public void registerItem(String itemId, ItemStack item) {
        this.itemRegistry.register(itemId, item);
    }

    @Override
    public void registerMob(CustomMob customMob) {
        this.mobRegistry.register(customMob);
    }

    @Override
    public void registerBlock(CustomBlock customBlock) {
        this.blockRegistry.register(customBlock);
    }

    @Override
    public void registerCommand(String commandName, ModCommandExecutor executor) {
        this.commandRegistry.register(commandName, executor);
    }

    @Override
    public void registerListener(Listener listener) {
        this.eventListenerRegistry.register(listener);
    }

    @Override
    public void registerRecipe(Recipe recipe) {
        this.recipeRegistry.register(recipe);
    }

    @Override
    public void registerWorldPopulator(CustomWorldPopulator populator) {
        this.worldGeneratorRegistry.registerPopulator(populator);
    }

    @Override
    public void registerOreGenerator(CustomOreGenerator generator) {
        this.worldGeneratorRegistry.registerOreGenerator(generator);
    }

    @Override
    public void registerTreeGenerator(CustomTreeGenerator generator) {
        this.worldGeneratorRegistry.registerTreeGenerator(generator);
    }

    @Override
    public void registerMobSpawner(CustomMobSpawner spawner) {
        this.mobRegistry.registerSpawner(spawner);
    }

    @Override
    public void registerStructureGenerator(CustomStructureGenerator generator) {
        this.worldGeneratorRegistry.registerStructureGenerator(generator);
    }

    @Override
    public CustomMobRegistry getCustomMobRegistry() {
        return this.mobRegistry;
    }
}

