/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.mob;

import com.example.modloader.api.mob.CustomMobGoal;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.LivingEntity;

public class CustomMobGoalExecutor {
    private final LivingEntity entity;
    private final List<CustomMobGoal> goals;
    private final List<CustomMobGoal> runningGoals = new ArrayList<CustomMobGoal>();

    public CustomMobGoalExecutor(LivingEntity entity, List<CustomMobGoal> goals) {
        this.entity = entity;
        this.goals = goals;
    }

    public void tick() {
        for (CustomMobGoal goal : this.goals) {
            if (this.runningGoals.contains(goal) || !goal.shouldStart(this.entity)) continue;
            goal.start(this.entity);
            this.runningGoals.add(goal);
        }
        for (CustomMobGoal goal : new ArrayList<CustomMobGoal>(this.runningGoals)) {
            if (!goal.shouldStart(this.entity)) {
                goal.stop(this.entity);
                this.runningGoals.remove(goal);
                continue;
            }
            goal.tick(this.entity);
        }
    }
}

