/*
 * Decompiled with CFR 0.152.
 */
package net.guardapanda.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.commons.io.FileUtils;

@EventBusSubscriber
public class LoginCommand {
    private static final int MAX_LOGIN_ATTEMPTS = 3;
    private static final int OP_LEVEL_REQUIRED = 4;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_DIR = new File(FMLPaths.CONFIGDIR.get().toFile(), "guardapanda/login");
    private static final File MESSAGES_DIR = new File(CONFIG_DIR, "messages");
    private static final File playerDataFile = new File(CONFIG_DIR, "players.json");
    private static final File configFile = new File(CONFIG_DIR, "config.json");
    private static final File ipLimitsFile = new File(CONFIG_DIR, "ip_limits.json");
    private static final File ipRegistryFile = new File(CONFIG_DIR, "ip_registry.json");
    private static final Map<UUID, PlayerData> registeredPlayers = new HashMap<UUID, PlayerData>();
    private static final Map<UUID, SessionData> activeSessions = new HashMap<UUID, SessionData>();
    private static final Map<UUID, PlayerState> frozenPlayers = new HashMap<UUID, PlayerState>();
    private static final Map<String, List<UUID>> ipToPlayers = new HashMap<String, List<UUID>>();
    private static Map<String, Integer> customIpLimits = new HashMap<String, Integer>();
    private static SystemConfig config = new SystemConfig();
    private static Map<String, String> translations = new HashMap<String, String>();

    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent event) {
        LoginCommand.initializeFiles();
        LoginCommand.loadAllData();
    }

    private static void initializeFiles() {
        try {
            if (!CONFIG_DIR.exists() && !CONFIG_DIR.mkdirs()) {
                throw new IOException("Failed to create config directory");
            }
            if (!MESSAGES_DIR.exists()) {
                MESSAGES_DIR.mkdirs();
                LoginCommand.createDefaultLanguageFiles();
            }
            if (!playerDataFile.exists()) {
                FileUtils.writeStringToFile((File)playerDataFile, (String)"{}", (Charset)StandardCharsets.UTF_8);
            }
            if (!configFile.exists()) {
                FileUtils.writeStringToFile((File)configFile, (String)GSON.toJson((Object)new SystemConfig()), (Charset)StandardCharsets.UTF_8);
            }
            if (!ipLimitsFile.exists()) {
                FileUtils.writeStringToFile((File)ipLimitsFile, (String)"{}", (Charset)StandardCharsets.UTF_8);
            }
            if (!ipRegistryFile.exists()) {
                FileUtils.writeStringToFile((File)ipRegistryFile, (String)"{}", (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to initialize login system files:");
            e.printStackTrace();
        }
    }

    private static void createDefaultLanguageFiles() throws IOException {
        HashMap<String, String> ptMessages = new HashMap<String, String>();
        ptMessages.put("login_success", "\u00a7aLogin efetuado com sucesso!");
        ptMessages.put("register_success", "\u00a7aRegistro efetuado com sucesso!");
        ptMessages.put("login_required", "\u00a7cFa\u00e7a login primeiro usando /login <senha>!");
        ptMessages.put("wrong_password", "\u00a7cSenha incorreta! Tentativas restantes: %d");
        ptMessages.put("max_attempts", "\u00a7cMuitas tentativas de login falhas!");
        ptMessages.put("not_registered", "\u00a7cVoc\u00ea n\u00e3o est\u00e1 registrado. Use /register <senha>");
        ptMessages.put("already_logged", "\u00a7aVoc\u00ea j\u00e1 est\u00e1 logado!");
        ptMessages.put("session_error", "\u00a7cErro de sess\u00e3o. Reconecte ao servidor.");
        ptMessages.put("register_usage", "\u00a7eUse /register <senha> para criar uma conta!");
        ptMessages.put("login_usage", "\u00a7eUse /login <senha> para jogar!");
        ptMessages.put("min_password", "\u00a7cA senha deve ter no m\u00ednimo 4 caracteres!");
        ptMessages.put("already_registered", "\u00a7cVoc\u00ea j\u00e1 est\u00e1 registrado!");
        ptMessages.put("ip_limit_reached", "\u00a7cLimite de %d conta(s) por IP (%s) atingido!");
        ptMessages.put("config_reloaded", "\u00a7aConfigura\u00e7\u00f5es recarregadas com sucesso!");
        ptMessages.put("ip_already_used", "\u00a7cEste IP j\u00e1 est\u00e1 sendo usado por outra conta!");
        ptMessages.put("unfreeze_success", "\u00a7aJogador %s descongelado!");
        ptMessages.put("force_login_success", "\u00a7aUm administrador liberou seu acesso!");
        ptMessages.put("force_login_admin_success", "\u00a7aLogin for\u00e7ado para %s");
        ptMessages.put("ip_limit_set", "\u00a7aLimite de %d contas definido para o IP %s");
        ptMessages.put("register_kick_message", "\u00a7aFoi efectuado o registo com sucesso, deve efectuar login agora!");
        FileUtils.writeStringToFile((File)new File(MESSAGES_DIR, "pt.json"), (String)GSON.toJson(ptMessages), (Charset)StandardCharsets.UTF_8);
        HashMap<String, String> enMessages = new HashMap<String, String>();
        enMessages.put("login_success", "\u00a7aLogged in successfully!");
        enMessages.put("register_success", "\u00a7aRegistered successfully!");
        enMessages.put("login_required", "\u00a7cPlease login first using /login <password>!");
        enMessages.put("wrong_password", "\u00a7cWrong password! Remaining attempts: %d");
        enMessages.put("max_attempts", "\u00a7cToo many failed login attempts!");
        enMessages.put("not_registered", "\u00a7cYou are not registered. Use /register <password>");
        enMessages.put("already_logged", "\u00a7aYou are already logged in!");
        enMessages.put("session_error", "\u00a7cSession error. Please reconnect.");
        enMessages.put("register_usage", "\u00a7eUse /register <password> to create an account!");
        enMessages.put("login_usage", "\u00a7eUse /login <password> to play!");
        enMessages.put("min_password", "\u00a7cPassword must be at least 4 characters!");
        enMessages.put("already_registered", "\u00a7cYou are already registered!");
        enMessages.put("ip_limit_reached", "\u00a7cLimit of %d account(s) per IP (%s) reached!");
        enMessages.put("config_reloaded", "\u00a7aConfigurations reloaded successfully!");
        enMessages.put("ip_already_used", "\u00a7cThis IP is already used by another account!");
        enMessages.put("unfreeze_success", "\u00a7aPlayer %s unfrozen!");
        enMessages.put("force_login_success", "\u00a7aAn administrator has granted you access!");
        enMessages.put("force_login_admin_success", "\u00a7aForced login for %s");
        enMessages.put("ip_limit_set", "\u00a7aLimit of %d accounts set for IP %s");
        enMessages.put("register_kick_message", "\u00a7aRegistration successful, please login now!");
        FileUtils.writeStringToFile((File)new File(MESSAGES_DIR, "en.json"), (String)GSON.toJson(enMessages), (Charset)StandardCharsets.UTF_8);
    }

    private static void loadAllData() {
        registeredPlayers.putAll(LoginCommand.loadPlayerData());
        config = LoginCommand.loadConfig();
        LoginCommand.loadCustomIpLimits();
        LoginCommand.loadIpRegistry();
        LoginCommand.loadMessages(LoginCommand.config.language);
    }

    private static void loadMessages(String language) {
        File langFile = new File(MESSAGES_DIR, language + ".json");
        try {
            String json = FileUtils.readFileToString((File)langFile, (Charset)StandardCharsets.UTF_8);
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            translations = (Map)GSON.fromJson(json, type);
        }
        catch (IOException e) {
            System.err.println("Error loading language file:");
            e.printStackTrace();
        }
    }

    private static void loadCustomIpLimits() {
        try {
            String json = FileUtils.readFileToString((File)ipLimitsFile, (Charset)StandardCharsets.UTF_8);
            Type type = new TypeToken<Map<String, Integer>>(){}.getType();
            customIpLimits = (Map)GSON.fromJson(json, type);
        }
        catch (IOException e) {
            System.err.println("Error loading IP limits:");
            e.printStackTrace();
        }
    }

    private static void loadIpRegistry() {
        try {
            String json = FileUtils.readFileToString((File)ipRegistryFile, (Charset)StandardCharsets.UTF_8);
            Type type = new TypeToken<Map<String, List<String>>>(){}.getType();
            Map tempMap = (Map)GSON.fromJson(json, type);
            ipToPlayers.clear();
            for (Map.Entry entry : tempMap.entrySet()) {
                ArrayList<UUID> uuids = new ArrayList<UUID>();
                for (String uuidStr : (List)entry.getValue()) {
                    uuids.add(UUID.fromString(uuidStr));
                }
                ipToPlayers.put((String)entry.getKey(), uuids);
            }
        }
        catch (IOException e) {
            System.err.println("Error loading IP registry:");
            e.printStackTrace();
        }
    }

    private static Map<UUID, PlayerData> loadPlayerData() {
        try {
            String json = FileUtils.readFileToString((File)playerDataFile, (Charset)StandardCharsets.UTF_8);
            Type type = new TypeToken<Map<UUID, PlayerData>>(){}.getType();
            return (Map)GSON.fromJson(json, type);
        }
        catch (IOException e) {
            System.err.println("Error loading player data:");
            e.printStackTrace();
            return new HashMap<UUID, PlayerData>();
        }
    }

    private static SystemConfig loadConfig() {
        try {
            String json = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
            return (SystemConfig)GSON.fromJson(json, SystemConfig.class);
        }
        catch (IOException e) {
            System.err.println("Error loading config:");
            e.printStackTrace();
            return new SystemConfig();
        }
    }

    private static void savePlayerData() {
        try {
            FileUtils.writeStringToFile((File)playerDataFile, (String)GSON.toJson(registeredPlayers), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            System.err.println("Error saving player data:");
            e.printStackTrace();
        }
    }

    private static void saveIpRegistry() {
        try {
            HashMap toSave = new HashMap();
            for (Map.Entry<String, List<UUID>> entry : ipToPlayers.entrySet()) {
                ArrayList<String> uuids = new ArrayList<String>();
                for (UUID uuid : entry.getValue()) {
                    uuids.add(uuid.toString());
                }
                toSave.put(entry.getKey(), uuids);
            }
            FileUtils.writeStringToFile((File)ipRegistryFile, (String)GSON.toJson(toSave), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            System.err.println("Error saving IP registry:");
            e.printStackTrace();
        }
    }

    private static void saveCustomIpLimits() {
        try {
            FileUtils.writeStringToFile((File)ipLimitsFile, (String)GSON.toJson(customIpLimits), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            System.err.println("Error saving IP limits:");
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"login").requires(source -> source.getEntity() instanceof ServerPlayer)).then(Commands.argument((String)"password", (ArgumentType)MessageArgument.message()).executes(ctx -> LoginCommand.handleLogin(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), MessageArgument.getMessage((CommandContext)ctx, (String)"password").getString()))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"register").requires(source -> source.getEntity() instanceof ServerPlayer)).then(Commands.argument((String)"password", (ArgumentType)MessageArgument.message()).executes(ctx -> LoginCommand.handleRegister(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), MessageArgument.getMessage((CommandContext)ctx, (String)"password").getString()))));
        LoginCommand.registerAdminCommands(event);
    }

    private static void registerAdminCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"auth").requires(source -> source.hasPermission(4))).then(Commands.literal((String)"unfreeze").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            LoginCommand.unfreezePlayer(target);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)LoginCommand.getMessage("unfreeze_success", target.getName())), false);
            return 1;
        })))).then(Commands.literal((String)"forcelogin").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            UUID targetUuid = target.getUUID();
            if (!registeredPlayers.containsKey(targetUuid)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)LoginCommand.getMessage("not_registered", new Object[0])));
                return 0;
            }
            SessionData session = activeSessions.get(targetUuid);
            if (session != null) {
                session.isLoggedIn = true;
                LoginCommand.unfreezePlayer(target);
                LoginCommand.sendMessage((Player)target, LoginCommand.getMessage("force_login_success", new Object[0]));
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)LoginCommand.getMessage("force_login_admin_success", target.getName())), false);
                return 1;
            }
            return 0;
        })))).then(Commands.literal((String)"reload").executes(ctx -> {
            LoginCommand.loadAllData();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)LoginCommand.getMessage("config_reloaded", new Object[0])), false);
            return 1;
        }))).then(Commands.literal((String)"setiplimit").then(Commands.argument((String)"ip", (ArgumentType)MessageArgument.message()).then(Commands.argument((String)"limit", (ArgumentType)MessageArgument.message()).executes(ctx -> {
            String ip = MessageArgument.getMessage((CommandContext)ctx, (String)"ip").getString();
            String limitStr = MessageArgument.getMessage((CommandContext)ctx, (String)"limit").getString();
            try {
                int limit = Integer.parseInt(limitStr);
                if (limit < 1) {
                    ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Limit must be at least 1"));
                    return 0;
                }
                customIpLimits.put(ip, limit);
                LoginCommand.saveCustomIpLimits();
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)LoginCommand.getMessage("ip_limit_set", limit, ip)), false);
                return 1;
            }
            catch (NumberFormatException e) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Invalid number format"));
                return 0;
            }
        })))));
    }

    private static int handleLogin(ServerPlayer player, String password) {
        UUID uuid = player.getUUID();
        SessionData session = activeSessions.get(uuid);
        if (session == null) {
            LoginCommand.sendMessage((Player)player, LoginCommand.getMessage("session_error", new Object[0]));
            return 0;
        }
        if (session.isLoggedIn) {
            LoginCommand.sendMessage((Player)player, LoginCommand.getMessage("already_logged", new Object[0]));
            return 0;
        }
        PlayerData account = registeredPlayers.get(uuid);
        if (account == null) {
            LoginCommand.sendMessage((Player)player, LoginCommand.getMessage("not_registered", new Object[0]));
            return 0;
        }
        if (!account.password.equals(password)) {
            ++session.loginAttempts;
            if (session.loginAttempts >= 3) {
                player.connection.disconnect((Component)Component.literal((String)LoginCommand.getMessage("max_attempts", new Object[0])));
                return 0;
            }
            LoginCommand.sendMessage((Player)player, LoginCommand.getMessage("wrong_password", 3 - session.loginAttempts));
            return 0;
        }
        String currentIp = player.getIpAddress();
        if (!currentIp.equals(account.lastIp)) {
            if (ipToPlayers.containsKey(account.lastIp)) {
                ipToPlayers.get(account.lastIp).remove(uuid);
                if (ipToPlayers.get(account.lastIp).isEmpty()) {
                    ipToPlayers.remove(account.lastIp);
                }
            }
            ipToPlayers.computeIfAbsent(currentIp, k -> new ArrayList()).add(uuid);
            account.lastIp = currentIp;
            LoginCommand.savePlayerData();
            LoginCommand.saveIpRegistry();
        }
        session.isLoggedIn = true;
        session.loginAttempts = 0;
        LoginCommand.unfreezePlayer(player);
        LoginCommand.sendMessage((Player)player, LoginCommand.getMessage("login_success", new Object[0]));
        return 1;
    }

    private static int handleRegister(ServerPlayer player, String password) {
        UUID uuid = player.getUUID();
        String ip = player.getIpAddress();
        if (registeredPlayers.containsKey(uuid)) {
            LoginCommand.sendMessage((Player)player, LoginCommand.getMessage("already_registered", new Object[0]));
            return 0;
        }
        if (password.length() < 4) {
            LoginCommand.sendMessage((Player)player, LoginCommand.getMessage("min_password", new Object[0]));
            return 0;
        }
        int limit = customIpLimits.getOrDefault(ip, LoginCommand.config.accountsPerIp);
        int accountsOnIp = ipToPlayers.getOrDefault(ip, Collections.emptyList()).size();
        if (accountsOnIp >= limit) {
            LoginCommand.sendMessage((Player)player, LoginCommand.getMessage("ip_limit_reached", limit, ip));
            return 0;
        }
        PlayerData newAccount = new PlayerData(player.getGameProfile().getName(), password, ip);
        registeredPlayers.put(uuid, newAccount);
        ipToPlayers.computeIfAbsent(ip, k -> new ArrayList()).add(uuid);
        LoginCommand.savePlayerData();
        LoginCommand.saveIpRegistry();
        SessionData session = activeSessions.get(uuid);
        if (session != null) {
            session.isLoggedIn = true;
        }
        LoginCommand.unfreezePlayer(player);
        player.connection.disconnect((Component)Component.literal((String)LoginCommand.getMessage("register_kick_message", new Object[0])));
        return 1;
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID uuid = player2.getUUID();
        String ip = player2.getIpAddress();
        activeSessions.put(uuid, new SessionData());
        if (registeredPlayers.containsKey(uuid)) {
            PlayerData account = registeredPlayers.get(uuid);
            if (!ip.equals(account.lastIp)) {
                if (ipToPlayers.containsKey(account.lastIp)) {
                    ipToPlayers.get(account.lastIp).remove(uuid);
                    if (ipToPlayers.get(account.lastIp).isEmpty()) {
                        ipToPlayers.remove(account.lastIp);
                    }
                }
                ipToPlayers.computeIfAbsent(ip, k -> new ArrayList()).add(uuid);
                account.lastIp = ip;
                LoginCommand.savePlayerData();
                LoginCommand.saveIpRegistry();
            }
            LoginCommand.freezePlayer(player2);
            LoginCommand.sendMessage((Player)player2, LoginCommand.getMessage("login_usage", new Object[0]));
        } else {
            LoginCommand.freezePlayer(player2);
            LoginCommand.sendMessage((Player)player2, LoginCommand.getMessage("register_usage", new Object[0]));
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        activeSessions.remove(event.getEntity().getUUID());
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID uuid = player2.getUUID();
        if (!LoginCommand.isLoggedIn(uuid) && frozenPlayers.containsKey(uuid)) {
            PlayerState state = frozenPlayers.get(uuid);
            player2.connection.teleport(state.position.x, state.position.y, state.position.z, player2.getYRot(), player2.getXRot());
            if (player2.gameMode.getGameModeForPlayer() != GameType.SURVIVAL) {
                player2.setGameMode(GameType.SURVIVAL);
            }
        }
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        if (!LoginCommand.isLoggedIn(event.getPlayer().getUUID())) {
            event.setCanceled(true);
            LoginCommand.returnItemToPlayer((ServerPlayer)event.getPlayer(), event.getEntity().getItem());
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!LoginCommand.isLoggedIn(event.getEntity().getUUID())) {
            event.setCancellationResult(InteractionResult.FAIL);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!LoginCommand.isLoggedIn(event.getEntity().getUUID())) {
            event.setCancellationResult(InteractionResult.FAIL);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (!LoginCommand.isLoggedIn(event.getEntity().getUUID())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onChat(ServerChatEvent event) {
        if (!LoginCommand.isLoggedIn(event.getPlayer().getUUID())) {
            event.setCanceled(true);
            LoginCommand.sendMessage((Player)event.getPlayer(), LoginCommand.getMessage("login_required", new Object[0]));
        }
    }

    @SubscribeEvent
    public static void onCommand(CommandEvent event) {
        Entity entity = ((CommandSourceStack)event.getParseResults().getContext().getSource()).getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            String command = "";
            if (!event.getParseResults().getContext().getNodes().isEmpty()) {
                command = ((ParsedCommandNode)event.getParseResults().getContext().getNodes().get(0)).getNode().getName();
            }
            if (!(LoginCommand.isLoggedIn(player.getUUID()) || command.equals("login") || command.equals("register"))) {
                event.setCanceled(true);
                LoginCommand.sendMessage((Player)player, LoginCommand.getMessage("login_required", new Object[0]));
            }
        }
    }

    private static String getMessage(String key, Object ... args) {
        String message = translations.getOrDefault(key, "\u00a7cMessage not found: " + key);
        return String.format(message, args);
    }

    private static void sendMessage(Player player, String message) {
        player.displayClientMessage((Component)Component.literal((String)message), false);
    }

    private static boolean isLoggedIn(UUID uuid) {
        SessionData session = activeSessions.get(uuid);
        return session != null && session.isLoggedIn;
    }

    private static void freezePlayer(ServerPlayer player) {
        frozenPlayers.put(player.getUUID(), new PlayerState(player));
        player.setGameMode(GameType.SURVIVAL);
        player.getAbilities().invulnerable = true;
        player.getAbilities().mayfly = false;
        player.getAbilities().flying = false;
        player.getAbilities().setWalkingSpeed(0.0f);
        player.getAbilities().mayBuild = false;
        player.onUpdateAbilities();
    }

    private static void unfreezePlayer(ServerPlayer player) {
        PlayerState state = frozenPlayers.remove(player.getUUID());
        if (state != null) {
            boolean isCreative;
            player.setGameMode(state.originalGameMode);
            player.getAbilities().invulnerable = isCreative = state.originalGameMode == GameType.CREATIVE;
            player.getAbilities().mayfly = isCreative;
            player.getAbilities().flying = false;
            player.getAbilities().setWalkingSpeed(0.1f);
            player.getAbilities().mayBuild = true;
            player.onUpdateAbilities();
        }
    }

    private static void returnItemToPlayer(ServerPlayer player, ItemStack item) {
        if (!player.getInventory().add(item)) {
            player.drop(item, false);
        }
    }

    private static class SystemConfig {
        String language = "pt";
        int accountsPerIp = 1;

        private SystemConfig() {
        }
    }

    private static class SessionData {
        boolean isLoggedIn = false;
        int loginAttempts = 0;

        private SessionData() {
        }
    }

    private static class PlayerData {
        String username;
        String password;
        String lastIp;

        PlayerData(String username, String password, String lastIp) {
            this.username = username;
            this.password = password;
            this.lastIp = lastIp;
        }
    }

    private static class PlayerState {
        Vec3 position;
        Vec2 rotation;
        GameType originalGameMode;

        PlayerState(ServerPlayer player) {
            this.position = player.position();
            this.rotation = player.getRotationVector();
            this.originalGameMode = player.gameMode.getGameModeForPlayer();
        }
    }
}

