/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper.transfer;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.swedz.tesseract.neoforge.helper.TransferHelper;
import net.swedz.tesseract.neoforge.helper.transfer.TransferCache;

public class ItemTransferCache
extends TransferCache<IItemHandler> {
    public ItemTransferCache(BlockCapability<IItemHandler, Direction> capability, Supplier<IItemHandler> sourceHandler) {
        super(capability, sourceHandler);
    }

    public ItemTransferCache(Supplier<IItemHandler> sourceHandler) {
        this((BlockCapability<IItemHandler, Direction>)Capabilities.ItemHandler.BLOCK, sourceHandler);
    }

    @Override
    public boolean autoExtract(Level level, BlockPos pos, Direction direction) {
        IItemHandler target = (IItemHandler)this.cache.output(level, pos, direction);
        if (target != null) {
            return !TransferHelper.moveAll((IItemHandler)this.sourceHandler(), target, true).isEmpty();
        }
        return false;
    }

    @Override
    public boolean autoInsert(Level level, BlockPos pos, Direction direction) {
        IItemHandler target = (IItemHandler)this.cache.input(level, pos, direction);
        if (target != null) {
            return !TransferHelper.moveAll(target, (IItemHandler)this.sourceHandler(), true).isEmpty();
        }
        return false;
    }
}

