/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.lang;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.api.WorldPos;
import net.swedz.tesseract.neoforge.lang.LangHandler;
import net.swedz.tesseract.neoforge.lang.LangInstance;
import net.swedz.tesseract.neoforge.tooltip.Parser;

public final class LangManager {
    private final String modId;
    private final Map<String, Supplier<Style>> styles = Maps.newHashMap();
    private final Map<ParserKey, Supplier<Parser<?>>> parsers = Maps.newHashMap();

    public LangManager(String modId) {
        this.modId = modId;
        this.style(() -> Style.EMPTY);
        this.parser(Component.class, () -> Parser.COMPONENT);
    }

    String modId() {
        return this.modId;
    }

    public LangManager style(String key, Supplier<Style> style) {
        Assert.noneNull(key, style);
        this.styles.put(key, style);
        return this;
    }

    public LangManager style(Supplier<Style> style) {
        return this.style("default", style);
    }

    public LangManager builtinColorStyles() {
        for (ChatFormatting formatting : ChatFormatting.values()) {
            if (!formatting.isColor()) continue;
            this.style(formatting.getName().toLowerCase(), () -> Style.EMPTY.withColor(formatting).withItalic(Boolean.valueOf(false)));
        }
        return this;
    }

    Supplier<Style> getStyle(String key) {
        Assert.notNull(key);
        return this.styles.get(key);
    }

    public <T> LangManager parser(String key, Class<T> paramClass, Supplier<Parser<T>> parser) {
        Assert.noneNull(key, paramClass, parser);
        this.parsers.put(new ParserKey(key, paramClass), parser::get);
        return this;
    }

    public <T> LangManager parser(Class<T> paramClass, Supplier<Parser<T>> parser) {
        return this.parser("default", paramClass, parser);
    }

    public LangManager builtinParsers() {
        return this.parser(ResourceKey.class, () -> Parser.RESOURCE_KEY::parse).parser(ItemStack.class, () -> Parser.ITEM_STACK).parser(Item.class, () -> Parser.ITEM).parser("item", ResourceLocation.class, () -> Parser.ITEM_ID).parser(Block.class, () -> Parser.BLOCK).parser(BlockState.class, () -> Parser.BLOCK_STATE).parser("block", ResourceLocation.class, () -> Parser.BLOCK_ID).parser(Fluid.class, () -> Parser.FLUID).parser(EntityType.class, () -> Parser.ENTITY_TYPE).parser("keybind", String.class, () -> Parser.KEYBIND).parser(BlockPos.class, () -> Parser.BLOCK_POS).parser(GlobalPos.class, () -> Parser.GLOBAL_POS).parser(WorldPos.class, () -> Parser.WORLD_POS);
    }

    Supplier<Parser<?>> getParser(String key, Class<?> paramClass) {
        Assert.noneNull(key, paramClass);
        return this.parsers.get(new ParserKey(key, paramClass));
    }

    public <L> LangInstance<L> build(Class<L> langClass) {
        try {
            LangHandler handler = new LangHandler(this);
            Object proxy = Proxy.newProxyInstance(langClass.getClassLoader(), new Class[]{langClass}, (InvocationHandler)handler);
            return new LangInstance<Object>(langClass, proxy, handler);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private record ParserKey(String key, Class<?> paramClass) {
    }
}

