/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied;

import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.OverclockComponent;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.swedz.tesseract.neoforge.compat.mi.TesseractMI;
import net.swedz.tesseract.neoforge.compat.mi.api.SteamMachineTierHolder;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied.AbstractMultipliedCraftingMultiblockBlockEntity;

public abstract class AbstractSteamMultipliedCraftingMultiblockBlockEntity
extends AbstractMultipliedCraftingMultiblockBlockEntity
implements SteamMachineTierHolder {
    protected final OverclockComponent overclock;
    protected boolean steel;

    public AbstractSteamMultipliedCraftingMultiblockBlockEntity(BEP bep, ResourceLocation id, ShapeTemplate[] shapeTemplates, List<OverclockComponent.Catalyst> overclockCatalysts) {
        super(bep, id, shapeTemplates);
        this.overclock = new OverclockComponent(overclockCatalysts);
        this.registerComponents(new IComponent[]{this.overclock});
    }

    @Override
    public boolean isSteelTier() {
        return this.steel;
    }

    @Override
    protected void onRematch(ShapeMatcher shapeMatcher) {
        super.onRematch(shapeMatcher);
        this.steel = false;
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            if (!hatch.upgradesToSteel()) continue;
            this.steel = true;
            break;
        }
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        return !result.consumesAction() ? this.overclock.onUse((MachineBlockEntity)this, player, hand) : result;
    }

    @Override
    public long consumeEu(long max, Simulation simulation) {
        return SteamHelper.consumeSteamEu((List)this.inventory.getFluidInputs(), (long)max, (Simulation)simulation);
    }

    @Override
    public void tick() {
        super.tick();
        this.overclock.tick((MachineBlockEntity)this);
    }

    @Override
    public long getBaseRecipeEu() {
        return this.overclock.getRecipeEu(this.steel ? 4 : 2);
    }

    @Override
    public long getBaseMaxRecipeEu() {
        return this.getBaseRecipeEu();
    }

    public List<Component> getTooltips() {
        ArrayList tooltips = Lists.newArrayList();
        tooltips.addAll(this.overclock.getTooltips());
        tooltips.add(TesseractMI.text().machineBatcherRecipe(false, this.getRecipeType()));
        tooltips.add(TesseractMI.text().machineBatcherSizeAndCost(this.getMaxMultiplier(), this.getEuCostTransformer()));
        return tooltips;
    }
}

