/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.builder.slots;

import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.slots.FluidMachineSlotDefinition;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.slots.ItemMachineSlotDefinition;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.slots.MachineSlotDefinition;

public final class MachineSlotConfiguration {
    private final MachineSlotDefinition[] slots;

    public static MachineSlotConfiguration empty() {
        return new MachineSlotConfiguration(new MachineSlotDefinition[0]);
    }

    public static Builder combine(MachineSlotConfiguration ... configurations) {
        Builder combined = new Builder();
        for (MachineSlotConfiguration group : configurations) {
            for (int i = 0; i < group.size(); ++i) {
                combined.add(group.get(i));
            }
        }
        return combined;
    }

    private MachineSlotConfiguration(MachineSlotDefinition[] slots) {
        this.slots = slots;
    }

    public MachineSlotDefinition get(int index) {
        return this.slots[index];
    }

    public int size() {
        return this.slots.length;
    }

    public AllSlotPositions toSlotPositions() {
        SlotPositions.Builder all = new SlotPositions.Builder();
        SlotPositions.Builder items = new SlotPositions.Builder();
        SlotPositions.Builder itemInputs = new SlotPositions.Builder();
        SlotPositions.Builder itemOutputs = new SlotPositions.Builder();
        SlotPositions.Builder fluids = new SlotPositions.Builder();
        SlotPositions.Builder fluidInputs = new SlotPositions.Builder();
        SlotPositions.Builder fluidOutputs = new SlotPositions.Builder();
        for (MachineSlotDefinition slot : this.slots) {
            all.addSlot(slot.x(), slot.y());
            if (slot instanceof ItemMachineSlotDefinition) {
                ItemMachineSlotDefinition itemSlot = (ItemMachineSlotDefinition)slot;
                items.addSlot(slot.x(), slot.y());
                (slot.playerInsert() || slot.pipesInsert() ? itemInputs : itemOutputs).addSlot(slot.x(), slot.y());
                continue;
            }
            if (slot instanceof FluidMachineSlotDefinition) {
                FluidMachineSlotDefinition fluidSlot = (FluidMachineSlotDefinition)slot;
                fluids.addSlot(slot.x(), slot.y());
                (slot.playerInsert() || slot.pipesInsert() ? fluidInputs : fluidOutputs).addSlot(slot.x(), slot.y());
                continue;
            }
            throw new IllegalArgumentException("Unsupported slot type " + slot.getClass().getSimpleName());
        }
        return new AllSlotPositions(all.build(), items.build(), itemInputs.build(), itemOutputs.build(), fluids.build(), fluidInputs.build(), fluidOutputs.build());
    }

    public MIInventory toInventory() {
        ArrayList items = Lists.newArrayList();
        ArrayList fluids = Lists.newArrayList();
        for (MachineSlotDefinition slot : this.slots) {
            if (slot instanceof ItemMachineSlotDefinition) {
                ItemMachineSlotDefinition itemSlot = (ItemMachineSlotDefinition)slot;
                items.add(itemSlot.create());
                continue;
            }
            if (slot instanceof FluidMachineSlotDefinition) {
                FluidMachineSlotDefinition fluidSlot = (FluidMachineSlotDefinition)slot;
                fluids.add(fluidSlot.create());
                continue;
            }
            throw new IllegalArgumentException("Unsupported slot type " + slot.getClass().getSimpleName());
        }
        AllSlotPositions slotPositions = this.toSlotPositions();
        return new MIInventory((List)items, (List)fluids, slotPositions.items(), slotPositions.fluids());
    }

    public MachineInventoryComponent toInventoryComponent() {
        ArrayList itemInputs = Lists.newArrayList();
        ArrayList itemOutputs = Lists.newArrayList();
        ArrayList fluidInputs = Lists.newArrayList();
        ArrayList fluidOutputs = Lists.newArrayList();
        for (MachineSlotDefinition slot : this.slots) {
            if (slot instanceof ItemMachineSlotDefinition) {
                ItemMachineSlotDefinition itemSlot = (ItemMachineSlotDefinition)slot;
                (slot.playerInsert() || slot.pipesInsert() ? itemInputs : itemOutputs).add(itemSlot.create());
                continue;
            }
            if (slot instanceof FluidMachineSlotDefinition) {
                FluidMachineSlotDefinition fluidSlot = (FluidMachineSlotDefinition)slot;
                (slot.playerInsert() || slot.pipesInsert() ? fluidInputs : fluidOutputs).add(fluidSlot.create());
                continue;
            }
            throw new IllegalArgumentException("Unsupported slot type " + slot.getClass().getSimpleName());
        }
        AllSlotPositions slotPositions = this.toSlotPositions();
        return new MachineInventoryComponent((List)itemInputs, (List)itemOutputs, (List)fluidInputs, (List)fluidOutputs, slotPositions.items(), slotPositions.fluids());
    }

    public static final class Builder {
        private final List<MachineSlotDefinition> slots = Lists.newArrayList();
        private int fallbackFluidCapacity = 16;

        public Builder fluidCapacity(int fallbackFluidCapacity) {
            this.fallbackFluidCapacity = fallbackFluidCapacity;
            return this;
        }

        public Builder append(Builder other) {
            this.slots.addAll(other.slots);
            return this;
        }

        public Builder append(SlotPositions itemInputs, SlotPositions itemOutputs, SlotPositions fluidInputs, SlotPositions fluidOutputs) {
            int index;
            for (index = 0; index < itemInputs.size(); ++index) {
                this.itemInput(itemInputs.getX(index), itemInputs.getY(index));
            }
            for (index = 0; index < itemOutputs.size(); ++index) {
                this.itemOutput(itemOutputs.getX(index), itemOutputs.getY(index));
            }
            for (index = 0; index < fluidInputs.size(); ++index) {
                this.fluidInput(fluidInputs.getX(index), fluidInputs.getY(index));
            }
            for (index = 0; index < fluidOutputs.size(); ++index) {
                this.fluidOutput(fluidOutputs.getX(index), fluidOutputs.getY(index));
            }
            return this;
        }

        public Builder append(SlotPositions.Builder itemInputs, SlotPositions.Builder itemOutputs, SlotPositions.Builder fluidInputs, SlotPositions.Builder fluidOutputs) {
            return this.append(itemInputs.build(), itemOutputs.build(), fluidInputs.build(), fluidOutputs.build());
        }

        public Builder append(Consumer<SlotPositions.Builder> itemInputs, Consumer<SlotPositions.Builder> itemOutputs, Consumer<SlotPositions.Builder> fluidInputs, Consumer<SlotPositions.Builder> fluidOutputs) {
            SlotPositions.Builder itemInputsBuilder = new SlotPositions.Builder();
            itemInputs.accept(itemInputsBuilder);
            SlotPositions.Builder itemOutputsBuilder = new SlotPositions.Builder();
            itemOutputs.accept(itemOutputsBuilder);
            SlotPositions.Builder fluidInputsBuilder = new SlotPositions.Builder();
            fluidInputs.accept(fluidInputsBuilder);
            SlotPositions.Builder fluidOutputsBuilder = new SlotPositions.Builder();
            fluidOutputs.accept(fluidOutputsBuilder);
            return this.append(itemInputsBuilder, itemOutputsBuilder, fluidInputsBuilder, fluidOutputsBuilder);
        }

        private Builder add(MachineSlotDefinition slot) {
            this.slots.add(slot);
            return this;
        }

        private Builder item(int x, int y, boolean playerInsert, boolean pipesInsert, boolean playerExtract, boolean pipesExtract, Supplier<Item> lock) {
            return this.add(new ItemMachineSlotDefinition(x, y, playerInsert, pipesInsert, playerExtract, pipesExtract, lock));
        }

        public Builder itemInput(int x, int y, Supplier<Item> lock) {
            return this.item(x, y, true, true, true, false, lock);
        }

        public Builder itemInput(int x, int y) {
            return this.itemInput(x, y, null);
        }

        public Builder itemOutput(int x, int y, Supplier<Item> lock) {
            return this.item(x, y, false, false, true, true, lock);
        }

        public Builder itemOutput(int x, int y) {
            return this.itemOutput(x, y, null);
        }

        public Builder itemIO(int x, int y, Supplier<Item> lock) {
            return this.item(x, y, true, true, true, true, lock);
        }

        public Builder itemIO(int x, int y) {
            return this.itemIO(x, y, null);
        }

        private Builder items(int x, int y, int columns, int rows, boolean playerInsert, boolean pipesInsert, boolean playerExtract, boolean pipesExtract, Supplier<Item> lock) {
            for (int row = 0; row < rows; ++row) {
                for (int column = 0; column < columns; ++column) {
                    this.item(x + column * 18, y + row * 18, playerInsert, pipesInsert, playerExtract, pipesExtract, lock);
                }
            }
            return this;
        }

        public Builder itemInputs(int x, int y, int columns, int rows, Supplier<Item> lock) {
            return this.items(x, y, columns, rows, true, true, true, false, lock);
        }

        public Builder itemInputs(int x, int y, int columns, int rows) {
            return this.itemInputs(x, y, columns, rows, null);
        }

        public Builder itemOutputs(int x, int y, int columns, int rows, Supplier<Item> lock) {
            return this.items(x, y, columns, rows, false, false, true, true, lock);
        }

        public Builder itemOutputs(int x, int y, int columns, int rows) {
            return this.itemOutputs(x, y, columns, rows, null);
        }

        public Builder itemIOs(int x, int y, int columns, int rows, Supplier<Item> lock) {
            return this.items(x, y, columns, rows, true, true, true, true, lock);
        }

        public Builder itemIOs(int x, int y, int columns, int rows) {
            return this.itemIOs(x, y, columns, rows, null);
        }

        private Builder fluid(int x, int y, boolean playerInsert, boolean pipesInsert, boolean playerExtract, boolean pipesExtract, Supplier<Fluid> lock, int capacityBuckets) {
            return this.add(new FluidMachineSlotDefinition(x, y, playerInsert, pipesInsert, playerExtract, pipesExtract, lock, (long)capacityBuckets * 1000L));
        }

        public Builder fluidInput(int x, int y, Supplier<Fluid> lock, int capacityBuckets) {
            return this.fluid(x, y, true, true, true, false, lock, capacityBuckets);
        }

        public Builder fluidInput(int x, int y, Supplier<Fluid> lock) {
            return this.fluidInput(x, y, lock, this.fallbackFluidCapacity);
        }

        public Builder fluidInput(int x, int y, int capacityBuckets) {
            return this.fluidInput(x, y, null, capacityBuckets);
        }

        public Builder fluidInput(int x, int y) {
            return this.fluidInput(x, y, this.fallbackFluidCapacity);
        }

        public Builder fluidOutput(int x, int y, Supplier<Fluid> lock, int capacityBuckets) {
            return this.fluid(x, y, false, false, true, true, lock, capacityBuckets);
        }

        public Builder fluidOutput(int x, int y, Supplier<Fluid> lock) {
            return this.fluidOutput(x, y, lock, this.fallbackFluidCapacity);
        }

        public Builder fluidOutput(int x, int y, int capacityBuckets) {
            return this.fluidOutput(x, y, null, capacityBuckets);
        }

        public Builder fluidOutput(int x, int y) {
            return this.fluidOutput(x, y, this.fallbackFluidCapacity);
        }

        public Builder fluidIO(int x, int y, Supplier<Fluid> lock, int capacityBuckets) {
            return this.fluid(x, y, true, true, true, true, lock, capacityBuckets);
        }

        public Builder fluidIO(int x, int y, Supplier<Fluid> lock) {
            return this.fluidIO(x, y, lock, this.fallbackFluidCapacity);
        }

        public Builder fluidIO(int x, int y, int capacityBuckets) {
            return this.fluidIO(x, y, null, capacityBuckets);
        }

        public Builder fluidIO(int x, int y) {
            return this.fluidIO(x, y, this.fallbackFluidCapacity);
        }

        private Builder fluids(int x, int y, int columns, int rows, boolean playerInsert, boolean pipesInsert, boolean playerExtract, boolean pipesExtract, Supplier<Fluid> lock, int capacityBuckets) {
            for (int row = 0; row < rows; ++row) {
                for (int column = 0; column < columns; ++column) {
                    this.fluid(x + column * 18, y + row * 18, playerInsert, pipesInsert, playerExtract, pipesExtract, lock, capacityBuckets);
                }
            }
            return this;
        }

        public Builder fluidInputs(int x, int y, int columns, int rows, Supplier<Fluid> lock, int capacityBuckets) {
            return this.fluids(x, y, columns, rows, true, true, true, false, lock, capacityBuckets);
        }

        public Builder fluidInputs(int x, int y, int columns, int rows, Supplier<Fluid> lock) {
            return this.fluidInputs(x, y, columns, rows, lock, this.fallbackFluidCapacity);
        }

        public Builder fluidInputs(int x, int y, int columns, int rows, int capacityBuckets) {
            return this.fluidInputs(x, y, columns, rows, null, capacityBuckets);
        }

        public Builder fluidInputs(int x, int y, int columns, int rows) {
            return this.fluidInputs(x, y, columns, rows, this.fallbackFluidCapacity);
        }

        public Builder fluidOutputs(int x, int y, int columns, int rows, Supplier<Fluid> lock, int capacityBuckets) {
            return this.fluids(x, y, columns, rows, false, false, true, true, lock, capacityBuckets);
        }

        public Builder fluidOutputs(int x, int y, int columns, int rows, Supplier<Fluid> lock) {
            return this.fluidOutputs(x, y, columns, rows, lock, this.fallbackFluidCapacity);
        }

        public Builder fluidOutputs(int x, int y, int columns, int rows, int capacityBuckets) {
            return this.fluidOutputs(x, y, columns, rows, null, capacityBuckets);
        }

        public Builder fluidOutputs(int x, int y, int columns, int rows) {
            return this.fluidOutputs(x, y, columns, rows, this.fallbackFluidCapacity);
        }

        public Builder fluidIOs(int x, int y, int columns, int rows, Supplier<Fluid> lock, int capacityBuckets) {
            return this.fluids(x, y, columns, rows, true, true, true, true, lock, capacityBuckets);
        }

        public Builder fluidIOs(int x, int y, int columns, int rows, Supplier<Fluid> lock) {
            return this.fluidIOs(x, y, columns, rows, lock, this.fallbackFluidCapacity);
        }

        public Builder fluidIOs(int x, int y, int columns, int rows, int capacityBuckets) {
            return this.fluidIOs(x, y, columns, rows, null, capacityBuckets);
        }

        public Builder fluidIOs(int x, int y, int columns, int rows) {
            return this.fluidIOs(x, y, columns, rows, this.fallbackFluidCapacity);
        }

        public MachineSlotConfiguration build() {
            return new MachineSlotConfiguration((MachineSlotDefinition[])this.slots.toArray(MachineSlotDefinition[]::new));
        }

        public MachineSlotConfiguration build(Consumer<Builder> builder) {
            builder.accept(this);
            return this.build();
        }
    }

    public record AllSlotPositions(SlotPositions all, SlotPositions items, SlotPositions itemInputs, SlotPositions itemOutputs, SlotPositions fluids, SlotPositions fluidInputs, SlotPositions fluidOutputs) {
        public boolean hasItems() {
            return this.items.size() > 0;
        }

        public boolean hasFluids() {
            return this.fluids.size() > 0;
        }

        public int inputs() {
            return this.itemInputs.size() + this.fluidInputs.size();
        }

        public boolean hasInputs() {
            return this.inputs() > 0;
        }

        public int outputs() {
            return this.itemOutputs.size() + this.fluidOutputs.size();
        }

        public boolean hasOutputs() {
            return this.outputs() > 0;
        }
    }
}

