/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.lang;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.lang.LangEntry;
import net.swedz.tesseract.neoforge.lang.LangManager;
import net.swedz.tesseract.neoforge.lang.annotation.LangKey;
import net.swedz.tesseract.neoforge.lang.annotation.LangKeyPattern;
import net.swedz.tesseract.neoforge.lang.annotation.Parsed;
import net.swedz.tesseract.neoforge.lang.annotation.WithStyle;
import net.swedz.tesseract.neoforge.lang.exception.UndefinedParserException;
import net.swedz.tesseract.neoforge.lang.exception.UndefinedStyleException;
import net.swedz.tesseract.neoforge.tooltip.Parser;

public final class LangHandler
implements InvocationHandler {
    private static final Pattern METHOD_PATTERN = Pattern.compile("([A-Z][a-z]+)|([a-z]+)|([0-9]+)|([A-Z]+(?![a-z]))");
    private final LangManager manager;
    private Map<String, LangEntry> values = Map.of();
    private static final Method METHOD_EQUALS;
    private static final Method METHOD_HASHCODE;
    private static final Method METHOD_TOSTRING;

    public LangHandler(LangManager manager) {
        this.manager = manager;
    }

    public Collection<LangEntry> entries() {
        return this.values.values().stream().sorted(Comparator.comparing(LangEntry::key)).toList();
    }

    private static String generateLangKey(String methodName) {
        StringBuilder generated = new StringBuilder();
        Matcher matcher = METHOD_PATTERN.matcher(methodName);
        int lastEnd = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (lastEnd < start) {
                generated.append(methodName, lastEnd, start);
            }
            if (!generated.isEmpty()) {
                generated.append('_');
            }
            generated.append(methodName, start, end);
            lastEnd = end;
        }
        return generated.toString().toLowerCase();
    }

    private String createLangKey(Class<?> langClass, Method method) {
        LangKey annotation = method.getAnnotation(LangKey.class);
        Assert.notNull(annotation);
        if (!annotation.value().isEmpty()) {
            return annotation.value().replace("{}", this.manager.modId());
        }
        String prefix = langClass.isAnnotationPresent(LangKeyPattern.class) ? langClass.getAnnotation(LangKeyPattern.class).value() : "text.{}.";
        prefix = prefix.replace("{}", this.manager.modId());
        String key = !annotation.key().isEmpty() ? annotation.key() : LangHandler.generateLangKey(method.getName());
        return prefix + key;
    }

    private Supplier<Style> getStyle(WithStyle annotationStyle) {
        if (annotationStyle != null) {
            Supplier<Style> style = this.manager.getStyle(annotationStyle.value());
            if (style == null) {
                throw new UndefinedStyleException(annotationStyle.value());
            }
            return style;
        }
        return this.manager.getStyle("default");
    }

    private Supplier<Parser<?>>[] getParsers(Method method) {
        Supplier[] parsers = new Supplier[method.getParameterCount()];
        for (int index = 0; index < method.getParameterCount(); ++index) {
            String parserKey;
            Parameter param = method.getParameters()[index];
            Class<?> paramType = param.getType();
            if (param.isAnnotationPresent(Parsed.class)) {
                Parsed annotationParsed = param.getAnnotation(Parsed.class);
                parserKey = annotationParsed.value();
            } else {
                parserKey = "default";
            }
            Supplier<Parser<?>> parser = this.manager.getParser(parserKey, paramType);
            if (parser == null) {
                if (parserKey.equals("default")) {
                    parser = () -> Parser.OBJECT;
                } else {
                    throw new UndefinedParserException(parserKey);
                }
            }
            if (param.isAnnotationPresent(WithStyle.class)) {
                WithStyle annotationStyle = param.getAnnotation(WithStyle.class);
                Supplier<Parser> finalParser = parser::get;
                parser = () -> arg_0 -> this.lambda$getParsers$1(annotationStyle, (Supplier)finalParser, arg_0);
            }
            parsers[index] = parser;
        }
        return parsers;
    }

    void loadValues(Class<?> langClass, Object proxy) {
        HashMap values = Maps.newHashMap();
        for (Method method : langClass.getMethods()) {
            if (!method.isAnnotationPresent(LangKey.class)) continue;
            LangKey annotation = method.getAnnotation(LangKey.class);
            String methodSignature = method.toGenericString();
            if (method.getReturnType().equals(MutableComponent.class)) {
                String key = this.createLangKey(langClass, method);
                Supplier<Style> style = this.getStyle(method.getAnnotation(WithStyle.class));
                Supplier<Parser<?>>[] parsers = this.getParsers(method);
                LangEntry entry = new LangEntry(key, annotation.text().length == 0 ? null : annotation.text()[0], style, parsers);
                if (values.put(methodSignature, entry) == null) continue;
                throw new IllegalStateException("Method with signature %s already exists.".formatted(methodSignature));
            }
            throw new IllegalStateException("Method %s does not return MutableComponent".formatted(methodSignature));
        }
        this.values = Collections.unmodifiableMap(values);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.equals(METHOD_EQUALS)) {
            return proxy == args[0];
        }
        if (method.equals(METHOD_HASHCODE)) {
            return System.identityHashCode(proxy);
        }
        if (method.equals(METHOD_TOSTRING)) {
            return proxy.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
        }
        LangEntry value = this.values.get(method.toGenericString());
        if (value == null) {
            try {
                return InvocationHandler.invokeDefault(proxy, method, args);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        return value.toComponent(args);
    }

    private /* synthetic */ Component lambda$getParsers$1(WithStyle annotationStyle, Supplier finalParser, Object value) {
        Supplier<Style> style = this.getStyle(annotationStyle);
        return ((Parser)finalParser.get()).parse(value).copy().withStyle(style == null ? null : style.get());
    }

    static {
        try {
            METHOD_EQUALS = Object.class.getDeclaredMethod("equals", Object.class);
            METHOD_HASHCODE = Object.class.getDeclaredMethod("hashCode", new Class[0]);
            METHOD_TOSTRING = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }
}

