/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record Bounds(int minX, int minY, int width, int height) {
    public static final Codec<Bounds> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(Bounds::minX), (App)Codec.INT.fieldOf("y").forGetter(Bounds::minY), (App)Codec.INT.fieldOf("width").forGetter(Bounds::width), (App)Codec.INT.fieldOf("height").forGetter(Bounds::height)).apply((Applicative)instance, Bounds::new));
    public static final StreamCodec<ByteBuf, Bounds> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Bounds::minX, (StreamCodec)ByteBufCodecs.VAR_INT, Bounds::minY, (StreamCodec)ByteBufCodecs.VAR_INT, Bounds::width, (StreamCodec)ByteBufCodecs.VAR_INT, Bounds::height, Bounds::new);

    public int maxX() {
        return this.minX + this.width - 1;
    }

    public int maxY() {
        return this.minY + this.height - 1;
    }

    public int relativeX(int x) {
        return x - this.minX;
    }

    public int relativeY(int y) {
        return y - this.minY;
    }

    public boolean contains(int x, int y) {
        return x >= this.minX && x <= this.maxX() && y >= this.minY && y <= this.maxY();
    }

    public boolean overlaps(Bounds other) {
        int minX = other.minX();
        int minY = other.minY();
        int maxX = other.maxX();
        int maxY = other.maxY();
        return this.contains(minX, minY) || this.contains(maxX, minY) || this.contains(minX, maxY) || this.contains(maxX, maxY);
    }

    public boolean contains(Bounds other) {
        int minX = other.minX();
        int minY = other.minY();
        int maxX = other.maxX();
        int maxY = other.maxY();
        return this.contains(minX, minY) && this.contains(maxX, minY) && this.contains(minX, maxY) && this.contains(maxX, maxY);
    }

    public Bounds normalize() {
        return new Bounds(0, 0, this.width, this.height);
    }

    public Bounds move(int x, int y) {
        return new Bounds(this.minX + x, this.minY + y, this.width, this.height);
    }

    public Bounds resize(int width, int height) {
        return new Bounds(this.minX, this.minY, width, height);
    }

    public Bounds grow(int x, int y) {
        return new Bounds(this.minX - x, this.minY - y, this.width + x * 2, this.height + y * 2);
    }

    public Bounds multiply(float multiplicator) {
        return new Bounds((int)((float)this.minX * multiplicator), (int)((float)this.minY * multiplicator), (int)((float)this.width * multiplicator), (int)((float)this.height * multiplicator));
    }

    public Bounds divideFloor(float divisor) {
        return new Bounds((int)((float)this.minX / divisor), (int)((float)this.minY / divisor), (int)((float)this.width / divisor), (int)((float)this.height / divisor));
    }

    public Bounds divideRound(float divisor) {
        return new Bounds(Math.round((float)this.minX / divisor), Math.round((float)this.minY / divisor), Math.round((float)this.width / divisor), Math.round((float)this.height / divisor));
    }

    public Bounds divideCeil(float divisor) {
        return new Bounds((int)Math.ceil((float)this.minX / divisor), (int)Math.ceil((float)this.minY / divisor), (int)Math.ceil((float)this.width / divisor), (int)Math.ceil((float)this.height / divisor));
    }
}

