/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.helper;

import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.util.Simulation;
import java.util.List;

public abstract class EuConsumerBehavior {
    protected final MachineBlockEntity machine;

    public static EuConsumerBehavior steam(MachineBlockEntity machine) {
        return new Steam(machine);
    }

    public static EuConsumerBehavior electric(MachineBlockEntity machine, EnergyComponent energy, RedstoneControlComponent redstone) {
        return new Electric(machine, energy, redstone);
    }

    private EuConsumerBehavior(MachineBlockEntity machine) {
        this.machine = machine;
    }

    public abstract long consumeEu(long var1, Simulation var3);

    private static final class Steam
    extends EuConsumerBehavior {
        private Steam(MachineBlockEntity machine) {
            super(machine);
        }

        @Override
        public long consumeEu(long max, Simulation simulation) {
            return SteamHelper.consumeSteamEu((List)this.machine.getInventory().getFluidStacks(), (long)max, (Simulation)simulation);
        }
    }

    private static final class Electric
    extends EuConsumerBehavior {
        private final EnergyComponent energy;
        private final RedstoneControlComponent redstone;

        private Electric(MachineBlockEntity machine, EnergyComponent energy, RedstoneControlComponent redstone) {
            super(machine);
            this.energy = energy;
            this.redstone = redstone;
        }

        @Override
        public long consumeEu(long max, Simulation simulation) {
            return this.redstone.doAllowNormalOperation(this.machine) ? this.energy.consumeEu(max, simulation) : 0L;
        }
    }
}

