/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.hook;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.BiConsumer;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHookEfficiency;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHookEntrypoint;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHookInstance;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHookListener;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHookRegistry;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHooks;
import net.swedz.tesseract.neoforge.helper.ScanDataHelper;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MIHookEntrypointLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Tesseract API/MIMixinPlugin");
    private static final Type HOOK_ENTRYPOINT = Type.getType(MIHookEntrypoint.class);
    private static boolean LOADED = false;

    public static boolean isLoaded() {
        return LOADED;
    }

    public static void ensureLoaded() {
        if (!MIHookEntrypointLoader.isLoaded()) {
            MIHookEntrypointLoader.load();
        }
    }

    private static <H extends MIHookInstance> boolean registerEntrypoint(ModFileScanData data, ModFileScanData.AnnotationData annotation, Class<?> entrypointClass, Class<H> hookClass, BiConsumer<String, H> register) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (hookClass.isAssignableFrom(entrypointClass)) {
            Class<H> hookClassReference = entrypointClass.asSubclass(hookClass);
            MIHookInstance hook = (MIHookInstance)hookClassReference.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!hook.shouldInitialize()) {
                return true;
            }
            String modId = hook.modId();
            if (modId == null) {
                modId = ((IModInfo)((IModFileInfo)data.getIModInfoData().getFirst()).getMods().getFirst()).getModId();
            }
            LOGGER.info("Registered entrypoint for mod {}: {}", (Object)modId, (Object)hookClassReference.getName());
            register.accept(modId, hook);
            return true;
        }
        return false;
    }

    private static void load() {
        LOADED = true;
        LOGGER.info("Starting MI hook entrypoint loader");
        ScanDataHelper.getAllScanData().stream().flatMap(data -> data.getAnnotations().stream().filter(annotation -> HOOK_ENTRYPOINT.equals((Object)annotation.annotationType())).map(annotation -> Map.entry(data, annotation))).forEach(entry -> {
            ModFileScanData data = (ModFileScanData)entry.getKey();
            ModFileScanData.AnnotationData annotation = (ModFileScanData.AnnotationData)entry.getValue();
            try {
                Class<?> entrypointClass = Class.forName(annotation.memberName());
                boolean registered = false;
                if (MIHookEntrypointLoader.registerEntrypoint(data, annotation, entrypointClass, MIHookListener.class, MIHooks::registerListener)) {
                    registered = true;
                } else if (MIHookEntrypointLoader.registerEntrypoint(data, annotation, entrypointClass, MIHookRegistry.class, MIHooks::registerRegistry)) {
                    registered = true;
                } else if (MIHookEntrypointLoader.registerEntrypoint(data, annotation, entrypointClass, MIHookEfficiency.class, MIHooks::registerEfficiencyListener)) {
                    registered = true;
                }
                if (!registered) {
                    LOGGER.error("MIHookEntrypoint {} does not implement a valid hook entrypoint", (Object)annotation.memberName());
                }
            }
            catch (Throwable ex) {
                LOGGER.error("Exception constructing entrypoint");
                throw new RuntimeException(ex);
            }
        });
        LOGGER.info("Done MI hook entrypoint loader");
    }
}

