/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper.guigraphics;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.swedz.tesseract.neoforge.helper.guigraphics.ColoredGuiGraphics;
import net.swedz.tesseract.neoforge.helper.guigraphics.TextureShaderConfiguration;
import org.jetbrains.annotations.ApiStatus;

public interface BlitGuiGraphics
extends ColoredGuiGraphics {
    public TextureShaderConfiguration getTextureShader();

    public void setTextureShader(TextureShaderConfiguration var1);

    default public void setTextureShader(Supplier<ShaderInstance> shader, VertexFormat.Mode mode, VertexFormat format, Consumer<ShaderInstance> extraSetup) {
        this.setTextureShader(new TextureShaderConfiguration(shader, mode, format, extraSetup));
    }

    default public void setTextureShader(Supplier<ShaderInstance> shader, VertexFormat.Mode mode, VertexFormat format) {
        this.setTextureShader(shader, mode, format, null);
    }

    default public void setTextureShader(Supplier<ShaderInstance> shader, Consumer<ShaderInstance> extraSetup) {
        this.setTextureShader(shader, TextureShaderConfiguration.DEFAULT.mode(), TextureShaderConfiguration.DEFAULT.format(), extraSetup);
    }

    default public void setTextureShader(Supplier<ShaderInstance> shader) {
        this.setTextureShader(shader, null);
    }

    default public void resetTextureShader() {
        this.setTextureShader(TextureShaderConfiguration.DEFAULT);
    }

    public ResourceLocation[] getTextures();

    public void setTextures(ResourceLocation ... var1);

    default public void setTexture(ResourceLocation texture) {
        this.setTextures(texture);
    }

    default public void blit(int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        this.blit(x, y, 0, (float)uOffset, (float)vOffset, uWidth, vHeight, 256, 256);
    }

    default public void blit(int x, int y, int uOffset, int vOffset, int uWidth, int vHeight, int argb) {
        int[] originalColor = this.getColor();
        this.setColor(argb);
        this.blit(x, y, uOffset, vOffset, uWidth, vHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x, int y, int uOffset, int vOffset, int uWidth, int vHeight, int[] rgba) {
        int[] originalColor = this.getColor();
        this.setColor(rgba);
        this.blit(x, y, uOffset, vOffset, uWidth, vHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x, int y, int uOffset, int vOffset, int uWidth, int vHeight, float red, float green, float blue, float alpha) {
        int[] originalColor = this.getColor();
        this.setColor(red, green, blue, alpha);
        this.blit(x, y, uOffset, vOffset, uWidth, vHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x, int y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.blit(x, x + uWidth, y, y + vHeight, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    default public void blit(int x, int y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, int argb) {
        int[] originalColor = this.getColor();
        this.setColor(argb);
        this.blit(x, y, blitOffset, uOffset, vOffset, uWidth, vHeight, textureWidth, textureHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x, int y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, int[] rgba) {
        int[] originalColor = this.getColor();
        this.setColor(rgba);
        this.blit(x, y, blitOffset, uOffset, vOffset, uWidth, vHeight, textureWidth, textureHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x, int y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, float red, float green, float blue, float alpha) {
        int[] originalColor = this.getColor();
        this.setColor(red, green, blue, alpha);
        this.blit(x, y, blitOffset, uOffset, vOffset, uWidth, vHeight, textureWidth, textureHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        this.blit(x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight);
    }

    default public void blit(int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight, int argb) {
        int[] originalColor = this.getColor();
        this.setColor(argb);
        this.blit(x, y, uOffset, vOffset, width, height, textureWidth, textureHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight, int[] rgba) {
        int[] originalColor = this.getColor();
        this.setColor(rgba);
        this.blit(x, y, uOffset, vOffset, width, height, textureWidth, textureHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight, float red, float green, float blue, float alpha) {
        int[] originalColor = this.getColor();
        this.setColor(red, green, blue, alpha);
        this.blit(x, y, uOffset, vOffset, width, height, textureWidth, textureHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.blit(x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    default public void blit(int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, int argb) {
        int[] originalColor = this.getColor();
        this.setColor(argb);
        this.blit(x, y, width, height, uOffset, vOffset, uWidth, vHeight, textureWidth, textureHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, int[] rgba) {
        int[] originalColor = this.getColor();
        this.setColor(rgba);
        this.blit(x, y, width, height, uOffset, vOffset, uWidth, vHeight, textureWidth, textureHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, float red, float green, float blue, float alpha) {
        int[] originalColor = this.getColor();
        this.setColor(red, green, blue, alpha);
        this.blit(x, y, width, height, uOffset, vOffset, uWidth, vHeight, textureWidth, textureHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x1, int x2, int y1, int y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        this.innerBlit(x1, x2, y1, y2, blitOffset, uOffset / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, vOffset / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight);
    }

    default public void blit(int x1, int x2, int y1, int y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight, int argb) {
        int[] originalColor = this.getColor();
        this.setColor(argb);
        this.blit(x1, x2, y1, y2, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x1, int x2, int y1, int y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight, int[] rgba) {
        int[] originalColor = this.getColor();
        this.setColor(rgba);
        this.blit(x1, x2, y1, y2, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
        this.setColor(originalColor);
    }

    default public void blit(int x1, int x2, int y1, int y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight, float red, float green, float blue, float alpha) {
        int[] originalColor = this.getColor();
        this.setColor(red, green, blue, alpha);
        this.blit(x1, x2, y1, y2, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
        this.setColor(originalColor);
    }

    default public void nineSlice(int screenX, int screenY, int screenWidth, int screenHeight, int textureWidth, int textureHeight, int border) {
        int i;
        int texCenterWidth = textureWidth - border * 2;
        int texCenterHeight = textureHeight - border * 2;
        this.blit(screenX, screenY, 0.0f, 0.0f, border, border, textureWidth, textureHeight);
        this.blit(screenX + screenWidth - border, screenY, textureWidth - border, 0.0f, border, border, textureWidth, textureHeight);
        this.blit(screenX, screenY + screenHeight - border, 0.0f, textureHeight - border, border, border, textureWidth, textureHeight);
        this.blit(screenX + screenWidth - border, screenY + screenHeight - border, textureWidth - border, textureHeight - border, border, border, textureWidth, textureHeight);
        for (i = 0; i <= screenWidth / texCenterWidth; ++i) {
            int x = screenX + border + i * texCenterWidth;
            int width = Math.min(texCenterWidth, screenWidth - i * texCenterWidth - border * 2);
            this.blit(x, screenY, border, 0.0f, width, border, textureWidth, textureHeight);
            this.blit(x, screenY + screenHeight - border, border, textureHeight - border, width, border, textureWidth, textureHeight);
        }
        for (i = 0; i <= screenHeight / texCenterHeight; ++i) {
            int y = screenY + border + i * texCenterHeight;
            int height = Math.min(texCenterHeight, screenHeight - i * texCenterHeight - border * 2);
            this.blit(screenX, y, 0.0f, border, border, height, textureWidth, textureHeight);
            this.blit(screenX + screenWidth - border, y, textureWidth - border, border, border, height, textureWidth, textureHeight);
        }
        int centerWidth = (screenWidth - border * 2) / texCenterWidth;
        int centerHeight = (screenHeight - border * 2) / texCenterHeight;
        for (int ix = 0; ix <= centerWidth; ++ix) {
            for (int iy = 0; iy <= centerHeight; ++iy) {
                int x = screenX + border + ix * texCenterWidth;
                int y = screenY + border + iy * texCenterHeight;
                int width = Math.min(texCenterWidth, screenWidth - ix * texCenterWidth - border * 2);
                int height = Math.min(texCenterHeight, screenHeight - iy * texCenterHeight - border * 2);
                this.blit(x, y, border, border, width, height, textureWidth, textureHeight);
            }
        }
    }

    @ApiStatus.Internal
    public void innerBlit(int var1, int var2, int var3, int var4, int var5, float var6, float var7, float var8, float var9);
}

