/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper.guigraphics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.swedz.tesseract.neoforge.helper.guigraphics.ColoredGuiGraphics;
import net.swedz.tesseract.neoforge.helper.guigraphics.SizedGuiGraphics;
import net.swedz.tesseract.neoforge.helper.guigraphics.StringGuiGraphics;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;
import net.swedz.tesseract.neoforge.helper.guigraphics.WrappedGuiGraphics;
import org.jetbrains.annotations.ApiStatus;

public interface TooltipGuiGraphics
extends ColoredGuiGraphics,
StringGuiGraphics,
SizedGuiGraphics,
WrappedGuiGraphics {
    public boolean isTooltipFirstLinePadded();

    public void setTooltipFirstLinePadded(boolean var1);

    public BackgroundPadding getTooltipBackgroundPadding();

    public void setTooltipBackgroundPadding(BackgroundPadding var1);

    default public void setTooltipBackgroundPadding(int top, int bottom, int left, int right) {
        this.setTooltipBackgroundPadding(new BackgroundPadding(top, bottom, left, right));
    }

    default public void resetTooltipBackgroundPadding() {
        this.setTooltipBackgroundPadding(new BackgroundPadding());
    }

    default public void renderTooltip(List<Component> lines, int x, int y, ResourceLocation backgroundAsset, int textureWidth, int textureHeight, int border) {
        this.renderTooltipBounded(lines, x, y, 0, 0, this.guiWidth(), this.guiHeight(), backgroundAsset, textureWidth, textureHeight, border);
    }

    default public void renderTooltip(List<Component> lines, int x, int y) {
        this.renderTooltipBounded(lines, x, y, 0, 0, this.guiWidth(), this.guiHeight());
    }

    default public void renderTooltip(List<Component> lines, int x, int y, int backgroundTopColor, int backgroundBottomColor, int borderTopColor, int borderBottomColor) {
        this.renderTooltipBounded(lines, x, y, 0, 0, this.guiWidth(), this.guiHeight(), backgroundTopColor, backgroundBottomColor, borderTopColor, borderBottomColor);
    }

    default public void renderTooltipBounded(List<Component> lines, int x, int y, int minWidth, int minHeight, int maxWidth, int maxHeight, ResourceLocation backgroundAsset, int textureWidth, int textureHeight, int border) {
        this.renderTooltipBoundedInternal(lines, x, y, minWidth, minHeight, maxWidth, maxHeight, new NineSpliceBackground(this.internal(), this.getTooltipBackgroundPadding(), backgroundAsset, textureWidth, textureHeight, border));
    }

    default public void renderTooltipBounded(List<Component> lines, int x, int y, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        this.renderTooltipBoundedInternal(lines, x, y, minWidth, minHeight, maxWidth, maxHeight, new VanillaBackground(this.internal(), this.getTooltipBackgroundPadding()));
    }

    default public void renderTooltipBounded(List<Component> lines, int x, int y, int minWidth, int minHeight, int maxWidth, int maxHeight, int backgroundTopColor, int backgroundBottomColor, int borderTopColor, int borderBottomColor) {
        this.renderTooltipBoundedInternal(lines, x, y, minWidth, minHeight, maxWidth, maxHeight, new VanillaBackground(this.internal(), this.getTooltipBackgroundPadding(), backgroundTopColor, backgroundBottomColor, borderTopColor, borderBottomColor));
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    default public void renderTooltipBoundedInternal(List<Component> lines, int x, int y, int minWidth, int minHeight, int maxWidth, int maxHeight, Background background) {
        int n;
        int n2;
        void var11_14;
        int width = 0;
        for (Component component : lines) {
            int lineWidth = this.getFont().width((FormattedText)component);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        if (x + width > maxWidth) {
            width = maxWidth - x - this.getTooltipBackgroundPadding().right() - 2;
        }
        if (width < minWidth) {
            width = minWidth;
        }
        ArrayList splitLines = Lists.newArrayList();
        for (Component line : lines) {
            if (line.equals((Object)Component.empty())) {
                splitLines.add(line.getVisualOrderText());
                continue;
            }
            splitLines.addAll(this.getFont().split((FormattedText)line, width));
        }
        boolean bl = false;
        int lineIndex = 0;
        for (FormattedCharSequence line : splitLines) {
            var11_14 += 10 + (this.isTooltipFirstLinePadded() && lineIndex == 0 ? 2 : 0);
            ++lineIndex;
        }
        if (y + var11_14 > maxHeight) {
            n2 = maxHeight - y - this.getTooltipBackgroundPadding().bottom() - 2;
        }
        if (n2 < minHeight) {
            n = minHeight;
        }
        this.renderTooltipInternal(splitLines, x, y, width, n, background);
    }

    @ApiStatus.Internal
    default public void renderTooltipInternal(List<FormattedCharSequence> lines, int x, int y, int width, int height, Background background) {
        background.render(x, y, width, height);
        this.renderTooltipTextInternal(lines, x, y, width, height);
    }

    @ApiStatus.Internal
    default public void renderTooltipTextInternal(List<FormattedCharSequence> lines, int x, int y, int width, int height) {
        this.internal().pose().pushPose();
        this.internal().pose().translate(0.0f, 0.0f, 400.0f);
        int textHeight = 0;
        int lineIndex = 0;
        for (FormattedCharSequence line : lines) {
            int textY = y + textHeight;
            int lineHeight = 10 + (this.isTooltipFirstLinePadded() && lineIndex == 0 ? 2 : 0);
            if (textHeight + lineHeight > height) {
                this.getFont().drawInBatch((Component)Component.literal((String)"..."), (float)x, (float)textY, this.getColorARGB(), this.isStringDropShadow(), this.internal().pose().last().pose(), (MultiBufferSource)this.internal().bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                break;
            }
            this.getFont().drawInBatch(line, (float)x, (float)textY, this.getColorARGB(), this.isStringDropShadow(), this.internal().pose().last().pose(), (MultiBufferSource)this.internal().bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            textHeight += lineHeight;
            ++lineIndex;
        }
        this.internal().pose().popPose();
    }

    public record BackgroundPadding(int top, int bottom, int left, int right) {
        public BackgroundPadding() {
            this(3, 3, 3, 3);
        }
    }

    public static final class NineSpliceBackground
    extends Background {
        private final ResourceLocation asset;
        private final int textureWidth;
        private final int textureHeight;
        private final int border;

        private NineSpliceBackground(GuiGraphics internal, BackgroundPadding padding, ResourceLocation asset, int textureWidth, int textureHeight, int border) {
            super(internal, padding);
            this.asset = asset;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.border = border;
        }

        @Override
        public GuiGraphics internal() {
            return this.internal;
        }

        @Override
        public void render(int x, int y, int width, int height) {
            TesseractGuiGraphics graphics = new TesseractGuiGraphics(this.internal);
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 400.0f);
            graphics.setTexture(this.asset);
            graphics.nineSlice(x - this.padding.left(), y - this.padding.top(), width + this.padding.left() + this.padding.right(), height + this.padding.top() + this.padding.bottom(), this.textureWidth, this.textureHeight, this.border);
            graphics.pose().popPose();
        }
    }

    public static abstract class Background
    implements WrappedGuiGraphics {
        protected final GuiGraphics internal;
        protected final BackgroundPadding padding;

        public Background(GuiGraphics internal, BackgroundPadding padding) {
            this.internal = internal;
            this.padding = padding;
        }

        public abstract void render(int var1, int var2, int var3, int var4);
    }

    public static final class VanillaBackground
    extends Background {
        private final int backgroundTopColor;
        private final int backgroundBottomColor;
        private final int borderTopColor;
        private final int borderBottomColor;

        private VanillaBackground(GuiGraphics internal, BackgroundPadding padding, int backgroundTopColor, int backgroundBottomColor, int borderTopColor, int borderBottomColor) {
            super(internal, padding);
            this.backgroundTopColor = backgroundTopColor;
            this.backgroundBottomColor = backgroundBottomColor;
            this.borderTopColor = borderTopColor;
            this.borderBottomColor = borderBottomColor;
        }

        private VanillaBackground(GuiGraphics internal, BackgroundPadding padding) {
            this(internal, padding, -267386864, -267386864, 0x505000FF, 1344798847);
        }

        @Override
        public GuiGraphics internal() {
            return this.internal;
        }

        @Override
        public void render(int x, int y, int width, int height) {
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)this.internal, (int)(x + 3 - this.padding.left()), (int)(y + 3 - this.padding.top()), (int)(width - 6 + this.padding.left() + this.padding.right()), (int)(height - 6 + this.padding.top() + this.padding.bottom()), (int)400, (int)this.backgroundTopColor, (int)this.backgroundBottomColor, (int)this.borderTopColor, (int)this.borderBottomColor);
        }
    }
}

