/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.builder;

import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.compat.rei.machines.SteamMode;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.compat.mi.hack.HackedMachineRegistrationHelper;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHook;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.MachineBuiltinModelBuilder;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.MachineWithGuiBuilder;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockEntityFactory;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockEntityWithGuiFactory;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockRegistrators;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineGuiConfigurator;

public final class SpecialMachineBuilder
extends MachineWithGuiBuilder<SpecialMachineBuilder> {
    private final boolean isMultiblock;
    private final MachineBlockEntityFactory blockEntityFactory;
    private boolean isRecipeCategoryRegistered;

    SpecialMachineBuilder(MIHook hook, String name, String englishName, boolean isMultiblock, MachineBlockEntityWithGuiFactory blockEntityFactory) {
        super(hook, name, englishName);
        Assert.notNull(blockEntityFactory);
        this.isMultiblock = isMultiblock;
        this.blockEntityFactory = bep -> blockEntityFactory.create(bep, this.gui);
    }

    @Override
    public SpecialMachineBuilder builtinModel(MachineCasing casing, String overlayFolder, Consumer<MachineBuiltinModelBuilder> builder) {
        return (SpecialMachineBuilder)super.builtinModel(casing, overlayFolder, (MachineBuiltinModelBuilder b) -> {
            b.front().active();
            if (builder != null) {
                builder.accept((MachineBuiltinModelBuilder)b);
            }
        });
    }

    public SpecialMachineBuilder builtinModel(String overlayFolder, Consumer<MachineBuiltinModelBuilder> builder) {
        return this.builtinModel((MachineCasing)null, overlayFolder, (Consumer)builder);
    }

    public SpecialMachineBuilder builtinModel(String overlayFolder) {
        return this.builtinModel(overlayFolder, null);
    }

    public SpecialMachineBuilder gui(SteamMode steamMode, MachineRecipeType recipeType, MachineGuiConfigurator builder) {
        return (SpecialMachineBuilder)this.gui(this.isMultiblock, steamMode, recipeType, builder);
    }

    public SpecialMachineBuilder gui(MachineGuiConfigurator builder) {
        return this.gui(null, null, builder);
    }

    @Override
    protected void internalRegister() {
        HackedMachineRegistrationHelper.registerMachine(this.hook, this.englishName, this.name, this.blockFactory, this.holderModifier, this.propertiesModifier, this.defaultMineableTags, this.blockEntityFactory, (MachineBlockRegistrators[])this.registrators.toArray(MachineBlockRegistrators[]::new));
        if (this.builtinModel != null) {
            this.builtinModel.build(this.hook, this.name);
        }
    }

    public SpecialMachineBuilder registerMultiblockShape(ShapeTemplate shape, String alternative) {
        Assert.that(this.isMultiblock, "Multiblock shapes can only be registered on multiblock machines");
        Assert.notNull(shape);
        ReiMachineRecipes.registerMultiblockShape((ResourceLocation)this.hook.id(this.name), (ShapeTemplate)shape, (String)alternative);
        return this;
    }

    public SpecialMachineBuilder registerMultiblockShape(ShapeTemplate shape) {
        return this.registerMultiblockShape(shape, null);
    }

    public SpecialMachineBuilder registerRecipeCategory() {
        Assert.that(!this.isRecipeCategoryRegistered, "This recipe category is already registered");
        this.isRecipeCategoryRegistered = true;
        if (this.gui != null && this.gui.hasRecipeCategory()) {
            this.gui.registerRecipeCategory(this.hook, this.name, this.englishName);
        }
        return this;
    }

    public SpecialMachineBuilder registerExtraWorkstations(ResourceLocation ... workstations) {
        Assert.notNull(workstations);
        if (this.gui != null && this.gui.hasRecipeCategory()) {
            for (ResourceLocation workstation : workstations) {
                Assert.notNull(workstation);
                ReiMachineRecipes.registerWorkstation((ResourceLocation)this.hook.id(this.name), (ResourceLocation)workstation);
            }
        }
        return this;
    }

    public SpecialMachineBuilder registerAsWorkstationFor(ResourceLocation otherMachineId) {
        Assert.notNull(otherMachineId);
        ReiMachineRecipes.registerWorkstation((ResourceLocation)otherMachineId, (ResourceLocation)this.hook.id(this.name));
        return this;
    }
}

