/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.material.builtin.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.swedz.tesseract.neoforge.compat.vanilla.recipe.ShapedRecipeBuilder;
import net.swedz.tesseract.neoforge.compat.vanilla.recipe.ShapelessRecipeBuilder;
import net.swedz.tesseract.neoforge.compat.vanilla.recipe.SmeltingRecipeBuilder;
import net.swedz.tesseract.neoforge.material.Material;
import net.swedz.tesseract.neoforge.material.MaterialRegistry;
import net.swedz.tesseract.neoforge.material.part.MaterialPart;
import net.swedz.tesseract.neoforge.material.property.MaterialPropertyMap;
import net.swedz.tesseract.neoforge.material.recipe.MaterialRecipeContext;

public class VanillaMaterialRecipeContext
extends MaterialRecipeContext {
    public VanillaMaterialRecipeContext(MaterialRegistry registry, Material material, RecipeOutput recipes) {
        super(registry, material, recipes);
    }

    public VanillaMaterialRecipeContext shapeless(MaterialPart input, int inputCount, MaterialPart output, int outputCount, boolean inverse) {
        if (this.has(input, output)) {
            Item inputItem = this.material.get(input).asItem();
            Item outputItem = this.material.get(output).asItem();
            ShapelessRecipeBuilder recipe = new ShapelessRecipeBuilder();
            for (int i = 0; i < inputCount; ++i) {
                recipe.with(new ItemLike[]{inputItem});
            }
            recipe.output((ItemLike)outputItem, outputCount);
            recipe.offerTo(this.recipes, this.id("materials/%s/craft/%s_from_%s".formatted(this.material.id().getPath(), output.id().getPath(), input.id().getPath())));
            if (inverse) {
                this.shapeless(output, outputCount, input, inputCount, false);
            }
        }
        return this;
    }

    public VanillaMaterialRecipeContext compacting(MaterialPart input, MaterialPart output, boolean inverse) {
        if (this.has(input, output)) {
            this.shaped(output, 1, r -> r.add('#', (ItemLike)this.material.get(input).asItem()), "###", "###", "###");
            if (inverse) {
                this.shapeless(output, 1, input, 9, false);
            }
        }
        return this;
    }

    public VanillaMaterialRecipeContext shaped(MaterialPart output, int outputCount, Consumer<ShapedRecipeMap> keyMapAction, String ... pattern) {
        ShapedRecipeMap keyMap = new ShapedRecipeMap(pattern);
        keyMapAction.accept(keyMap);
        HashSet parts = Sets.newHashSet(keyMap.involvedParts);
        parts.add(output);
        if (this.has(parts.toArray(new MaterialPart[0]))) {
            Item outputItem = this.material.get(output).asItem();
            String id = output.id().getPath();
            ShapedRecipeBuilder recipe = new ShapedRecipeBuilder().output((ItemLike)outputItem, outputCount);
            keyMap.apply(recipe);
            recipe.offerTo(this.recipes, this.id("materials/%s/craft/%s".formatted(this.material.id().getPath(), id)));
        }
        return this;
    }

    public VanillaMaterialRecipeContext smelting(MaterialPart input, MaterialPart output, boolean blasting, float experience) {
        if (this.has(input, output)) {
            new SmeltingRecipeBuilder().input(Ingredient.of((ItemLike[])new ItemLike[]{this.material.get(output).asItem()})).output((ItemLike)this.material.get(input).asItem(), 1).cookingTime(blasting ? 100 : 200).experience(experience).offerTo(this.recipes, this.id("materials/%s/smelting/%s_to_%s_%s".formatted(this.material.id().getPath(), input.id().getPath(), output.id().getPath(), blasting ? "blasting" : "smelting")));
        }
        return this;
    }

    public VanillaMaterialRecipeContext smelting(MaterialPart input, MaterialPart output, float experience) {
        return this.smelting(input, output, false, experience);
    }

    public VanillaMaterialRecipeContext blasting(MaterialPart input, MaterialPart output, float experience) {
        return this.smelting(input, output, true, experience);
    }

    public VanillaMaterialRecipeContext smeltingAndBlasting(MaterialPart input, MaterialPart output, float experience) {
        this.smelting(input, output, experience);
        this.blasting(input, output, experience);
        return this;
    }

    public final class ShapedRecipeMap {
        private final String[] pattern;
        private final List<Consumer<ShapedRecipeBuilder>> actions = Lists.newArrayList();
        private final Set<MaterialPart> involvedParts = Sets.newHashSet();

        public ShapedRecipeMap(String ... pattern) {
            this.pattern = pattern;
        }

        public ShapedRecipeMap add(char key, ItemLike item) {
            this.actions.add(r -> r.define(key, item));
            return this;
        }

        public ShapedRecipeMap add(char key, TagKey<Item> tag) {
            this.actions.add(r -> r.define(key, tag));
            return this;
        }

        public ShapedRecipeMap add(char key, MaterialPart part) {
            this.involvedParts.add(part);
            MaterialPropertyMap properties = VanillaMaterialRecipeContext.this.material.properties(part);
            this.actions.add(r -> r.define(key, VanillaMaterialRecipeContext.this.material.get(part).itemReference()));
            return this;
        }

        private void apply(ShapedRecipeBuilder recipe) {
            for (String line : this.pattern) {
                recipe.pattern(line);
            }
            this.actions.forEach(action -> action.accept(recipe));
        }
    }
}

