/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.hack;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.compat.rei.machines.MachineCategoryParams;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.compat.rei.machines.SteamMode;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.ElectricCraftingMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.SteamCraftingMachineBlockEntity;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.guicomponents.RecipeEfficiencyBar;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.init.SingleBlockCraftingMachines;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.MobSpawning;
import aztech.modern_industrialization.util.Rectangle;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.swedz.tesseract.neoforge.compat.mi.hack.FakedMachineModelBuilder;
import net.swedz.tesseract.neoforge.compat.mi.helper.MachineInventoryHelper;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHook;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHookRegistry;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHookTracker;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockEntityFactory;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockFactory;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockHolderModifier;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockPropertiesModifier;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockRegistrators;
import net.swedz.tesseract.neoforge.compat.mi.mixin.accessor.MIMachineRecipeTypesAccessor;
import net.swedz.tesseract.neoforge.registry.common.CommonLootTableBuilders;
import net.swedz.tesseract.neoforge.registry.common.CommonModelBuilders;
import net.swedz.tesseract.neoforge.registry.holder.BlockWithItemHolder;

public final class HackedMachineRegistrationHelper {
    public static Supplier<BlockEntityType<?>> registerMachine(MIHook hook, String englishName, String name, MachineBlockFactory blockFactory, MachineBlockHolderModifier holderModifier, MachineBlockPropertiesModifier overrideProperties, boolean defaultMineableTags, MachineBlockEntityFactory factory, MachineBlockRegistrators ... extraRegistrators) {
        MIHookRegistry registry = hook.registry();
        ResourceLocation id = hook.id(name);
        AtomicReference bet = new AtomicReference();
        BiFunction<BlockPos, BlockState, MachineBlockEntity> ctor = (pos, state) -> factory.create(new BEP((BlockEntityType)bet.get(), pos, state));
        BlockWithItemHolder<MachineBlock, BlockItem> blockHolder = new BlockWithItemHolder<MachineBlock, BlockItem>(id, englishName, registry.blockRegistry(), p -> blockFactory == null ? new MachineBlock(ctor, p) : blockFactory.create(ctor, (BlockBehaviour.Properties)p), registry.itemRegistry(), BlockItem::new);
        blockHolder.item().sorted(registry.sortOrderMachines());
        if (defaultMineableTags) {
            blockHolder.tag(BlockTags.NEEDS_STONE_TOOL, BlockTags.MINEABLE_WITH_PICKAXE);
        }
        blockHolder.withLootTable(CommonLootTableBuilders::self).withProperties(properties -> {
            if (overrideProperties != null) {
                overrideProperties.modify((BlockBehaviour.Properties)properties);
            } else {
                HackedMachineRegistrationHelper.applyDefaultMachineProperties(properties);
            }
        }).withModel(holder -> provider -> {
            MIHookTracker.MachineModelProperties machineModelProperties = MIHookTracker.getMachineModel(id);
            if (machineModelProperties == null) {
                CommonModelBuilders.blockstateOnly(holder).accept((BlockStateProvider)provider);
                return;
            }
            provider.simpleBlockWithItem((Block)BuiltInRegistries.BLOCK.get(id), (ModelFile)((FakedMachineModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name)).customLoader((bmb, exFile) -> new FakedMachineModelBuilder<BlockModelBuilder>(machineModelProperties, (BlockModelBuilder)bmb, (ExistingFileHelper)exFile))).end());
        });
        if (holderModifier != null) {
            holderModifier.modify(blockHolder);
        }
        blockHolder.register();
        registry.onBlockRegister(blockHolder);
        registry.onItemRegister(blockHolder.item());
        return registry.blockEntityRegistry().register(name, () -> {
            Object block = blockHolder.get();
            bet.set(BlockEntityType.Builder.of(ctor::apply, (Block[])new Block[]{block}).build(null));
            for (MachineBlockRegistrators extraRegistrator : extraRegistrators) {
                extraRegistrator.apply((BlockEntityType)bet.get());
            }
            registry.onBlockEntityRegister((BlockEntityType)bet.get());
            return (BlockEntityType)bet.get();
        });
    }

    public static Supplier<BlockEntityType<?>> registerMachine(MIHook hook, String englishName, String name, MachineBlockFactory blockCreator, MachineBlockHolderModifier modifyBlock, MachineBlockPropertiesModifier overrideProperties, MachineBlockEntityFactory factory, MachineBlockRegistrators ... extraRegistrators) {
        return HackedMachineRegistrationHelper.registerMachine(hook, englishName, name, blockCreator, modifyBlock, overrideProperties, true, factory, extraRegistrators);
    }

    public static Supplier<BlockEntityType<?>> registerMachine(MIHook hook, String englishName, String name, MachineBlockEntityFactory factory, MachineBlockRegistrators ... extraRegistrators) {
        return HackedMachineRegistrationHelper.registerMachine(hook, englishName, name, null, null, null, factory, extraRegistrators);
    }

    public static void applyDefaultMachineProperties(BlockBehaviour.Properties properties) {
        properties.mapColor(MapColor.METAL).destroyTime(4.0f).requiresCorrectToolForDrops().isValidSpawn(MobSpawning.NO_SPAWN).isRedstoneConductor(Blocks::never);
    }

    public static void addMachineModel(MIHook hook, String name, MachineCasing defaultCasing, String overlay, boolean front, boolean top, boolean side, boolean active) {
        MIHookTracker.addMachineModel(hook.id(name), defaultCasing, overlay, front, top, side, active);
    }

    public static void addMachineModel(MIHook hook, String name, MachineCasing defaultCasing, String overlay, boolean front, boolean top, boolean side) {
        HackedMachineRegistrationHelper.addMachineModel(hook, name, defaultCasing, overlay, front, top, side, true);
    }

    public static void addMachineModel(MIHook hook, String name, MachineTier tier, String overlay, boolean front, boolean top, boolean side, boolean active) {
        MachineCasing defaultCasing = switch (tier) {
            case MachineTier.BRONZE -> MachineCasings.BRONZE;
            case MachineTier.STEEL -> MachineCasings.STEEL;
            case MachineTier.LV -> CableTier.LV.casing;
            default -> throw new RuntimeException("Invalid tier: " + String.valueOf(tier));
        };
        HackedMachineRegistrationHelper.addMachineModel(hook, name, defaultCasing, overlay, front, top, side, active);
    }

    public static void addMachineModel(MIHook hook, String name, MachineTier tier, String overlay, boolean front, boolean top, boolean side) {
        HackedMachineRegistrationHelper.addMachineModel(hook, name, tier, overlay, front, top, side, true);
    }

    public static void registerMachineTiers(MIHook hook, String englishName, String machineName, MachineRecipeType type, int itemInputCount, int itemOutputCount, int fluidInputCount, int fluidOutputCount, Consumer<MachineGuiParameters.Builder> guiParams, ProgressBar.Parameters progressBarParams, RecipeEfficiencyBar.Parameters efficiencyBarParams, EnergyBar.Parameters energyBarParams, Consumer<SlotPositions.Builder> itemPositions, Consumer<SlotPositions.Builder> fluidPositions, boolean frontOverlay, boolean topOverlay, boolean sideOverlay, int tiers, int ioBucketCapacity, SingleBlockCraftingMachines.Config extraConfig) {
        SlotPositions fluids;
        for (int i = 0; i < 2; ++i) {
            if (i == 0 && (tiers & 1) == 0 || i == 1 && (tiers & 2) == 0) continue;
            SlotPositions items = new SlotPositions.Builder().buildWithConsumer(itemPositions);
            SlotPositions fluids2 = new SlotPositions.Builder().addSlot(12, 35).buildWithConsumer(fluidPositions);
            MachineTier tier = i == 0 ? MachineTier.BRONZE : MachineTier.STEEL;
            String prefix = i == 0 ? "bronze" : "steel";
            String englishPrefix = i == 0 ? "Bronze " : "Steel ";
            int steamBuckets = i == 0 ? 2 : 4;
            String id = prefix + "_" + machineName;
            MachineGuiParameters.Builder guiParamsBuilder = new MachineGuiParameters.Builder(hook.id(id), true);
            guiParams.accept(guiParamsBuilder);
            MachineGuiParameters builtGuiParams = guiParamsBuilder.build();
            HackedMachineRegistrationHelper.registerMachine(hook, englishPrefix + englishName, id, (BEP bet) -> new SteamCraftingMachineBlockEntity(bet, type, MachineInventoryHelper.buildInventoryComponent(itemInputCount, itemOutputCount, fluidInputCount, fluidOutputCount, items, fluids2, steamBuckets, ioBucketCapacity), builtGuiParams, progressBarParams, tier, extraConfig.steamOverclockCatalysts), bet -> {
                if (itemInputCount + itemOutputCount > 0) {
                    MachineBlockEntity.registerItemApi((BlockEntityType)bet);
                }
                MachineBlockEntity.registerFluidApi((BlockEntityType)bet);
            });
            HackedMachineRegistrationHelper.addMachineModel(hook, id, tier, machineName, frontOverlay, topOverlay, sideOverlay);
        }
        if ((tiers & 4) > 0) {
            SlotPositions items = new SlotPositions.Builder().buildWithConsumer(itemPositions);
            fluids = new SlotPositions.Builder().buildWithConsumer(fluidPositions);
            Object id = tiers == 4 ? machineName : "electric_" + machineName;
            MachineGuiParameters.Builder guiParamsBuilder = new MachineGuiParameters.Builder(hook.id((String)id), true);
            guiParams.accept(guiParamsBuilder);
            MachineGuiParameters builtGuiParams = guiParamsBuilder.build();
            Object electricEnglishName = englishName;
            if ((tiers & 1) > 0 | (tiers & 2) > 0) {
                electricEnglishName = "Electric " + englishName;
            }
            HackedMachineRegistrationHelper.registerMachine(hook, (String)electricEnglishName, (String)id, (BEP bet) -> new ElectricCraftingMachineBlockEntity(bet, type, MachineInventoryHelper.buildInventoryComponent(itemInputCount, itemOutputCount, fluidInputCount, fluidOutputCount, items, fluids, 0, ioBucketCapacity), builtGuiParams, energyBarParams, progressBarParams, efficiencyBarParams, MachineTier.LV, 3200L), bet -> {
                ElectricCraftingMachineBlockEntity.registerEnergyApi((BlockEntityType)bet);
                if (itemInputCount + itemOutputCount > 0) {
                    MachineBlockEntity.registerItemApi((BlockEntityType)bet);
                }
                if (fluidInputCount + fluidOutputCount > 0) {
                    MachineBlockEntity.registerFluidApi((BlockEntityType)bet);
                }
            });
            HackedMachineRegistrationHelper.addMachineModel(hook, (String)id, MachineTier.LV, machineName, frontOverlay, topOverlay, sideOverlay);
        }
        SlotPositions items = new SlotPositions.Builder().buildWithConsumer(itemPositions);
        fluids = new SlotPositions.Builder().buildWithConsumer(fluidPositions);
        HackedMachineRegistrationHelper.registerReiTiers(hook, englishName, machineName, type, new MachineCategoryParams(null, null, items.sublist(0, itemInputCount), items.sublist(itemInputCount, itemInputCount + itemOutputCount), fluids.sublist(0, fluidInputCount), fluids.sublist(fluidInputCount, fluidInputCount + fluidOutputCount), progressBarParams, null, null, false, SteamMode.BOTH), tiers);
    }

    public static void registerRecipeCategory(MIHook hook, String id, String englishName, MachineRecipeType recipeType, MachineCategoryParams params) {
        ResourceLocation machineId = hook.id(id);
        params = new MachineCategoryParams(englishName, machineId, params.itemInputs, params.itemOutputs, params.fluidInputs, params.fluidOutputs, params.progressBarParams, recipeType, params.recipePredicate, params.isMultiblock, params.steamMode);
        MIHookTracker.addReiCategoryName(machineId, englishName);
        ReiMachineRecipes.registerCategory((ResourceLocation)machineId, (MachineCategoryParams)params);
        ReiMachineRecipes.registerMachineClickArea((ResourceLocation)machineId, (Rectangle)params.progressBarParams.toRectangle());
        params.workstations.add(machineId);
        ReiMachineRecipes.registerRecipeCategoryForMachine((ResourceLocation)machineId, (ResourceLocation)params.category);
    }

    public static void registerRecipeCategory(MIHook hook, String id, String englishName, MachineRecipeType recipeType, SlotPositions itemInputs, SlotPositions itemOutputs, SlotPositions fluidInputs, SlotPositions fluidOutputs, ProgressBar.Parameters progressBarParams, Predicate<MachineRecipe> recipePredicate, boolean isMultiblock, SteamMode steamMode) {
        ResourceLocation machineId = hook.id(id);
        HackedMachineRegistrationHelper.registerRecipeCategory(hook, id, englishName, recipeType, new MachineCategoryParams(null, null, itemInputs, itemOutputs, fluidInputs, fluidOutputs, progressBarParams, null, recipePredicate, isMultiblock, steamMode));
    }

    public static void registerReiTiers(MIHook hook, String englishName, String machine, MachineRecipeType recipeType, MachineCategoryParams categoryParams, int tiers) {
        ArrayList<MachineCategoryParams> previousCategories = new ArrayList<MachineCategoryParams>();
        int previousMaxEu = 0;
        for (int i = 0; i < 3; ++i) {
            int maxEu;
            if ((tiers >> i & 1) <= 0) continue;
            int minEu = previousMaxEu + 1;
            int n = i == 0 ? 2 : (maxEu = i == 1 ? 4 : Integer.MAX_VALUE);
            String prefix = i == 0 ? "bronze_" : (i == 1 ? "steel_" : (tiers == 4 ? "" : "electric_"));
            ResourceLocation itemId = hook.id(prefix + machine);
            String englishPrefix = i == 0 ? "Bronze " : (i == 1 ? "Steel " : "Electric ");
            String fullEnglishName = tiers == 4 || previousMaxEu == 0 ? englishName : englishPrefix + englishName;
            MachineCategoryParams category = new MachineCategoryParams(fullEnglishName, itemId, categoryParams.itemInputs, categoryParams.itemOutputs, categoryParams.fluidInputs, categoryParams.fluidOutputs, categoryParams.progressBarParams, recipeType, recipe -> minEu <= recipe.eu && recipe.eu <= maxEu, false, i < 2 ? SteamMode.BOTH : SteamMode.ELECTRIC_ONLY);
            MIHookTracker.addReiCategoryName(itemId, fullEnglishName);
            ReiMachineRecipes.registerCategory((ResourceLocation)itemId, (MachineCategoryParams)category);
            ReiMachineRecipes.registerMachineClickArea((ResourceLocation)itemId, (Rectangle)categoryParams.progressBarParams.toRectangle());
            previousCategories.add(category);
            for (MachineCategoryParams param : previousCategories) {
                param.workstations.add(itemId);
                ReiMachineRecipes.registerRecipeCategoryForMachine((ResourceLocation)itemId, (ResourceLocation)param.category);
            }
            previousMaxEu = maxEu;
        }
    }

    public static MachineRecipeType createMachineRecipeType(MIHook hook, String name, Function<ResourceLocation, MachineRecipeType> creator) {
        MIHookRegistry registry = hook.registry();
        MachineRecipeType type = creator.apply(hook.id(name));
        registry.recipeSerializerRegistry().register(name, () -> type);
        registry.recipeTypeRegistry().register(name, () -> type);
        registry.onMachineRecipeTypeRegister(type);
        MIMachineRecipeTypesAccessor.getRecipeTypes().add(type);
        return type;
    }
}

