/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge;

import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.swedz.tesseract.neoforge.compat.ModLoadedHelper;
import net.swedz.tesseract.neoforge.compat.mi.TesseractMILootConditions;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHookTracker;
import net.swedz.tesseract.neoforge.datagen.client.LanguageDatagenProvider;
import net.swedz.tesseract.neoforge.event.ItemHurtEvent;
import net.swedz.tesseract.neoforge.item.ArmorTickHandler;
import net.swedz.tesseract.neoforge.item.ArmorUnequippedHandler;
import net.swedz.tesseract.neoforge.item.ItemHurtHandler;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="tesseract_api")
public final class Tesseract {
    public static final String ID = "tesseract_api";
    public static final String NAME = "Tesseract API";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Tesseract API");

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public Tesseract(IEventBus bus) {
        Proxies.initialize();
        if (ModLoadedHelper.isLoaded("modern_industrialization")) {
            TesseractMILootConditions.init(bus);
            MIHookTracker.registerRecipeCategoryForMachines(bus);
        }
        bus.addListener(GatherDataEvent.class, event -> event.getGenerator().addProvider(event.includeClient(), (DataProvider)new LanguageDatagenProvider((GatherDataEvent)event)));
        NeoForge.EVENT_BUS.addListener(EntityTickEvent.Pre.class, event -> {
            Entity patt0$temp = event.getEntity();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)patt0$temp;
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    Item patt1$temp;
                    ItemStack stack;
                    if (!slot.isArmor() || (stack = entity.getItemBySlot(slot)).isEmpty() || !((patt1$temp = stack.getItem()) instanceof ArmorTickHandler)) continue;
                    ArmorTickHandler handler = (ArmorTickHandler)patt1$temp;
                    handler.armorTick(entity, slot, stack);
                }
            }
        });
        NeoForge.EVENT_BUS.addListener(LivingEquipmentChangeEvent.class, event -> {
            Item patt0$temp;
            if (!event.getFrom().isEmpty() && (patt0$temp = event.getFrom().getItem()) instanceof ArmorUnequippedHandler) {
                ArmorUnequippedHandler handler = (ArmorUnequippedHandler)patt0$temp;
                handler.onUnequipArmor(event.getEntity(), event.getSlot(), event.getFrom(), event.getTo());
            }
        });
        NeoForge.EVENT_BUS.addListener(ItemHurtEvent.class, event -> {
            Item patt0$temp = event.getItemStack().getItem();
            if (patt0$temp instanceof ItemHurtHandler) {
                ItemHurtHandler handler = (ItemHurtHandler)patt0$temp;
                handler.onHurt(event.getEntity(), event.getItemStack(), event.getDamageAmount());
            }
        });
    }
}

