/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.material.builtin.part;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.swedz.tesseract.neoforge.helper.TagHelper;
import net.swedz.tesseract.neoforge.material.builtin.property.MaterialProperties;
import net.swedz.tesseract.neoforge.material.builtin.property.OrePartDrops;
import net.swedz.tesseract.neoforge.material.part.MaterialPartAction;
import net.swedz.tesseract.neoforge.registry.holder.BlockWithItemHolder;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class CommonMaterialPartRegisters {
    public static MaterialPartAction<ItemHolder<? extends Item>> itemTagCommon(String path) {
        return (context, holder) -> holder.tag(TagHelper.itemCommonWithChild(path, context.material().id().getPath()));
    }

    public static MaterialPartAction<BlockWithItemHolder<Block, BlockItem>> blockItemTagCommon(String path) {
        return (context, holder) -> holder.item().tag(TagHelper.itemCommonWithChild(path, context.material().id().getPath()));
    }

    public static MaterialPartAction<BlockWithItemHolder<Block, BlockItem>> oreDrop() {
        return (context, h) -> h.withLootTable(holder -> {
            OrePartDrops drops = context.getOrThrow(MaterialProperties.ORE_DROP_PART);
            if (drops == null || drops.drop() == null) {
                throw new IllegalArgumentException("Could not find ore drop part");
            }
            return provider -> {
                Item drop = context.material().get(drops.drop()).asItem();
                Object block = holder.get();
                HolderLookup.RegistryLookup lookup = provider.registries().lookupOrThrow(Registries.ENCHANTMENT);
                return provider.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)provider.applyExplosionDecay((ItemLike)block, LootItem.lootTableItem((ItemLike)drop).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)drops.drops().getMinValue(), (float)drops.drops().getMaxValue()))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)lookup.getOrThrow(Enchantments.FORTUNE))))));
            };
        });
    }
}

