/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock;

import aztech.modern_industrialization.machines.gui.GuiComponent;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.swedz.tesseract.neoforge.Tesseract;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock.ModularMultiblockGuiContent;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock.ModularMultiblockGuiLine;

public final class ModularMultiblockGui {
    public static final ResourceLocation ID = Tesseract.id("modular_multiblock");
    public static final int X = 5;
    public static final int Y = 16;
    public static final int WIDTH = 166;
    public static final int HEIGHT = 80;

    public record Data(int y, int height, List<ModularMultiblockGuiLine> text) {
    }

    public static final class Server
    implements GuiComponent.Server<Data> {
        private final int y;
        private final int height;
        private final Consumer<ModularMultiblockGuiContent> contentAdder;

        public Server(int y, int height, Consumer<ModularMultiblockGuiContent> contentAdder) {
            if (height <= 4) {
                throw new IllegalArgumentException("Provided height outside of acceptable bounds: must be >4 but %d was provided".formatted(height));
            }
            this.y = y;
            this.height = height;
            this.contentAdder = contentAdder;
        }

        public Server(int y, int height, Supplier<List<ModularMultiblockGuiLine>> textSupplier) {
            this(y, height, (ModularMultiblockGuiContent c) -> c.addAll((Collection)textSupplier.get()));
        }

        public Server(int height, Consumer<ModularMultiblockGuiContent> contentAdder) {
            this(0, height, contentAdder);
        }

        public Server(int height, Supplier<List<ModularMultiblockGuiLine>> textSupplier) {
            this(0, height, textSupplier);
        }

        private ModularMultiblockGuiContent content() {
            ModularMultiblockGuiContent content = new ModularMultiblockGuiContent();
            this.contentAdder.accept(content);
            return content;
        }

        public Data copyData() {
            return new Data(this.y, this.height, this.content().lines());
        }

        public boolean needsSync(Data cachedData) {
            return !cachedData.equals(this.copyData());
        }

        public void writeInitialData(RegistryFriendlyByteBuf buf) {
            this.writeCurrentData(buf);
        }

        public void writeCurrentData(RegistryFriendlyByteBuf buf) {
            buf.writeInt(this.y);
            buf.writeInt(this.height);
            List<ModularMultiblockGuiLine> lines = this.content().lines();
            buf.writeVarInt(lines.size());
            for (ModularMultiblockGuiLine line : lines) {
                ModularMultiblockGuiLine.write(buf, line);
            }
        }

        public ResourceLocation getId() {
            return ID;
        }
    }
}

