/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock.ModularMultiblockGuiLine;
import net.swedz.tesseract.neoforge.helper.ComponentHelper;

public final class ModularMultiblockGuiClient
implements GuiComponentClient {
    private int y;
    private int height;
    private List<ModularMultiblockGuiLine> text;

    public ModularMultiblockGuiClient(RegistryFriendlyByteBuf buf) {
        this.readCurrentData(buf);
    }

    public void readCurrentData(RegistryFriendlyByteBuf buf) {
        this.y = buf.readInt();
        this.height = buf.readInt();
        int lineCount = buf.readVarInt();
        this.text = Lists.newArrayListWithCapacity((int)lineCount);
        for (int i = 0; i < lineCount; ++i) {
            this.text.add(ModularMultiblockGuiLine.read(buf));
        }
    }

    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    public final class Renderer
    implements ClientComponentRenderer {
        private static final ResourceLocation TEXTURE = MI.id((String)"textures/gui/container/multiblock_info.png");
        private static final int TEXTURE_WIDTH = 166;
        private static final int TEXTURE_HEIGHT = 80;

        private void renderInfoBackground(GuiGraphics graphics, int x, int y) {
            int sectionHeight;
            graphics.blit(TEXTURE, x + 5, y + 16 + ModularMultiblockGuiClient.this.y, 0.0f, 0.0f, 166, 2, 166, 80);
            int maxSectionHeight = 76;
            int offsetY = 0;
            for (int remainingContentHeight = ModularMultiblockGuiClient.this.height - 4; remainingContentHeight > 0; remainingContentHeight -= sectionHeight) {
                sectionHeight = Math.min(remainingContentHeight, maxSectionHeight);
                graphics.blit(TEXTURE, x + 5, y + 16 + ModularMultiblockGuiClient.this.y + offsetY + 2, 0.0f, 2.0f, 166, sectionHeight, 166, 80);
                offsetY += sectionHeight;
            }
            graphics.blit(TEXTURE, x + 5, y + 16 + ModularMultiblockGuiClient.this.y + ModularMultiblockGuiClient.this.height - 2, 0.0f, 78.0f, 166, 2, 166, 80);
        }

        private void renderInfoText(GuiGraphics graphics, int x, int y) {
            Minecraft minecraftClient = Minecraft.getInstance();
            Font font = minecraftClient.font;
            int spaceWidth = font.width(" ");
            int offsetY = 23;
            for (ModularMultiblockGuiLine line : ModularMultiblockGuiClient.this.text) {
                List wrappedLines = line.wrap() ? font.split((FormattedText)line.text(), 166 - spaceWidth) : List.of(line.text().getVisualOrderText());
                int index = 0;
                for (FormattedCharSequence wrappedLine : wrappedLines) {
                    graphics.drawString(font, ComponentHelper.stripStyle(wrappedLine), x + 5 + 5 + (index > 0 ? spaceWidth : 0), y + ModularMultiblockGuiClient.this.y + offsetY, line.color(), false);
                    offsetY += 11;
                    ++index;
                }
            }
        }

        public void renderBackground(GuiGraphics graphics, int x, int y) {
            this.renderInfoBackground(graphics, x, y);
            this.renderInfoText(graphics, x, y);
        }
    }
}

