/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.helper;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.Simulation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;

public final class MachineInventoryHelper {
    public static SlotPositions.Builder combine(SlotPositions ... positions) {
        SlotPositions.Builder combined = new SlotPositions.Builder();
        for (SlotPositions group : positions) {
            for (int i = 0; i < group.size(); ++i) {
                combined.addSlot(group.getX(i), group.getY(i));
            }
        }
        return combined;
    }

    public static MachineInventoryComponent buildInventoryComponent(int itemInputCount, int itemOutputCount, int fluidInputCount, int fluidOutputCount, SlotPositions itemPositions, SlotPositions fluidPositions, int steamBuckets, int ioBucketCapacity) {
        ArrayList<ConfigurableItemStack> itemInputStacks = new ArrayList<ConfigurableItemStack>();
        for (int i = 0; i < itemInputCount; ++i) {
            itemInputStacks.add(ConfigurableItemStack.standardInputSlot());
        }
        ArrayList<ConfigurableItemStack> itemOutputStacks = new ArrayList<ConfigurableItemStack>();
        for (int i = 0; i < itemOutputCount; ++i) {
            itemOutputStacks.add(ConfigurableItemStack.standardOutputSlot());
        }
        ArrayList<ConfigurableFluidStack> fluidInputStacks = new ArrayList<ConfigurableFluidStack>();
        if (steamBuckets > 0) {
            fluidInputStacks.add(ConfigurableFluidStack.lockedInputSlot((long)(1000L * (long)steamBuckets), (Fluid)MIFluids.STEAM.asFluid()));
        }
        for (int i = 0; i < fluidInputCount; ++i) {
            fluidInputStacks.add(ConfigurableFluidStack.standardInputSlot((long)(1000L * (long)ioBucketCapacity)));
        }
        ArrayList<ConfigurableFluidStack> fluidOutputStacks = new ArrayList<ConfigurableFluidStack>();
        for (int i = 0; i < fluidOutputCount; ++i) {
            fluidOutputStacks.add(ConfigurableFluidStack.standardOutputSlot((long)(1000L * (long)ioBucketCapacity)));
        }
        return new MachineInventoryComponent(itemInputStacks, itemOutputStacks, fluidInputStacks, fluidOutputStacks, itemPositions, fluidPositions);
    }

    public static boolean isActuallyJustAir(ConfigurableItemStack item) {
        return item.isLockedTo((Object)Items.AIR) || item.getLockedInstance() == null && item.isEmpty();
    }

    public static ItemStack toActualItemStack(ConfigurableItemStack item) {
        return item.getLockedInstance() != null && item.isEmpty() ? ((Item)item.getLockedInstance()).getDefaultInstance() : ((ItemVariant)item.getResource()).toStack();
    }

    public static boolean hasFluid(List<ConfigurableFluidStack> fluids, FluidLike fluid, int amount) {
        return fluids.stream().anyMatch(f -> ((FluidVariant)f.getResource()).getFluid() == fluid.asFluid() && f.getAmount() >= (long)amount);
    }

    public static boolean hasFluid(List<ConfigurableFluidStack> fluids, Fluid fluid, int amount) {
        return MachineInventoryHelper.hasFluid(fluids, () -> fluid, amount);
    }

    public static long consumeFluid(List<ConfigurableFluidStack> fluids, FluidLike fluid, long max, Simulation simulation) {
        if (max <= 0L) {
            throw new IllegalArgumentException("May not consume 0 fluid");
        }
        long totalRemoved = 0L;
        for (ConfigurableFluidStack fluidStack : fluids) {
            if (((FluidVariant)fluidStack.getResource()).getFluid() != fluid.asFluid()) continue;
            long amount = fluidStack.getAmount();
            long remove = Math.min(max, amount);
            if (simulation.isActing()) {
                fluidStack.decrement(remove);
            }
            max -= remove;
            totalRemoved += remove;
        }
        return totalRemoved;
    }

    public static long consumeFluid(List<ConfigurableFluidStack> fluids, FluidLike fluid, long max, boolean simulation) {
        return MachineInventoryHelper.consumeFluid(fluids, fluid, max, simulation ? Simulation.SIMULATE : Simulation.ACT);
    }

    public static long consumeFluid(List<ConfigurableFluidStack> fluids, Fluid fluid, long max, Simulation simulation) {
        return MachineInventoryHelper.consumeFluid(fluids, () -> fluid, max, simulation);
    }

    public static long consumeFluid(List<ConfigurableFluidStack> fluids, Fluid fluid, long max, boolean simulate) {
        return MachineInventoryHelper.consumeFluid(fluids, fluid, max, simulate ? Simulation.SIMULATE : Simulation.ACT);
    }
}

