/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.config;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.swedz.tesseract.neoforge.Tesseract;
import net.swedz.tesseract.neoforge.config.ConfigInstance;
import net.swedz.tesseract.neoforge.config.ConfigManager;
import net.swedz.tesseract.neoforge.config.annotation.ConfigKey;
import net.swedz.tesseract.neoforge.config.annotation.SubSection;
import net.swedz.tesseract.neoforge.serialization.TomlOps;

public final class ConfigHandler
implements InvocationHandler {
    private final ConfigManager manager;
    private final ModConfigSpec spec;
    private final String path;
    private Map<String, Object> values = Maps.newHashMap();

    public ConfigHandler(ConfigManager manager, ModConfigSpec spec, String path) {
        this.manager = manager;
        this.spec = spec;
        this.path = path;
    }

    ModConfigSpec spec() {
        return this.spec;
    }

    private String path(String key) {
        return (String)(this.path.isEmpty() ? "" : this.path + ".") + key;
    }

    void loadValues(Class<?> configClass, Object proxy) {
        HashMap values = Maps.newHashMap();
        for (Method method : configClass.getMethods()) {
            Object value;
            if (!method.isAnnotationPresent(ConfigKey.class)) continue;
            String key = method.getAnnotation(ConfigKey.class).value();
            String path = this.path(key);
            Class<?> type = method.getReturnType();
            if (method.isAnnotationPresent(SubSection.class)) {
                value = this.manager.build(this.spec, type, path).load();
            } else {
                ModConfigSpec.ConfigValue configValue = (ModConfigSpec.ConfigValue)this.spec.getValues().get(path);
                value = configValue.get();
                if (this.manager.codecs().has(method.getReturnType())) {
                    Codec<?> codec = this.manager.codecs().get(method.getReturnType());
                    value = codec.parse((DynamicOps)TomlOps.INSTANCE, value).mapOrElse(result -> result, error -> {
                        Tesseract.LOGGER.error("Failed to parse input value: {}", (Object)error.message());
                        try {
                            return InvocationHandler.invokeDefault(proxy, method, new Object[0]);
                        }
                        catch (Throwable ex) {
                            throw new RuntimeException(ex);
                        }
                    });
                }
            }
            values.put(method.getName(), value);
        }
        this.values = Collections.unmodifiableMap(values);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        Object value = this.values.get(method.getName());
        if (value instanceof ConfigInstance) {
            ConfigInstance config = (ConfigInstance)value;
            object = config.config();
        } else {
            object = value;
        }
        return object;
    }
}

