/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.client.model.IModelBuilder;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.SimpleUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import net.swedz.tesseract.neoforge.Tesseract;
import net.swedz.tesseract.neoforge.helper.model.ModelHelper;

public final class DynamicAtlasUnbakedModel
extends SimpleUnbakedGeometry<DynamicAtlasUnbakedModel> {
    public static final ResourceLocation LOADER_ID = Tesseract.id("dynamic_atlas");
    public static final IGeometryLoader<DynamicAtlasUnbakedModel> LOADER = (json, context) -> {
        if (!json.has("atlas")) {
            throw new JsonParseException("A dynamic atlas model must have an \"atlas\" property.");
        }
        ResourceLocation atlas = ResourceLocation.tryParse((String)json.get("atlas").getAsString());
        if (atlas == null) {
            throw new JsonParseException("A dynamic atlas model must have a valid \"atlas\" property.");
        }
        if (!json.has("textures")) {
            throw new JsonParseException("A dynamic atlas model must have a \"textures\" property.");
        }
        LinkedHashMap<String, Material> textures = ModelHelper.gatherTextures(atlas, json, "textures");
        if (!json.has("elements")) {
            throw new JsonParseException("A dynamic atlas model must have an \"elements\" member.");
        }
        ArrayList<BlockElement> elements = new ArrayList<BlockElement>();
        for (JsonElement element : GsonHelper.getAsJsonArray((JsonObject)json, (String)"elements")) {
            elements.add((BlockElement)context.deserialize(element, BlockElement.class));
        }
        return new DynamicAtlasUnbakedModel(textures, elements);
    };
    private final Map<String, Material> textures;
    private final List<BlockElement> elements;

    private DynamicAtlasUnbakedModel(Map<String, Material> textures, List<BlockElement> elements) {
        this.textures = textures;
        this.elements = elements;
    }

    protected void addQuads(IGeometryBakingContext context, IModelBuilder<?> modelBuilder, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState) {
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = UnbakedGeometryHelper.composeRootTransformIntoModelState((ModelState)modelState, (Transformation)rootTransform);
        }
        for (BlockElement element : this.elements) {
            for (Direction direction : element.faces.keySet()) {
                BlockElementFace face = (BlockElementFace)element.faces.get(direction);
                String texture = face.texture();
                if (texture.charAt(0) == '#') {
                    texture = texture.substring(1);
                }
                TextureAtlasSprite sprite = spriteGetter.apply(this.textures.getOrDefault(texture, new Material(InventoryMenu.BLOCK_ATLAS, MissingTextureAtlasSprite.getLocation())));
                BakedQuad quad = BlockModel.bakeFace((BlockElement)element, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)modelState);
                if (face.cullForDirection() == null) {
                    modelBuilder.addUnculledFace(quad);
                    continue;
                }
                modelBuilder.addCulledFace(modelState.getRotation().rotateTransform(face.cullForDirection()), quad);
            }
        }
    }
}

