/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.packet;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.swedz.tesseract.neoforge.packet.CustomPacket;
import net.swedz.tesseract.neoforge.packet.PacketContext;
import net.swedz.tesseract.neoforge.packet.PacketRegistration;

public final class PacketRegistry<P extends CustomPacket> {
    private final String namespace;
    private final Set<PacketRegistration<P>> registrations = Sets.newHashSet();
    private final Map<Class<? extends P>, CustomPacketPayload.Type<P>> types = Maps.newHashMap();
    private boolean registered;

    private PacketRegistry(String namespace) {
        this.namespace = namespace;
    }

    public static <P extends CustomPacket> PacketRegistry<P> create(String namespace) {
        return new PacketRegistry<P>(namespace);
    }

    public boolean hasBeenRegistered() {
        return this.registered;
    }

    public <I extends P> void create(String id, Class<I> packetClass, StreamCodec<? super RegistryFriendlyByteBuf, I> packetCodec) {
        if (this.registered) {
            throw new IllegalStateException("Registry has already been registered, new packets cannot be created anymore.");
        }
        CustomPacketPayload.Type type = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)id));
        this.registrations.add(new PacketRegistration<I>(type, packetClass, packetCodec));
        this.types.put(packetClass, type);
    }

    public CustomPacketPayload.Type<P> getType(Class<? extends P> packetClass) {
        return this.types.get(packetClass);
    }

    public void registerAll(RegisterPayloadHandlersEvent event) {
        this.registered = true;
        PayloadRegistrar registrar = event.registrar(this.namespace);
        for (PacketRegistration packetRegistration : this.registrations) {
            registrar.playBidirectional(packetRegistration.type(), packetRegistration.codec(), (packet, context) -> packet.handle(new PacketContext(packetRegistration.clazz(), context)));
        }
    }
}

