/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.api.range;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.swedz.tesseract.neoforge.api.Assert;

public record IntRange(int min, int max) {
    public static final Codec<IntRange> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min").forGetter(IntRange::min), (App)Codec.INT.fieldOf("max").forGetter(IntRange::max)).apply((Applicative)instance, IntRange::new));
    public static final StreamCodec<ByteBuf, IntRange> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, IntRange::min, (StreamCodec)ByteBufCodecs.VAR_INT, IntRange::max, IntRange::new);

    public IntRange {
        Assert.that(min <= max, "Cannot create int range with min that is greater than the max (%d > %d)".formatted(min, max));
    }

    public boolean isSingle() {
        return this.min == this.max;
    }

    public boolean contains(int value) {
        return value >= this.min && value <= this.max;
    }

    public int clamp(int value) {
        return Mth.clamp((int)value, (int)this.min, (int)this.max);
    }
}

