/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.swedz.tesseract.neoforge.item.DynamicDyedItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={DyedItemColor.class})
public class DynamicDyedItemDyeColorMixin {
    @WrapOperation(method={"applyDyes"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/DyeColor;getTextureDiffuseColor()I")})
    private static int getDyeColor(DyeColor dyeColor, Operation<Integer> original, @Local(argsOnly=true) ItemStack stack) {
        int n;
        Item item = stack.getItem();
        if (item instanceof DynamicDyedItem) {
            DynamicDyedItem item2 = (DynamicDyedItem)item;
            n = item2.getDyeColor(dyeColor);
        } else {
            n = (Integer)original.call(new Object[]{dyeColor});
        }
        return n;
    }

    @ModifyVariable(method={"getOrDefault"}, at=@At(value="HEAD"), argsOnly=true)
    private static int getDefaultDyeColor(int defaultValue, ItemStack stack) {
        if (defaultValue == -6265536) {
            int n;
            Item item = stack.getItem();
            if (item instanceof DynamicDyedItem) {
                DynamicDyedItem item2 = (DynamicDyedItem)item;
                n = item2.getDefaultDyeColor();
            } else {
                n = defaultValue;
            }
            return n;
        }
        return defaultValue;
    }
}

