/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.builder;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.hatches.EnergyHatch;
import aztech.modern_industrialization.machines.blockentities.hatches.FluidHatch;
import aztech.modern_industrialization.machines.blockentities.hatches.ItemHatch;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.models.MachineCasing;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.compat.mi.hack.HackedMachineRegistrationHelper;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHook;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.MachineBuilder;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.MachineBuiltinModelBuilder;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockHatchBlockEntityFactory;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockHolderHatchModifier;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockRegistrators;

public final class HatchMachineBuilder
extends MachineBuilder<HatchMachineBuilder> {
    private RegistrationType type;
    private boolean registerIO;
    private MachineBlockHatchBlockEntityFactory blockEntityFactory;
    private final List<MachineBlockHolderHatchModifier> holderHatchModifiers = Lists.newArrayList();
    private CableTier energyCableTier;

    HatchMachineBuilder(MIHook hook, String name, String englishName) {
        super(hook, name, englishName);
    }

    public HatchMachineBuilder modify(MachineBlockHolderHatchModifier modifier) {
        Assert.notNull(modifier);
        this.holderHatchModifiers.add(modifier);
        return this;
    }

    public HatchMachineBuilder item(int rows, int columns, int startX, int startY) {
        Assert.that(rows > 0);
        Assert.that(columns > 0);
        this.type = RegistrationType.ITEM;
        this.registerIO = true;
        this.blockEntityFactory = (bep, input, machineId) -> {
            ArrayList itemStacks = Lists.newArrayList();
            for (int slot = 0; slot < rows * columns; ++slot) {
                if (input) {
                    itemStacks.add(ConfigurableItemStack.standardInputSlot());
                    continue;
                }
                itemStacks.add(ConfigurableItemStack.standardOutputSlot());
            }
            MIInventory inventory = new MIInventory((List)itemStacks, Collections.emptyList(), new SlotPositions.Builder().addSlots(startX, startY, columns, rows).build(), SlotPositions.empty());
            return new ItemHatch(bep, new MachineGuiParameters.Builder(machineId, true).build(), input, !this.name.equals("bronze"), inventory);
        };
        return (HatchMachineBuilder)this.registrator(MachineBlockEntity::registerItemApi);
    }

    public HatchMachineBuilder fluid(int bucketCapacity) {
        Assert.that(bucketCapacity > 0);
        this.type = RegistrationType.FLUID;
        this.registerIO = true;
        this.blockEntityFactory = (bep, input, machineId) -> {
            List<ConfigurableFluidStack> fluidStacks = Collections.singletonList(input ? ConfigurableFluidStack.standardInputSlot((long)((long)bucketCapacity * 1000L)) : ConfigurableFluidStack.standardOutputSlot((long)((long)bucketCapacity * 1000L)));
            MIInventory inventory = new MIInventory(Collections.emptyList(), fluidStacks, SlotPositions.empty(), new SlotPositions.Builder().addSlot(80, 40).build());
            return new FluidHatch(bep, new MachineGuiParameters.Builder(machineId, true).build(), input, !this.name.equals("bronze"), inventory);
        };
        return (HatchMachineBuilder)this.registrator(MachineBlockEntity::registerFluidApi);
    }

    public HatchMachineBuilder energy(CableTier tier) {
        Assert.notNull(tier);
        this.type = RegistrationType.ENERGY;
        this.registerIO = true;
        this.energyCableTier = tier;
        this.blockEntityFactory = (bep, input, machineId) -> new EnergyHatch(bep, new MachineGuiParameters.Builder(machineId, false).build(), input, tier);
        return (HatchMachineBuilder)this.registrator(EnergyHatch::registerEnergyApi);
    }

    public HatchMachineBuilder special(MachineBlockHatchBlockEntityFactory factory, boolean registerIO) {
        Assert.notNull(factory);
        this.type = RegistrationType.SPECIAL;
        this.registerIO = registerIO;
        this.blockEntityFactory = factory;
        return this;
    }

    public HatchMachineBuilder special(MachineBlockHatchBlockEntityFactory factory) {
        return this.special(factory, false);
    }

    public HatchMachineBuilder registerIO(boolean register) {
        this.registerIO = register;
        return this;
    }

    public HatchMachineBuilder registerIO() {
        return this.registerIO(true);
    }

    @Override
    public HatchMachineBuilder builtinModel(MachineCasing casing, String overlayFolder, Consumer<MachineBuiltinModelBuilder> builder) {
        return (HatchMachineBuilder)super.builtinModel(casing, overlayFolder, (MachineBuiltinModelBuilder b) -> {
            b.front().side();
            if (builder != null) {
                builder.accept((MachineBuiltinModelBuilder)b);
            }
        });
    }

    @Override
    public HatchMachineBuilder builtinModel(MachineCasing casing, String overlayFolder) {
        return this.builtinModel(casing, overlayFolder, (Consumer)null);
    }

    public HatchMachineBuilder builtinModel(MachineCasing casing, Consumer<MachineBuiltinModelBuilder> builder) {
        Assert.notNull((Object)this.type, "The type must be selected before including a builtin model");
        Assert.that(this.type != RegistrationType.SPECIAL, "Overlay folder must be specified for special hatches");
        return this.builtinModel(casing, this.getDefaultOverlayFolder(), (Consumer)builder);
    }

    public HatchMachineBuilder builtinModel(MachineCasing casing) {
        return this.builtinModel(casing, (Consumer<MachineBuiltinModelBuilder>)null);
    }

    public HatchMachineBuilder builtinModel(String overlayFolder, Consumer<MachineBuiltinModelBuilder> builder) {
        Assert.that(this.type == RegistrationType.ENERGY, "Machine casing must be specified for non-energy hatches");
        return this.builtinModel(this.energyCableTier.casing, overlayFolder, (Consumer)builder);
    }

    public HatchMachineBuilder builtinModel(Consumer<MachineBuiltinModelBuilder> builder) {
        return this.builtinModel(this.getDefaultOverlayFolder(), builder);
    }

    public HatchMachineBuilder builtinModel() {
        return this.builtinModel((Consumer<MachineBuiltinModelBuilder>)null);
    }

    private String getName() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.name + "_item";
            case 1 -> this.name + "_fluid";
            case 2 -> this.energyCableTier.name + "_energy";
            case 3 -> this.name;
        };
    }

    private String getEnglishName() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.englishName + " Item";
            case 1 -> this.englishName + " Fluid";
            case 2 -> this.energyCableTier.shortEnglishName + " Energy";
            case 3 -> this.englishName;
        };
    }

    private String getDefaultOverlayFolder() {
        return switch (this.type.ordinal()) {
            case 0 -> "hatch_item";
            case 1 -> "hatch_fluid";
            case 2 -> "hatch_energy";
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.type));
        };
    }

    @Override
    protected void internalRegister() {
        Assert.notNull((Object)this.type, "Hatch type must be configured");
        String name = this.getName();
        String englishName = this.getEnglishName();
        if (this.registerIO) {
            for (int i = 0; i < 2; ++i) {
                boolean input = i == 0;
                String machineId = "%s_%s_hatch".formatted(name, input ? "input" : "output");
                String machineEnglishName = "%s %s Hatch".formatted(englishName, input ? "Input" : "Output");
                HackedMachineRegistrationHelper.registerMachine(this.hook, machineEnglishName, machineId, this.blockFactory, holder -> {
                    this.holderModifiers.forEach(modifier -> modifier.modify(holder));
                    this.holderHatchModifiers.forEach(modifier -> modifier.modify(holder, input));
                }, properties -> this.propertiesModifiers.forEach(modifier -> modifier.modify(properties)), this.defaultMineableTags, bep -> this.blockEntityFactory.create(bep, input, this.hook.id(machineId)), (MachineBlockRegistrators[])this.registrators.toArray(MachineBlockRegistrators[]::new));
                if (this.builtinModel == null) continue;
                this.builtinModel.build(this.hook, machineId);
            }
        } else {
            HackedMachineRegistrationHelper.registerMachine(this.hook, englishName, name, this.blockFactory, holder -> {
                this.holderModifiers.forEach(modifier -> modifier.modify(holder));
                this.holderHatchModifiers.forEach(modifier -> modifier.modify(holder, false));
            }, properties -> this.propertiesModifiers.forEach(modifier -> modifier.modify(properties)), this.defaultMineableTags, bep -> this.blockEntityFactory.create(bep, false, this.hook.id(name)), (MachineBlockRegistrators[])this.registrators.toArray(MachineBlockRegistrators[]::new));
            if (this.builtinModel != null) {
                this.builtinModel.build(this.hook, name);
            }
        }
    }

    public static enum RegistrationType {
        ITEM,
        FLUID,
        ENERGY,
        SPECIAL;

    }
}

