/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.api.range;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.swedz.tesseract.neoforge.api.Assert;

public record FloatRange(float min, float max) {
    public static final Codec<FloatRange> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min").forGetter(FloatRange::min), (App)Codec.FLOAT.fieldOf("max").forGetter(FloatRange::max)).apply((Applicative)instance, FloatRange::new));
    public static final StreamCodec<ByteBuf, FloatRange> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, FloatRange::min, (StreamCodec)ByteBufCodecs.FLOAT, FloatRange::max, FloatRange::new);

    public FloatRange {
        Assert.that(min <= max, "Cannot create float range with min that is greater than the max (%f > %f)".formatted(Float.valueOf(min), Float.valueOf(max)));
    }

    public boolean isSingle() {
        return this.min == this.max;
    }

    public boolean contains(float value) {
        return value >= this.min && value <= this.max;
    }

    public float clamp(float value) {
        return Mth.clamp((float)value, (float)this.min, (float)this.max);
    }
}

