/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.builder;

import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHook;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.HatchMachineBuilder;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.MachineBuiltinModelBuilder;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.SingleBlockCraftingMachineBuilder;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.SpecialMachineBuilder;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockEntityWithGuiFactory;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockFactory;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockHolderModifier;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockPropertiesModifier;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineBlockRegistrators;

public abstract class MachineBuilder<T extends MachineBuilder<T>> {
    protected final MIHook hook;
    protected final String name;
    protected final String englishName;
    protected MachineBlockFactory blockFactory = MachineBlock::new;
    protected final List<MachineBlockHolderModifier> holderModifiers = Lists.newArrayList();
    protected final List<MachineBlockPropertiesModifier> propertiesModifiers = Lists.newArrayList();
    protected final List<MachineBlockRegistrators> registrators = Lists.newArrayList();
    protected boolean defaultMineableTags = true;
    protected MachineBuiltinModelBuilder builtinModel;
    private boolean isRegistered;

    public static SingleBlockCraftingMachineBuilder singleBlockCrafting(MIHook hook, String name, String englishName, MachineRecipeType recipeType) {
        return new SingleBlockCraftingMachineBuilder(hook, name, englishName, recipeType);
    }

    public static SpecialMachineBuilder special(MIHook hook, String name, String englishName, boolean isMultiblock, MachineBlockEntityWithGuiFactory factory) {
        return new SpecialMachineBuilder(hook, name, englishName, isMultiblock, factory);
    }

    public static HatchMachineBuilder hatch(MIHook hook, String name, String englishName) {
        return new HatchMachineBuilder(hook, name, englishName);
    }

    MachineBuilder(MIHook hook, String name, String englishName) {
        Assert.noneNull(hook, name, englishName);
        this.hook = hook;
        this.name = name;
        this.englishName = englishName;
    }

    public T creator(MachineBlockFactory blockFactory) {
        Assert.notNull(blockFactory);
        this.blockFactory = blockFactory;
        return (T)this;
    }

    public T modify(MachineBlockHolderModifier modifier) {
        Assert.notNull(modifier);
        this.holderModifiers.add(modifier);
        return (T)this;
    }

    public T properties(MachineBlockPropertiesModifier properties) {
        Assert.notNull(properties);
        this.propertiesModifiers.add(properties);
        return (T)this;
    }

    public T registrator(MachineBlockRegistrators registrator) {
        Assert.notNull(registrator);
        this.registrators.add(registrator);
        return (T)this;
    }

    public T excludeDefaultMineableTags() {
        this.defaultMineableTags = false;
        return (T)this;
    }

    public T builtinModel(MachineCasing casing, String overlayFolder, Consumer<MachineBuiltinModelBuilder> builder) {
        Assert.that(this.builtinModel == null, "Simple model has already been registered for this machine");
        Assert.noneNull(overlayFolder);
        this.builtinModel = new MachineBuiltinModelBuilder(casing, overlayFolder);
        if (builder != null) {
            builder.accept(this.builtinModel);
        }
        return (T)this;
    }

    public T builtinModel(MachineCasing casing, String overlayFolder) {
        return this.builtinModel(casing, overlayFolder, null);
    }

    protected abstract void internalRegister();

    public final T registerMachine() {
        Assert.that(!this.isRegistered, "This machine is already registered");
        this.isRegistered = true;
        this.internalRegister();
        return (T)this;
    }
}

