/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.material.builtin.property;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.swedz.tesseract.neoforge.Tesseract;
import net.swedz.tesseract.neoforge.material.builtin.part.MaterialParts;
import net.swedz.tesseract.neoforge.material.builtin.property.OrePartDrops;
import net.swedz.tesseract.neoforge.material.part.MaterialPart;
import net.swedz.tesseract.neoforge.material.part.MaterialPartItemReferenceFormatter;
import net.swedz.tesseract.neoforge.material.property.MaterialProperty;
import net.swedz.tesseract.neoforge.registry.holder.BlockHolder;

public interface MaterialProperties {
    public static final MaterialProperty<Float> BLAST_RESISTANCE = MaterialProperties.create("blast_resistance", Float.valueOf(6.0f)).block((h, v) -> h.withProperties(p -> p.explosionResistance(v.floatValue())));
    public static final MaterialProperty<Float> HARDNESS = MaterialProperties.create("hardness", Float.valueOf(5.0f)).block((h, v) -> h.withProperties(p -> p.destroyTime(v.floatValue())));
    public static final MaterialProperty<Boolean> REQUIRES_CORRECT_TOOL_FOR_DROPS = MaterialProperties.create("requires_correct_tool_for_drops", true).block((h, v) -> {
        if (v.booleanValue()) {
            h.withProperties(BlockBehaviour.Properties::requiresCorrectToolForDrops);
        }
    });
    public static final MaterialProperty<Optional<TagKey<Block>>> NEEDS_TOOL = MaterialProperties.create("needs_tool", Optional.of(BlockTags.NEEDS_STONE_TOOL)).block((h, v) -> v.ifPresent(xva$0 -> {
        BlockHolder cfr_ignored_0 = (BlockHolder)h.tag(xva$0);
    }));
    public static final MaterialProperty<Optional<TagKey<Block>>> MINEABLE = MaterialProperties.create("mineable", Optional.of(BlockTags.MINEABLE_WITH_PICKAXE)).block((h, v) -> v.ifPresent(xva$0 -> {
        BlockHolder cfr_ignored_0 = (BlockHolder)h.tag(xva$0);
    }));
    public static final MaterialProperty<MaterialPartItemReferenceFormatter> ITEM_REFERENCE = MaterialProperties.create("item_reference", (namespace, material, part) -> ResourceLocation.fromNamespaceAndPath((String)namespace, (String)part.formatId(material)).toString());
    public static final MaterialProperty<MaterialPart> MAIN_PART = MaterialProperties.create("main_part", MaterialParts.INGOT);
    public static final MaterialProperty<Integer> MEAN_RGB = MaterialProperties.create("mean_rgb", 0);
    public static final MaterialProperty<OrePartDrops> ORE_DROP_PART = MaterialProperties.create("ore_drop_part", OrePartDrops.of(MaterialParts.RAW_METAL));
    public static final MaterialProperty<Tier> TOOL_TIER = MaterialProperties.create("tool_tier", Tiers.STONE);

    public static <T> MaterialProperty<T> create(String id, T defaultValue) {
        return new MaterialProperty<T>(Tesseract.id(id), defaultValue);
    }
}

