/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;

public final class BoxRenderHelper {
    public static void renderFace(PoseStack matrices, int light, int overlay, VertexConsumer vc, float x1, float y1, float z1, float x2, float y2, float z2, Direction direction, float textureWidth, float textureHeight, float textureScale, float red, float green, float blue, float alpha) {
        float u2;
        float v1;
        float u1;
        float v2 = switch (direction) {
            case Direction.DOWN, Direction.UP -> {
                u1 = x1 / textureWidth / textureScale;
                v1 = z1 / textureHeight / textureScale;
                u2 = x2 / textureWidth / textureScale;
                yield z2 / textureHeight / textureScale;
            }
            case Direction.NORTH, Direction.SOUTH -> {
                u1 = x1 / textureWidth / textureScale;
                v1 = y1 / textureHeight / textureScale;
                u2 = x2 / textureWidth / textureScale;
                yield y2 / textureHeight / textureScale;
            }
            case Direction.WEST, Direction.EAST -> {
                u1 = z1 / textureWidth / textureScale;
                v1 = y1 / textureHeight / textureScale;
                u2 = z2 / textureWidth / textureScale;
                yield y2 / textureHeight / textureScale;
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(direction));
        };
        switch (direction) {
            case DOWN: {
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y1, z1, red, green, blue, alpha, u1, v1);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y1, z1, red, green, blue, alpha, u2, v1);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y1, z2, red, green, blue, alpha, u2, v2);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y1, z2, red, green, blue, alpha, u1, v2);
                break;
            }
            case UP: {
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y2, z1, red, green, blue, alpha, u1, v1);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y2, z1, red, green, blue, alpha, u2, v1);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y2, z2, red, green, blue, alpha, u2, v2);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y2, z2, red, green, blue, alpha, u1, v2);
                break;
            }
            case NORTH: {
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y1, z1, red, green, blue, alpha, u1, v1);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y1, z1, red, green, blue, alpha, u2, v1);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y2, z1, red, green, blue, alpha, u2, v2);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y2, z1, red, green, blue, alpha, u1, v2);
                break;
            }
            case SOUTH: {
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y1, z2, red, green, blue, alpha, u1, v1);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y1, z2, red, green, blue, alpha, u2, v1);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y2, z2, red, green, blue, alpha, u2, v2);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y2, z2, red, green, blue, alpha, u1, v2);
                break;
            }
            case WEST: {
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y1, z1, red, green, blue, alpha, u1, v1);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y1, z2, red, green, blue, alpha, u2, v1);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y2, z2, red, green, blue, alpha, u2, v2);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y2, z1, red, green, blue, alpha, u1, v2);
                break;
            }
            case EAST: {
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y1, z1, red, green, blue, alpha, u1, v1);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y1, z2, red, green, blue, alpha, u2, v1);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y2, z2, red, green, blue, alpha, u2, v2);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y2, z1, red, green, blue, alpha, u1, v2);
            }
        }
    }

    public static void renderBox(PoseStack matrices, int light, int overlay, VertexConsumer vc, float x1, float y1, float z1, float x2, float y2, float z2, Iterable<Direction> directions, float textureWidth, float textureHeight, float textureScale, float red, float green, float blue, float alpha) {
        for (Direction direction : directions) {
            BoxRenderHelper.renderFace(matrices, light, overlay, vc, x1, y1, z1, x2, y2, z2, direction, textureWidth, textureHeight, textureScale, red, green, blue, alpha);
        }
    }

    public static void renderBox(PoseStack matrices, int light, int overlay, VertexConsumer vc, float x1, float y1, float z1, float x2, float y2, float z2, Predicate<Direction> directionFilter, float textureWidth, float textureHeight, float textureScale, float red, float green, float blue, float alpha) {
        for (Direction direction : Direction.values()) {
            if (!directionFilter.test(direction)) continue;
            BoxRenderHelper.renderFace(matrices, light, overlay, vc, x1, y1, z1, x2, y2, z2, direction, textureWidth, textureHeight, textureScale, red, green, blue, alpha);
        }
    }

    public static void renderBox(PoseStack matrices, int light, int overlay, VertexConsumer vc, float x1, float y1, float z1, float x2, float y2, float z2, float textureWidth, float textureHeight, float textureScale, float red, float green, float blue, float alpha) {
        BoxRenderHelper.renderBox(matrices, light, overlay, vc, x1, y1, z1, x2, y2, z2, (Direction __) -> true, textureWidth, textureHeight, textureScale, red, green, blue, alpha);
    }

    public static void renderFace(PoseStack matrices, int light, int overlay, VertexConsumer vc, AABB box, Direction direction, float textureWidth, float textureHeight, float textureScale, float red, float green, float blue, float alpha) {
        BoxRenderHelper.renderFace(matrices, light, overlay, vc, (float)box.minX, (float)box.minY, (float)box.minZ, (float)box.maxX, (float)box.maxY, (float)box.maxZ, direction, textureWidth, textureHeight, textureScale, red, green, blue, alpha);
    }

    public static void renderBox(PoseStack matrices, int light, int overlay, VertexConsumer vc, AABB box, Iterable<Direction> directions, float textureWidth, float textureHeight, float textureScale, float red, float green, float blue, float alpha) {
        for (Direction direction : directions) {
            BoxRenderHelper.renderFace(matrices, light, overlay, vc, box, direction, textureWidth, textureHeight, textureScale, red, green, blue, alpha);
        }
    }

    public static void renderBox(PoseStack matrices, int light, int overlay, VertexConsumer vc, AABB box, Predicate<Direction> directionFilter, float textureWidth, float textureHeight, float textureScale, float red, float green, float blue, float alpha) {
        for (Direction direction : Direction.values()) {
            if (!directionFilter.test(direction)) continue;
            BoxRenderHelper.renderFace(matrices, light, overlay, vc, box, direction, textureWidth, textureHeight, textureScale, red, green, blue, alpha);
        }
    }

    public static void renderBox(PoseStack matrices, int light, int overlay, VertexConsumer vc, AABB box, float textureWidth, float textureHeight, float textureScale, float red, float green, float blue, float alpha) {
        BoxRenderHelper.renderBox(matrices, light, overlay, vc, box, (Direction __) -> true, textureWidth, textureHeight, textureScale, red, green, blue, alpha);
    }

    private static void addVertex(PoseStack matrices, int light, int overlay, VertexConsumer vc, float x, float y, float z, float red, float green, float blue, float alpha, float u, float v) {
        PoseStack.Pose pose = matrices.last();
        vc.addVertex(pose, x, y, z).setColor(red, green, blue, alpha).setLight(light).setNormal(pose, 0.0f, 0.0f, 0.0f).setOverlay(overlay).setUv(u, v);
    }

    public static void renderFace(PoseStack matrices, int light, int overlay, VertexConsumer vc, float x1, float y1, float z1, float x2, float y2, float z2, Direction direction, float red, float green, float blue, float alpha) {
        switch (direction) {
            case DOWN: {
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y1, z1, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y1, z1, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y1, z2, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y1, z2, red, green, blue, alpha);
                break;
            }
            case UP: {
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y2, z1, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y2, z1, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y2, z2, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y2, z2, red, green, blue, alpha);
                break;
            }
            case NORTH: {
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y1, z1, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y1, z1, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y2, z1, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y2, z1, red, green, blue, alpha);
                break;
            }
            case SOUTH: {
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y1, z2, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y1, z2, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y2, z2, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y2, z2, red, green, blue, alpha);
                break;
            }
            case WEST: {
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y1, z1, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y1, z2, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y2, z2, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x1, y2, z1, red, green, blue, alpha);
                break;
            }
            case EAST: {
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y1, z1, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y1, z2, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y2, z2, red, green, blue, alpha);
                BoxRenderHelper.addVertex(matrices, light, overlay, vc, x2, y2, z1, red, green, blue, alpha);
            }
        }
    }

    public static void renderBox(PoseStack matrices, int light, int overlay, VertexConsumer vc, float x1, float y1, float z1, float x2, float y2, float z2, Iterable<Direction> directions, float red, float green, float blue, float alpha) {
        for (Direction direction : directions) {
            BoxRenderHelper.renderFace(matrices, light, overlay, vc, x1, y1, z1, x2, y2, z2, direction, red, green, blue, alpha);
        }
    }

    public static void renderBox(PoseStack matrices, int light, int overlay, VertexConsumer vc, float x1, float y1, float z1, float x2, float y2, float z2, Predicate<Direction> directionFilter, float red, float green, float blue, float alpha) {
        for (Direction direction : Direction.values()) {
            if (!directionFilter.test(direction)) continue;
            BoxRenderHelper.renderFace(matrices, light, overlay, vc, x1, y1, z1, x2, y2, z2, direction, red, green, blue, alpha);
        }
    }

    public static void renderBox(PoseStack matrices, int light, int overlay, VertexConsumer vc, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha) {
        BoxRenderHelper.renderBox(matrices, light, overlay, vc, x1, y1, z1, x2, y2, z2, (Direction __) -> true, red, green, blue, alpha);
    }

    public static void renderFace(PoseStack matrices, int light, int overlay, VertexConsumer vc, AABB box, Direction direction, float red, float green, float blue, float alpha) {
        BoxRenderHelper.renderFace(matrices, light, overlay, vc, (float)box.minX, (float)box.minY, (float)box.minZ, (float)box.maxX, (float)box.maxY, (float)box.maxZ, direction, red, green, blue, alpha);
    }

    public static void renderBox(PoseStack matrices, int light, int overlay, VertexConsumer vc, AABB box, Iterable<Direction> directions, float red, float green, float blue, float alpha) {
        for (Direction direction : directions) {
            BoxRenderHelper.renderFace(matrices, light, overlay, vc, box, direction, red, green, blue, alpha);
        }
    }

    public static void renderBox(PoseStack matrices, int light, int overlay, VertexConsumer vc, AABB box, Predicate<Direction> directionFilter, float red, float green, float blue, float alpha) {
        for (Direction direction : Direction.values()) {
            if (!directionFilter.test(direction)) continue;
            BoxRenderHelper.renderFace(matrices, light, overlay, vc, box, direction, red, green, blue, alpha);
        }
    }

    public static void renderBox(PoseStack matrices, int light, int overlay, VertexConsumer vc, AABB box, float red, float green, float blue, float alpha) {
        BoxRenderHelper.renderBox(matrices, light, overlay, vc, box, (Direction __) -> true, red, green, blue, alpha);
    }

    private static void addVertex(PoseStack matrices, int light, int overlay, VertexConsumer vc, float x, float y, float z, float red, float green, float blue, float alpha) {
        PoseStack.Pose pose = matrices.last();
        vc.addVertex(pose, x, y, z).setColor(red, green, blue, alpha).setLight(light).setNormal(pose, 0.0f, 0.0f, 0.0f).setOverlay(overlay);
    }
}

