/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.blocks;

import net.minecraft.class_10;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1676;
import net.minecraft.class_1685;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5688;
import net.minecraft.class_5691;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.blocks.ModBlocks;

public class NullSpikeBlock
extends class_2248
implements class_5688,
class_3737 {
    public static final class_2753 VERTICAL_DIRECTION = class_2741.field_28062;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 UP_TIP_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final class_265 DOWN_TIP_SHAPE = class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public NullSpikeBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)VERTICAL_DIRECTION, (Comparable)class_2350.field_11036)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{VERTICAL_DIRECTION, WATERLOGGED});
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return NullSpikeBlock.canPlaceAtWithDirection(world, pos, (class_2350)state.method_11654((class_2769)VERTICAL_DIRECTION));
    }

    public void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        class_2338 blockPos = hit.method_17777();
        if (!world.field_9236 && projectile.method_36971(world, blockPos) && projectile instanceof class_1685 && projectile.method_18798().method_1033() > 0.6) {
            world.method_22352(blockPos, true);
        }
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (state.method_11654((class_2769)VERTICAL_DIRECTION) == class_2350.field_11036) {
            entity.method_5747(fallDistance + 3.0f, 3.0f, world.method_48963().method_48837());
        } else {
            super.method_9554(world, state, pos, entity, fallDistance);
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (NullSpikeBlock.isPointingUp(state) && !this.method_9558(state, (class_4538)world, pos)) {
            world.method_22352(pos, true);
        } else {
            NullSpikeBlock.spawnFallingBlock(state, world, pos);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        world.method_39279(pos, (class_2248)this, 2);
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction;
        class_2338 blockPos;
        class_1937 worldAccess = ctx.method_8045();
        class_2350 direction2 = NullSpikeBlock.getDirectionToPlaceAt((class_4538)worldAccess, blockPos = ctx.method_8037(), direction = ctx.method_32760().method_10153());
        if (direction2 == null) {
            return null;
        }
        boolean bl = !ctx.method_8046();
        class_5691 thickness = NullSpikeBlock.getThickness((class_4538)worldAccess, blockPos, direction2, bl);
        return thickness == null ? null : (class_2680)((class_2680)this.method_9564().method_11657((class_2769)VERTICAL_DIRECTION, (Comparable)direction2)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(worldAccess.method_8316(blockPos).method_15772() == class_3612.field_15910));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_265 method_9571(class_2680 state, class_1922 world, class_2338 pos) {
        return class_259.method_1073();
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 voxelShape = state.method_11654((class_2769)VERTICAL_DIRECTION) == class_2350.field_11033 ? DOWN_TIP_SHAPE : UP_TIP_SHAPE;
        class_243 vec3d = state.method_26226(world, pos);
        return voxelShape.method_1096(vec3d.field_1352, 0.0, vec3d.field_1350);
    }

    public boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    public float method_32913() {
        return 0.125f;
    }

    public void method_10129(class_1937 world, class_2338 pos, class_1540 fallingBlockEntity) {
        if (!fallingBlockEntity.method_5701()) {
            world.method_20290(1045, pos, 0);
        }
    }

    public class_1282 method_32898(class_1297 attacker) {
        return attacker.method_48923().method_48814(attacker);
    }

    private static void spawnFallingBlock(class_2680 state, class_3218 world, class_2338 pos) {
        block0: {
            class_2338.class_2339 mutable = pos.method_25503();
            class_2680 blockState = state;
            if (!NullSpikeBlock.isPointingDown(blockState)) break block0;
            class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)world, (class_2338)mutable, (class_2680)blockState);
            int i = Math.max(1 + pos.method_10264() - mutable.method_10264(), 6);
            float f = 1.0f * (float)i;
            fallingBlockEntity.method_6965(f, 40);
        }
    }

    @Nullable
    private static class_2350 getDirectionToPlaceAt(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2350 direction2;
        if (NullSpikeBlock.canPlaceAtWithDirection(world, pos, direction)) {
            direction2 = direction;
        } else {
            if (!NullSpikeBlock.canPlaceAtWithDirection(world, pos, direction.method_10153())) {
                return null;
            }
            direction2 = direction.method_10153();
        }
        return direction2;
    }

    private static class_5691 getThickness(class_4538 world, class_2338 pos, class_2350 direction, boolean tryMerge) {
        return class_5691.field_28065;
    }

    private static boolean canPlaceAtWithDirection(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        class_2680 blockState = world.method_8320(blockPos);
        return blockState.method_26206((class_1922)world, blockPos, direction) || NullSpikeBlock.isPointedDripstoneFacingDirection(blockState, direction);
    }

    private static boolean isTip(class_2680 state, class_2350 direction) {
        return state.method_11654((class_2769)VERTICAL_DIRECTION) == direction;
    }

    private static boolean isPointingDown(class_2680 state) {
        return NullSpikeBlock.isPointedDripstoneFacingDirection(state, class_2350.field_11033);
    }

    private static boolean isPointingUp(class_2680 state) {
        return NullSpikeBlock.isPointedDripstoneFacingDirection(state, class_2350.field_11036);
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    private static boolean isPointedDripstoneFacingDirection(class_2680 state, class_2350 direction) {
        return state.method_27852((class_2248)ModBlocks.NULL_SPIKE) && state.method_11654((class_2769)VERTICAL_DIRECTION) == direction;
    }
}

