/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.blocks.blockEntities;

import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_5820;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.blocks.MultiblockCrafter;
import org.oxytocina.geomancy.blocks.blockEntities.IHammerable;
import org.oxytocina.geomancy.blocks.blockEntities.ModBlockEntities;
import org.oxytocina.geomancy.client.screen.SmitheryScreenHandler;
import org.oxytocina.geomancy.client.util.CamShakeUtil;
import org.oxytocina.geomancy.inventories.AutoCraftingInventory;
import org.oxytocina.geomancy.inventories.ImplementedInventory;
import org.oxytocina.geomancy.items.tools.HammerItem;
import org.oxytocina.geomancy.recipe.smithery.SmitheryRecipeI;
import org.oxytocina.geomancy.recipe.smithery.SmithingIngredient;
import org.oxytocina.geomancy.registries.ModRecipeTypes;
import org.oxytocina.geomancy.sound.ModSoundEvents;
import org.oxytocina.geomancy.util.ParticleUtil;
import org.oxytocina.geomancy.util.Toolbox;

public class SmitheryBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory,
IHammerable {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)10, (Object)class_1799.field_8037);
    private final class_5820 mishapRandom = new class_5820(1L);
    public static final int BASE_SLOT = 4;
    public static final int OUTPUT_SLOT = 9;
    public static final int INPUT_SLOT_COUNT = 9;
    public static final int SLOT_COUNT = 10;
    protected final class_3913 propertyDelegate;
    private int progress = 0;
    private int maxProgress = 72;
    public SmitheryRecipeI currentRecipe = null;
    public class_1799 currentResult = class_1799.field_8037;
    private boolean initialized = false;
    private class_1799 lastHammerStack = class_1799.field_8037;
    private class_1657 lastHammerer = null;
    private int automatedHitCooldown = 0;
    private static final AutoCraftingInventory AUTO_INVENTORY = new AutoCraftingInventory(10, 1);

    public SmitheryBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.SMITHERY_BLOCK_ENTITY, pos, state);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> SmitheryBlockEntity.this.progress;
                    case 1 -> SmitheryBlockEntity.this.maxProgress;
                    case 2 -> {
                        if (SmitheryBlockEntity.this.currentRecipe != null) {
                            yield SmitheryBlockEntity.this.currentRecipe.getDifficulty((class_1263)SmitheryBlockEntity.this.inputInventory(), SmitheryBlockEntity.this.getLastHammerStack(), (class_1309)SmitheryBlockEntity.this.getLastHammerer());
                        }
                        yield -1;
                    }
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        SmitheryBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        SmitheryBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int method_17389() {
                return 3;
            }
        };
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("progress", this.progress);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.method_5448();
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.progress = nbt.method_10550("progress");
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.geomancy.smithery_block");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new SmitheryScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (!this.initialized) {
            this.initialize(world, pos, state);
        }
        SmitheryRecipeI prevRecipe = this.currentRecipe;
        this.currentRecipe = this.getRecipe();
        class_1799 previousResult = this.currentResult;
        if (this.hasRecipe()) {
            this.currentResult = this.currentRecipe.getPreviewOutput((class_1263)this.inputInventory());
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
                this.method_5431();
            }
        } else {
            this.currentResult = class_1799.field_8037;
        }
        if (prevRecipe != this.currentRecipe) {
            this.recipeChanged();
        }
        if (!Toolbox.itemStacksAreEqual(previousResult, this.currentResult)) {
            this.recipeChanged();
        }
        if (this.automatedHitCooldown > 0) {
            --this.automatedHitCooldown;
        }
    }

    private void initialize(class_1937 world, class_2338 pos, class_2680 state) {
        this.recipeChanged();
        this.initialized = true;
    }

    private void recipeChanged() {
        if (this.field_11863 == null) {
            return;
        }
        this.currentRecipe = this.getRecipe();
        this.resetProgress();
        this.maxProgress = this.currentRecipe != null ? this.currentRecipe.getProgressRequired((class_1263)this.inputInventory()) : 10000;
        this.setOutput(this.currentRecipe != null ? this.currentRecipe.getPreviewOutput((class_1263)this.inputInventory()) : class_1799.field_8037);
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        SmitheryRecipeI recipe = this.getRecipe();
        if (recipe != null) {
            List<class_1799> results = this.craft(recipe, this.inventory, this.field_11863);
            for (class_1799 result : results) {
                int count = result.method_7947();
                if (this.field_11863.field_9236) continue;
                MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(this.field_11863, class_243.method_24953((class_2382)this.field_11867).method_1019(new class_243(0.0, 1.0, 0.0)), result, count, new class_243(0.0, 0.25, 0.0), false, null);
            }
            this.field_11863.method_8396(null, this.field_11867, ModSoundEvents.SMITHERY_FINISHED, class_3419.field_15245, 1.0f, 0.6f + this.field_11863.method_8409().method_43057() * 0.2f);
        }
        this.recipeChanged();
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private boolean hasRecipe() {
        return this.currentRecipe != null;
    }

    private SmitheryRecipeI getRecipe() {
        return this.getRecipeFor(this.field_11863, this.getItems());
    }

    private void increaseCraftProgress(int amount) {
        this.progress += amount;
    }

    public SmitheryRecipeI getRecipeFor(@NotNull class_1937 world, class_2371<class_1799> inventory) {
        AUTO_INVENTORY.setInputInventory((List<class_1799>)this.inputInventory().getItems());
        SmitheryRecipeI res = world.method_8433().method_8132(ModRecipeTypes.SMITHING, (class_1263)AUTO_INVENTORY, world).orElse(null);
        if (res == null) {
            res = world.method_8433().method_8132(ModRecipeTypes.JEWELRY, (class_1263)AUTO_INVENTORY, world).orElse(null);
        }
        if (res == null) {
            res = world.method_8433().method_8132(ModRecipeTypes.GEODE, (class_1263)AUTO_INVENTORY, world).orElse(null);
        }
        return res;
    }

    public ImplementedInventory inputInventory() {
        ImplementedInventory inputInventory = ImplementedInventory.ofSize(9);
        for (int i = 0; i < 9; ++i) {
            inputInventory.method_5447(i, this.method_5438(i));
        }
        return inputInventory;
    }

    public void setOutput(class_1799 stack) {
        this.method_5447(9, stack);
    }

    public List<class_1799> craft(SmitheryRecipeI recipe, class_2371<class_1799> inventory, class_1937 world) {
        AUTO_INVENTORY.setInputInventory((List<class_1799>)inventory);
        return recipe.getSmithingResult((class_1263)AUTO_INVENTORY, true, false, this.getLastHammerStack(), (class_1309)this.getLastHammerer(), world);
    }

    @Override
    public void onHitWithHammer(@Nullable class_1657 player, class_1799 hammer, float skill) {
        if (this.field_11863 == null) {
            return;
        }
        if (player == null && this.automatedHitCooldown > 0) {
            return;
        }
        HammerItem hammerItem = (HammerItem)hammer.method_7909();
        this.lastHammerer = player;
        this.lastHammerStack = hammer;
        if (player == null) {
            this.automatedHitCooldown = hammerItem.getCooldown(null);
        }
        if (this.skillcheckPassed(skill, hammer, (class_1309)player)) {
            this.increaseCraftProgress(hammerItem.getHitProgress(player));
            if (!this.field_11863.field_9236) {
                class_243 particlePos = class_243.method_24953((class_2382)this.field_11867);
                if (!this.hasCraftingFinished()) {
                    this.field_11863.method_8396(null, this.field_11867, ModSoundEvents.USE_HAMMER, class_3419.field_15245, 0.7f, 0.9f + this.field_11863.method_8409().method_43057() * 0.2f);
                    ParticleUtil.ParticleData.createSmithingProgress(this.field_11863, particlePos).send();
                    CamShakeUtil.cause(this.field_11863, this.method_11016().method_46558(), 10.0f, 0.5f);
                } else {
                    ParticleUtil.ParticleData.createSmithingComplete(this.field_11863, particlePos).send();
                    CamShakeUtil.cause(this.field_11863, this.method_11016().method_46558(), 10.0f, 0.5f);
                }
            }
        } else {
            boolean playFailSound = true;
            int[] mishapTypeWeights = new int[]{10, 1, 10, player != null ? 10 : 0, 5};
            int mishapType = Toolbox.selectWeightedRandomIndex(mishapTypeWeights);
            switch (mishapType) {
                case 0: {
                    int slotID = this.getMishapInputItemSlotIndex();
                    class_1799 stackToDrop = this.method_5438(slotID);
                    this.method_5447(slotID, class_1799.field_8037);
                    class_243 spos = class_243.method_24953((class_2382)this.field_11867).method_1031(0.0, (double)0.6f, 0.0);
                    class_1264.method_5449((class_1937)this.field_11863, (double)spos.field_1352, (double)spos.field_1351, (double)spos.field_1350, (class_1799)stackToDrop);
                    CamShakeUtil.cause(this.field_11863, this.method_11016().method_46558(), 10.0f, 0.5f);
                    break;
                }
                case 1: {
                    int slotID = this.getMishapInputItemSlotIndex();
                    this.method_5447(slotID, class_1799.field_8037);
                    if (!this.field_11863.field_9236) {
                        this.field_11863.method_8396(null, this.field_11867, class_3417.field_15075, class_3419.field_15245, 2.0f, 0.5f + this.field_11863.method_8409().method_43057() * 0.2f);
                        CamShakeUtil.cause(this.field_11863, this.method_11016().method_46558(), 10.0f, 0.5f);
                    }
                    if (player == null) break;
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.geomancy.smithery_block.json.fail.break"), false);
                    break;
                }
                case 2: {
                    this.increaseCraftProgress(-hammerItem.getHitProgress(player));
                    break;
                }
                case 3: {
                    if (player == null) break;
                    player.method_7329(hammer.method_7972(), true, true);
                    player.method_6047().method_7939(0);
                    playFailSound = false;
                    if (this.field_11863.field_9236) break;
                    this.field_11863.method_8396(null, this.field_11867, ModSoundEvents.USE_HAMMER_SLIP, class_3419.field_15245, 0.9f, 0.9f + this.field_11863.method_8409().method_43057() * 0.2f);
                    break;
                }
                case 4: {
                    this.resetProgress();
                    break;
                }
            }
            if (playFailSound && !this.field_11863.field_9236) {
                this.field_11863.method_8396(null, this.field_11867, ModSoundEvents.USE_HAMMER_FAIL, class_3419.field_15245, 0.9f, 0.9f + this.field_11863.method_8409().method_43057() * 0.2f);
                class_243 particlePos = class_243.method_24953((class_2382)this.field_11867);
                ParticleUtil.ParticleData.createSmithingFailure(this.field_11863, particlePos).send();
                CamShakeUtil.cause(this.field_11863, this.method_11016().method_46558(), 10.0f, 0.5f);
            }
            this.method_5431();
        }
    }

    public int getMishapInputItemSlotIndex() {
        if (this.currentRecipe == null) {
            return -1;
        }
        ImplementedInventory inputs = this.inputInventory();
        HashMap<Integer, Integer> weights = new HashMap<Integer, Integer>();
        block0: for (int i = 0; i < inputs.method_5439(); ++i) {
            for (SmithingIngredient ing : this.currentRecipe.getSmithingIngredients((class_1263)inputs)) {
                if (!ing.test(inputs.method_5438(i))) continue;
                weights.put(i, ing.mishapWeight);
                continue block0;
            }
        }
        return Toolbox.selectWeightedRandomIndex(weights, -1);
    }

    public boolean skillcheckPassed(float skill, class_1799 hammer, class_1309 hammerer) {
        float random;
        if (this.currentRecipe == null) {
            return false;
        }
        float fraction = skill / (float)this.currentRecipe.getDifficulty((class_1263)this.inputInventory(), hammer, hammerer);
        return fraction > (random = this.mishapRandom.method_43057());
    }

    public class_1799 getBaseStack() {
        if (this.currentRecipe == null || !this.currentRecipe.hasBaseStack()) {
            return class_1799.field_8037;
        }
        return this.method_5438(4);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void inventoryChanged() {
        this.recipeChanged();
    }

    @Override
    public void method_5431() {
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        super.method_5431();
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        if (slot >= 9) {
            return false;
        }
        return ImplementedInventory.super.method_5493(slot, stack, side);
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 side) {
        if (slot >= 9) {
            return false;
        }
        return ImplementedInventory.super.method_5492(slot, stack, side);
    }

    public boolean method_49104(class_1263 hopperInventory, int slot, class_1799 stack) {
        if (slot >= 9) {
            return false;
        }
        return ImplementedInventory.super.method_49104(hopperInventory, slot, stack);
    }

    @Override
    public class_1799 method_5441(int slot) {
        if (slot < 9) {
            this.inventoryChanged();
        }
        return ImplementedInventory.super.method_5441(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int count) {
        if (slot < 9) {
            this.inventoryChanged();
        }
        return ImplementedInventory.super.method_5434(slot, count);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        if (slot < 9) {
            this.inventoryChanged();
        }
        ImplementedInventory.super.method_5447(slot, stack);
    }

    @Override
    public class_1799 getLastHammerStack() {
        return this.lastHammerStack;
    }

    @Override
    public class_1657 getLastHammerer() {
        return this.lastHammerer;
    }

    @Override
    public boolean isHammerable() {
        return this.currentRecipe != null;
    }
}

