/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client;

import java.util.Arrays;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.minecraft.class_7877;
import net.minecraft.class_7924;
import org.oxytocina.geomancy.client.datagen.ModAdvancementProvider;
import org.oxytocina.geomancy.client.datagen.ModBiomeTagProvider;
import org.oxytocina.geomancy.client.datagen.ModBlockLootTableProvider;
import org.oxytocina.geomancy.client.datagen.ModBlockTagProvider;
import org.oxytocina.geomancy.client.datagen.ModChestLootTableProvider;
import org.oxytocina.geomancy.client.datagen.ModDamageTypeTagProvider;
import org.oxytocina.geomancy.client.datagen.ModEnglishLangProvider;
import org.oxytocina.geomancy.client.datagen.ModFluidTagProvider;
import org.oxytocina.geomancy.client.datagen.ModItemTagProvider;
import org.oxytocina.geomancy.client.datagen.ModModelProvider;
import org.oxytocina.geomancy.client.datagen.ModRecipeProvider;
import org.oxytocina.geomancy.client.datagen.ModSoundProvider;
import org.oxytocina.geomancy.client.datagen.ModWorldGenerator;
import org.oxytocina.geomancy.world.ModConfiguredFeatures;
import org.oxytocina.geomancy.world.ModPlacedFeatures;
import org.oxytocina.geomancy.world.biome.ModBiomes;
import org.oxytocina.geomancy.world.dimension.ModDimensions;

public class GeomancyDataGenerator
implements DataGeneratorEntrypoint {
    public static boolean initialized = false;

    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        GeomancyDataGenerator.init(fabricDataGenerator);
    }

    public static synchronized void init(FabricDataGenerator fabricDataGenerator) {
        if (initialized) {
            return;
        }
        try {
            FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
            pack.addProvider(ModAdvancementProvider::new);
            ModBlockTagProvider.precalcHybrids();
            pack.addProvider(ModBlockTagProvider::new);
            pack.addProvider(ModItemTagProvider::new);
            pack.addProvider(ModBiomeTagProvider::new);
            pack.addProvider(ModFluidTagProvider::new);
            pack.addProvider(ModDamageTypeTagProvider::new);
            pack.addProvider(ModBlockLootTableProvider::new);
            pack.addProvider(ModModelProvider::new);
            pack.addProvider(ModEnglishLangProvider::new);
            pack.addProvider(ModRecipeProvider::new);
            pack.addProvider(ModChestLootTableProvider::new);
            pack.addProvider(ModSoundProvider::new);
            pack.addProvider(ModWorldGenerator::new);
        }
        catch (Throwable t) {
            RuntimeException exception = new RuntimeException(String.format("Geomancy Initialization failed!", t.fillInStackTrace(), Arrays.toString(t.getStackTrace())));
            Log.debug((LogCategory)LogCategory.ENTRYPOINT, (String)"Geomancy");
            throw t;
        }
        initialized = true;
    }

    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41239, ModConfiguredFeatures::boostrap);
        registryBuilder.method_46777(class_7924.field_41245, ModPlacedFeatures::boostrap);
        registryBuilder.method_46777(class_7924.field_41236, ModBiomes::boostrap);
        registryBuilder.method_46777(class_7924.field_41241, ModDimensions::bootstrapType);
    }
}

