/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client.datagen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.oxytocina.geomancy.blocks.ExtraBlockSettings;
import org.oxytocina.geomancy.blocks.ModBlocks;
import org.oxytocina.geomancy.registries.ModBlockTags;
import org.oxytocina.geomancy.registries.ModItemTags;

public class ModBlockTagProvider
extends FabricTagProvider<class_2248> {
    protected static Map<class_6862<class_2248>, List<class_2248>> HYBRID_BLOCKS = new HashMap<class_6862<class_2248>, List<class_2248>>();
    protected static Map<class_6862<class_2248>, List<class_6862<class_2248>>> HYBRID_TAGS = new HashMap<class_6862<class_2248>, List<class_6862<class_2248>>>();
    public static Map<class_6862<class_1792>, List<class_2248>> HYBRID_ITEM_BLOCKS = new HashMap<class_6862<class_1792>, List<class_2248>>();
    public static Map<class_6862<class_1792>, List<class_6862<class_1792>>> HYBRID_ITEM_TAGS = new HashMap<class_6862<class_1792>, List<class_6862<class_1792>>>();

    public ModBlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, class_7924.field_41254, registriesFuture);
    }

    public static void precalcHybrids() {
        for (class_2248 class_22482 : ExtraBlockSettings.WallBlocks.keySet()) {
            ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_15504, (class_6862<class_1792>)class_3489.field_15560, class_22482);
        }
        for (class_2248 class_22483 : ExtraBlockSettings.FenceBlocks.keySet()) {
            ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_16584, (class_6862<class_1792>)class_3489.field_16585, class_22483);
        }
        ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_17619, (class_6862<class_1792>)class_3489.field_17620, new class_2248[]{ModBlocks.SOUL_OAK_FENCE});
        for (class_2248 class_22484 : ExtraBlockSettings.FenceBlocks.keySet()) {
            ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_25147, (class_6862<class_1792>)class_3489.field_40858, class_22484);
        }
        for (class_2248 class_22485 : ExtraBlockSettings.StairsBlocks.keySet()) {
            ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_15459, (class_6862<class_1792>)class_3489.field_15526, class_22485);
        }
        for (class_2248 class_22486 : ExtraBlockSettings.SlabBlocks.keySet()) {
            ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_15469, (class_6862<class_1792>)class_3489.field_15535, class_22486);
        }
        ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_23119, (class_6862<class_1792>)class_3489.field_23801, ModBlocks.NULL_CRYSTAL);
        ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_15471, (class_6862<class_1792>)class_3489.field_15537, ModBlocks.SOUL_OAK_PLANKS);
        ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_23210, (class_6862<class_1792>)class_3489.field_23212, new class_2248[]{ModBlocks.SOUL_OAK_LOG, ModBlocks.STRIPPED_SOUL_OAK_LOG, ModBlocks.SOUL_OAK_WOOD, ModBlocks.STRIPPED_SOUL_OAK_WOOD});
        ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_15499, (class_6862<class_1792>)class_3489.field_15555, ModBlocks.SOUL_OAK_BUTTON);
        ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_15494, (class_6862<class_1792>)class_3489.field_15552, new class_2248[]{ModBlocks.SOUL_OAK_DOOR});
        ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_17619, (class_6862<class_1792>)class_3489.field_17620, new class_2248[]{ModBlocks.SOUL_OAK_FENCE});
        ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_15468, (class_6862<class_1792>)class_3489.field_15534, new class_2248[]{ModBlocks.SOUL_OAK_SLAB});
        ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_15502, (class_6862<class_1792>)class_3489.field_15557, new class_2248[]{ModBlocks.SOUL_OAK_STAIRS});
        ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_15477, (class_6862<class_1792>)class_3489.field_15540, ModBlocks.SOUL_OAK_PRESSURE_PLATE);
        ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_15491, (class_6862<class_1792>)class_3489.field_15550, new class_2248[]{ModBlocks.SOUL_OAK_TRAPDOOR});
        ModBlockTagProvider.addHybridTag((class_6862<class_2248>)class_3481.field_23210, (class_6862<class_1792>)class_3489.field_23212, ModBlockTags.SOUL_OAK_LOGS, ModItemTags.SOUL_OAK_LOGS);
        ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_15503, (class_6862<class_1792>)class_3489.field_15558, ModBlocks.SOUL_OAK_LEAVES);
        ModBlockTagProvider.addHybrid((class_6862<class_2248>)class_3481.field_15462, (class_6862<class_1792>)class_3489.field_15528, new class_2248[]{ModBlocks.SOUL_OAK_SAPLING});
        ModBlockTagProvider.addHybrid(ModBlockTags.SOUL_OAK_LOGS, ModItemTags.SOUL_OAK_LOGS, new class_2248[]{ModBlocks.SOUL_OAK_LOG, ModBlocks.SOUL_OAK_WOOD, ModBlocks.STRIPPED_SOUL_OAK_LOG, ModBlocks.STRIPPED_SOUL_OAK_WOOD});
        ModBlockTagProvider.addHybrid(ModBlockTags.LEAD_ORES, ModItemTags.LEAD_ORES, new class_2248[]{ModBlocks.LEAD_ORE, ModBlocks.DEEPSLATE_LEAD_ORE});
        ModBlockTagProvider.addHybrid(ModBlockTags.MOLYBDENUM_ORES, ModItemTags.MOLYBDENUM_ORES, new class_2248[]{ModBlocks.MOLYBDENUM_ORE, ModBlocks.DEEPSLATE_MOLYBDENUM_ORE});
        ModBlockTagProvider.addHybrid(ModBlockTags.TITANIUM_ORES, ModItemTags.TITANIUM_ORES, new class_2248[]{ModBlocks.TITANIUM_ORE, ModBlocks.DEEPSLATE_TITANIUM_ORE});
        ModBlockTagProvider.addHybrid(ModBlockTags.MITHRIL_ORES, ModItemTags.MITHRIL_ORES, new class_2248[]{ModBlocks.MITHRIL_ORE, ModBlocks.DEEPSLATE_MITHRIL_ORE});
        ModBlockTagProvider.addHybrid(ModBlockTags.OCTANGULITE_ORES, ModItemTags.OCTANGULITE_ORES, new class_2248[]{ModBlocks.OCTANGULITE_ORE, ModBlocks.DEEPSLATE_OCTANGULITE_ORE});
        ModBlockTagProvider.addHybrid(ModBlockTags.PERIDOT_ORES, ModItemTags.PERIDOT_ORES, new class_2248[]{ModBlocks.PERIDOT_ORE, ModBlocks.DEEPSLATE_PERIDOT_ORE});
        ModBlockTagProvider.addHybrid(ModBlockTags.AXINITE_ORES, ModItemTags.AXINITE_ORES, new class_2248[]{ModBlocks.AXINITE_ORE, ModBlocks.DEEPSLATE_AXINITE_ORE});
        ModBlockTagProvider.addHybrid(ModBlockTags.TOURMALINE_ORES, ModItemTags.TOURMALINE_ORES, new class_2248[]{ModBlocks.TOURMALINE_ORE, ModBlocks.DEEPSLATE_TOURMALINE_ORE});
        ModBlockTagProvider.addHybrid(ModBlockTags.ORTHOCLASE_ORES, ModItemTags.ORTHOCLASE_ORES, new class_2248[]{ModBlocks.ORTHOCLASE_ORE, ModBlocks.DEEPSLATE_ORTHOCLASE_ORE});
        ModBlockTagProvider.addHybridTags(ModBlockTags.C_ORES, ModItemTags.C_ORES, List.of(ModBlockTags.LEAD_ORES, ModBlockTags.MOLYBDENUM_ORES, ModBlockTags.TITANIUM_ORES, ModBlockTags.MITHRIL_ORES, ModBlockTags.OCTANGULITE_ORES, ModBlockTags.PERIDOT_ORES, ModBlockTags.AXINITE_ORES, ModBlockTags.TOURMALINE_ORES, ModBlockTags.ORTHOCLASE_ORES), List.of(ModItemTags.LEAD_ORES, ModItemTags.MOLYBDENUM_ORES, ModItemTags.TITANIUM_ORES, ModItemTags.MITHRIL_ORES, ModItemTags.OCTANGULITE_ORES, ModItemTags.PERIDOT_ORES, ModItemTags.AXINITE_ORES, ModItemTags.TOURMALINE_ORES, ModItemTags.ORTHOCLASE_ORES));
    }

    protected void method_10514(class_7225.class_7874 wrapperLookup) {
        FabricTagProvider.FabricTagBuilder builder = this.getOrCreateTagBuilder(ModBlockTags.PICKAXE_MINEABLES).setReplace(false);
        for (class_2248 b : ExtraBlockSettings.ToolableBlock_Pickaxe) {
            builder.add((Object)b);
        }
        builder = this.getOrCreateTagBuilder(ModBlockTags.AXE_MINEABLES).setReplace(false);
        for (class_2248 b : ExtraBlockSettings.ToolableBlock_Axe) {
            builder.add((Object)b);
        }
        builder = this.getOrCreateTagBuilder(ModBlockTags.SHOVEL_MINEABLES).setReplace(false);
        for (class_2248 b : ExtraBlockSettings.ToolableBlock_Shovel) {
            builder.add((Object)b);
        }
        builder = this.getOrCreateTagBuilder(ModBlockTags.HOE_MINEABLES).setReplace(false);
        for (class_2248 b : ExtraBlockSettings.ToolableBlock_Hoe) {
            builder.add((Object)b);
        }
        this.getOrCreateTagBuilder(class_3481.field_22414).setReplace(false).add((Object)ModBlocks.IRIDESCENT_VINES);
        FabricTagProvider.FabricTagBuilder levelbuilder_stone = this.getOrCreateTagBuilder(ModBlockTags.MININGLEVEL_STONE).setReplace(false);
        FabricTagProvider.FabricTagBuilder levelbuilder_iron = this.getOrCreateTagBuilder(ModBlockTags.MININGLEVEL_IRON).setReplace(false);
        FabricTagProvider.FabricTagBuilder levelbuilder_diamond = this.getOrCreateTagBuilder(ModBlockTags.MININGLEVEL_DIAMOND).setReplace(false);
        for (class_2248 b : ExtraBlockSettings.BlockMiningLevels.keySet()) {
            switch (ExtraBlockSettings.BlockMiningLevels.get(b)) {
                case 1: {
                    levelbuilder_stone.add((Object)b);
                    break;
                }
                case 2: {
                    levelbuilder_iron.add((Object)b);
                    break;
                }
                case 3: {
                    levelbuilder_diamond.add((Object)b);
                    break;
                }
            }
        }
        FabricTagProvider.FabricTagBuilder builder_octangulite = this.getOrCreateTagBuilder(ModBlockTags.OCTANGULITE).setReplace(false).add((Object[])new class_2248[]{ModBlocks.OCTANGULITE_BLOCK, ModBlocks.RAW_OCTANGULITE_BLOCK, ModBlocks.OCTANGULITE_ORE, ModBlocks.DEEPSLATE_OCTANGULITE_ORE, ModBlocks.CUT_OCTANGULITE, ModBlocks.OCTANGULITE_BRICKS, ModBlocks.OCTANGULITE_BRICK_STAIRS, ModBlocks.OCTANGULITE_BRICK_SLABS, ModBlocks.OCTANGULITE_BRICK_WALL});
        this.getOrCreateTagBuilder(ModBlockTags.NULL_BLOCKS).setReplace(false).add((Object[])new class_2248[]{ModBlocks.NULL_ROCK, ModBlocks.NULL_RUBBLE});
        this.getOrCreateTagBuilder(ModBlockTags.NULL_RUBBLE_REPLACEABLE).setReplace(false).add((Object)ModBlocks.NULL_ROCK);
        this.getOrCreateTagBuilder(ModBlockTags.NULL_CRYSTAL_REPLACEABLE).setReplace(false).add((Object)ModBlocks.NULL_ROCK);
        this.getOrCreateTagBuilder(ModBlockTags.NULL_HOLDS_SPIKES).setReplace(false).add((Object[])new class_2248[]{ModBlocks.NULL_ROCK, ModBlocks.NULL_RUBBLE});
        this.addSoulTag((class_6862<class_2248>)class_3481.field_15481, SoulLevel.Few);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_15479, SoulLevel.Few);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_15468, SoulLevel.Few);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_15502, SoulLevel.Few);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_15471, SoulLevel.Few);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_15475, SoulLevel.Few);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_21953, SoulLevel.Few);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_29822, SoulLevel.Few);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_15503, SoulLevel.Normal);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_20339, SoulLevel.Normal);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_15470, SoulLevel.Normal);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_15462, SoulLevel.Normal);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_20341, SoulLevel.Normal);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_15488, SoulLevel.Normal);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_15461, SoulLevel.Normal);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_28621, SoulLevel.Normal);
        this.addSoulBlocks(SoulLevel.Normal, class_2246.field_10597, class_2246.field_9993, class_2246.field_10463, class_2246.field_10214, class_2246.field_10238, class_2246.field_10479, class_2246.field_10376, class_2246.field_10476);
        this.addSoulTag((class_6862<class_2248>)class_3481.field_20340, SoulLevel.Many);
        this.addSoulTag(ModBlockTags.OCTANGULITE, SoulLevel.Many);
        this.addSoulBlocks(SoulLevel.Many, class_2246.field_10492, class_2246.field_10176, class_2246.field_29224, class_2246.field_10277, class_2246.field_10387, class_2246.field_10480, class_2246.field_10100);
        this.addSoulTag(ModBlockTags.NULL_BLOCKS, SoulLevel.RemoveMany);
        this.actualizeHybrids();
    }

    void addSoulBlock(class_2248 block) {
        this.addSoulBlocks(SoulLevel.Normal, block);
    }

    void addSoulBlocks(SoulLevel level, class_2248 ... blocks) {
        FabricTagProvider.FabricTagBuilder builder_main = this.getOrCreateTagBuilder(ModBlockTags.ADDS_SOULS).setReplace(false);
        FabricTagProvider.FabricTagBuilder builder_sub = this.getOrCreateTagBuilder(switch (level.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> ModBlockTags.ADDS_SOULS_FEW;
            case 1 -> ModBlockTags.ADDS_SOULS_NORMAL;
            case 2 -> ModBlockTags.ADDS_SOULS_MANY;
            case 3 -> ModBlockTags.REMOVES_SOULS_MANY;
        }).setReplace(false);
        for (class_2248 block : blocks) {
            builder_main.add((Object)block);
            builder_sub.add((Object)block);
        }
    }

    void addSoulTag(class_6862<class_2248> tag, SoulLevel level) {
        FabricTagProvider.FabricTagBuilder builder_main = this.getOrCreateTagBuilder(ModBlockTags.ADDS_SOULS).setReplace(false);
        FabricTagProvider.FabricTagBuilder builder_sub = this.getOrCreateTagBuilder(switch (level.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> ModBlockTags.ADDS_SOULS_FEW;
            case 1 -> ModBlockTags.ADDS_SOULS_NORMAL;
            case 2 -> ModBlockTags.ADDS_SOULS_MANY;
            case 3 -> ModBlockTags.REMOVES_SOULS_MANY;
        }).setReplace(false);
        builder_main.forceAddTag(tag);
        builder_sub.forceAddTag(tag);
    }

    public static void addHybrid(class_6862<class_2248> blockKey, class_6862<class_1792> itemKey, class_2248 ... blocks) {
        if (!HYBRID_BLOCKS.containsKey(blockKey)) {
            HYBRID_BLOCKS.put(blockKey, new ArrayList());
        }
        HYBRID_BLOCKS.get(blockKey).addAll(List.of(blocks));
        ModBlockTagProvider.addItems(itemKey, blocks);
    }

    public static void addHybridTags(class_6862<class_2248> blockKey, class_6862<class_1792> itemKey, List<class_6862<class_2248>> blockTagsToAdd, List<class_6862<class_1792>> itemTagsToAdd) {
        if (!HYBRID_TAGS.containsKey(blockKey)) {
            HYBRID_TAGS.put(blockKey, new ArrayList());
        }
        HYBRID_TAGS.get(blockKey).addAll(blockTagsToAdd);
        if (!HYBRID_ITEM_TAGS.containsKey(itemKey)) {
            HYBRID_ITEM_TAGS.put(itemKey, new ArrayList());
        }
        HYBRID_ITEM_TAGS.get(itemKey).addAll(itemTagsToAdd);
    }

    public static void addHybridTag(class_6862<class_2248> blockKey, class_6862<class_1792> itemKey, class_6862<class_2248> blockTagToAdd, class_6862<class_1792> itemTagToAdd) {
        ModBlockTagProvider.addHybridTags(blockKey, itemKey, List.of(blockTagToAdd), List.of(itemTagToAdd));
    }

    public static void addItems(class_6862<class_1792> itemKey, class_2248 ... blocks) {
        if (!HYBRID_ITEM_BLOCKS.containsKey(itemKey)) {
            HYBRID_ITEM_BLOCKS.put(itemKey, new ArrayList());
        }
        HYBRID_ITEM_BLOCKS.get(itemKey).addAll(List.of(blocks));
    }

    public void actualizeHybrids() {
        FabricTagProvider.FabricTagBuilder builder;
        for (Map.Entry<class_6862<class_2248>, List<class_2248>> entry : HYBRID_BLOCKS.entrySet()) {
            builder = this.getOrCreateTagBuilder(entry.getKey());
            builder.add((Object[])entry.getValue().toArray(new class_2248[0]));
        }
        for (Map.Entry<class_6862<class_2248>, List<class_2248>> entry : HYBRID_TAGS.entrySet()) {
            builder = this.getOrCreateTagBuilder(entry.getKey());
            for (class_6862 class_68622 : entry.getValue()) {
                builder.forceAddTag(class_68622);
            }
        }
    }

    static enum SoulLevel {
        Few,
        Normal,
        Many,
        RemoveMany;

    }
}

