/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client.datagen.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.recipe.CountIngredient;
import org.oxytocina.geomancy.recipe.NbtIngredient;
import org.oxytocina.geomancy.recipe.RecipeUtils;
import org.oxytocina.geomancy.registries.ModRecipeTypes;

public class SoulForgeRecipeJsonBuilder {
    private final class_7800 category;
    private final List<NbtIngredient> inputs;
    private final class_1799 output;
    private final int count;
    private final float cost;
    private final float instability;
    private final float speed;
    private final class_161.class_162 advancement = class_161.class_162.method_51698();
    @Nullable
    private final class_2960 requiredAdvancement;
    private final class_1865<?> serializer;

    public SoulForgeRecipeJsonBuilder(class_1865<?> serializer, class_7800 category, List<NbtIngredient> inputs, class_1799 output, int count, float cost, float instability, float speed, @Nullable class_2960 requiredAdvancement) {
        this.category = category;
        this.serializer = serializer;
        this.inputs = inputs;
        this.output = output;
        this.count = count;
        this.cost = cost;
        this.instability = instability;
        this.speed = speed;
        this.requiredAdvancement = requiredAdvancement;
    }

    public static SoulForgeRecipeJsonBuilder create(List<NbtIngredient> inputs, class_1792 output, int count, float cost, float instability, float speed, class_7800 category, class_2960 requiredAdvancement) {
        return new SoulForgeRecipeJsonBuilder(ModRecipeTypes.SOULFORGE_SIMPLE_SERIALIZER, category, inputs, new class_1799((class_1935)output), count, cost, instability, speed, requiredAdvancement);
    }

    public static SoulForgeRecipeJsonBuilder create(List<NbtIngredient> inputs, class_1799 output, int count, float cost, float instability, float speed, class_7800 category, class_2960 requiredAdvancement) {
        return new SoulForgeRecipeJsonBuilder(ModRecipeTypes.SOULFORGE_SIMPLE_SERIALIZER, category, inputs, output, count, cost, instability, speed, requiredAdvancement);
    }

    public SoulForgeRecipeJsonBuilder criterion(String name, class_184 conditions) {
        this.advancement.method_709(name, conditions);
        return this;
    }

    public void offerTo(Consumer<class_2444> exporter, class_2960 recipeId) {
        this.validate(recipeId);
        this.advancement.method_708(class_5797.field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_193.field_1257);
        exporter.accept(new Provider(recipeId, this.serializer, this.inputs, this.output, this.count, this.cost, this.instability, this.speed, this.advancement, recipeId.method_45138("recipes/" + this.category.method_46203() + "/"), this.requiredAdvancement));
    }

    private void validate(class_2960 recipeId) {
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
        }
    }

    public record Provider(class_2960 id, class_1865<?> type, List<NbtIngredient> inputs, class_1799 output, int count, float cost, float instability, float speed, class_161.class_162 advancement, class_2960 advancementId, class_2960 requiredAdvancement) implements class_2444
    {
        public void method_10416(JsonObject json) {
            JsonArray ingredientsArray = new JsonArray();
            for (CountIngredient countIngredient : this.inputs) {
                JsonObject ingredientElement = countIngredient.toJson().getAsJsonObject();
                ingredientElement.addProperty("count", (Number)countIngredient.count);
                ingredientsArray.add((JsonElement)ingredientElement);
            }
            json.add("ingredients", (JsonElement)ingredientsArray);
            JsonObject resultObject = new JsonObject();
            resultObject.add("item", (JsonElement)RecipeUtils.itemStackWithNbtToJson(this.output));
            json.addProperty("cost", (Number)Float.valueOf(this.cost));
            json.addProperty("instability", (Number)Float.valueOf(this.instability));
            json.addProperty("speed", (Number)Float.valueOf(this.speed));
            json.add("result", (JsonElement)resultObject);
            if (this.requiredAdvancement != null) {
                json.addProperty("required_advancement", this.requiredAdvancement.toString());
            }
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return this.type;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

