/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.client.GeomancyClient;
import org.oxytocina.geomancy.client.rendering.ModColorizationHandler;
import org.oxytocina.geomancy.items.ISpellSelectorItem;
import org.oxytocina.geomancy.registries.ModItemTags;
import org.oxytocina.geomancy.spells.SpellGrid;
import org.oxytocina.geomancy.util.DrawHelper;
import org.oxytocina.geomancy.util.SoulUtil;
import org.oxytocina.geomancy.util.Toolbox;

public class ModHudRenderer {
    public static float lastManaFraction = 0.0f;
    public static float manaUseShake = 0.0f;
    static float manaShakeX = 0.0f;
    static float manaShakeY = 0.0f;
    static float ambientManaArrowProgress = 0.0f;
    private static final class_2960 FILLED_THIRST = new class_2960("geomancy", "textures/item/artifact_of_gold.png");
    private static final class_2960 EMPTY_THIRST = new class_2960("geomancy", "textures/item/empty_artifact.png");
    private static boolean deltaFrame = false;
    private static long prevFrame = 0L;
    private static boolean standingStill = false;
    static final class_2960 ICON_TEXTURE = Geomancy.locate("textures/gui/icons.png");
    static final float MANA_BAR_TEXTURE_SIZE = 256.0f;
    private static List<class_3545<Float, Float>> PREV_DRAWN_BLOB_FRACTIONS = new ArrayList<class_3545<Float, Float>>();
    private static List<Float> BLOB_BREAKAGE = new ArrayList<Float>();
    private static float CROSSHAIR_ATTENTION = 0.0f;
    static final int CROSSHAIR_BLOB_SIZE = 9;
    static final float CROSSHAIR_BLOB_SCALE = 0.8f;

    public static void onHudRenderStatic(class_332 drawContext, class_1657 playerEntity) {
        float manaFraction;
        deltaFrame = GeomancyClient.tick != prevFrame;
        prevFrame = GeomancyClient.tick;
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1690.field_1842 || playerEntity == null || playerEntity.method_7325()) {
            return;
        }
        standingStill = client.field_1724.field_3913.method_3128().method_35584() < 0.03f && (playerEntity.method_24828() || Math.abs(playerEntity.method_18798().method_10214()) < 0.5);
        int x = 0;
        int y = 0;
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();
        x = width / 2;
        y = height;
        ModHudRenderer.renderManaBar(drawContext, playerEntity, x - 91);
        boolean drawSoulCrosshair = false;
        SpellGrid selectedGrid = null;
        for (class_1799 stack : playerEntity.method_5877()) {
            if (!stack.method_31573(ModItemTags.CASTING_ITEM)) continue;
            drawSoulCrosshair = true;
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof ISpellSelectorItem)) break;
            ISpellSelectorItem selector = (ISpellSelectorItem)class_17922;
            selectedGrid = selector.getSelectedSpell(stack);
            break;
        }
        if (drawSoulCrosshair) {
            ModHudRenderer.renderSoulCrosshair(drawContext, playerEntity, selectedGrid);
        } else {
            CROSSHAIR_ATTENTION = 2.0f;
        }
        lastManaFraction = manaFraction = Toolbox.clampF(SoulUtil.getSoul(playerEntity) / SoulUtil.getMaxSoul(playerEntity), 0.0f, 1.0f);
    }

    public static void renderManaBar(class_332 context, class_1657 player, int x) {
        class_310 client = class_310.method_1551();
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();
        if (SoulUtil.getMaxSoul(player) > 0.0f) {
            float manaFraction = Toolbox.clampF(SoulUtil.getSoul(player) / SoulUtil.getMaxSoul(player), 0.0f, 1.0f);
            float fractionDiff = manaFraction - lastManaFraction;
            if (fractionDiff < 0.0f) {
                manaUseShake -= fractionDiff;
            }
            int barWidth = (int)(manaFraction * 183.0f);
            int barHeight = 5;
            int y = height - 32 + 3;
            int col = ModColorizationHandler.octanguliteItemBarNoise(manaFraction);
            Vector3f colVec = Toolbox.colorIntToVec(col);
            float barX = (float)x + manaShakeX;
            float barY = (float)y + manaShakeY;
            if (barWidth > 0) {
                float alpha = 0.3f + 0.4f * (1.0f + (float)Math.sin((double)((float)GeomancyClient.tick / 20.0f / 3.0f * 2.0f) * Math.PI)) / 2.0f;
                RenderSystem.enableBlend();
                DrawHelper.drawTexturedQuad(context.method_51448(), ICON_TEXTURE, barX, barX + (float)barWidth, barY, barY + 5.0f, 0.0f, 0.0f, (float)barWidth / 256.0f, 0.05859375f, 0.078125f, colVec.x, colVec.y, colVec.z, alpha);
            }
            String string = Toolbox.formatNumber(Math.round(SoulUtil.getSoul(player))) + " / " + Toolbox.formatNumber(Math.round(SoulUtil.getMaxSoul(player)));
            if (ModHudRenderer.showAmbientMana()) {
                int t = Toolbox.floor(ambientManaArrowProgress * 2.999f);
                string = Math.round(SoulUtil.getAmbientSoulsPerBlock(player.method_37908(), player.method_24515())) + " " + (t % 3 == 0 ? ">" : "-") + (t % 3 == 1 ? ">" : "-") + (t % 3 == 2 ? ">" : "-") + " " + string;
            }
            float xPos = (float)(width - client.field_1772.method_1727(string)) / 2.0f + manaShakeX;
            float yPos = (float)(height - 31 - 4) + manaShakeY;
            if (player.field_7520 > 0) {
                yPos -= 11.0f;
            }
            DrawHelper.drawTextOutlined(context, client.field_1772, string, xPos, yPos, col, 0);
        }
    }

    public static void renderSoulCrosshair(class_332 context, class_1657 player, @Nullable SpellGrid selectedGrid) {
        int i;
        float maxSoul = SoulUtil.getMaxSoul(player);
        if (maxSoul <= 0.0f) {
            CROSSHAIR_ATTENTION = 2.0f;
            return;
        }
        RenderSystem.enableBlend();
        class_310 client = class_310.method_1551();
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();
        float centerX = (float)width / 2.0f;
        float centerY = (float)height / 2.0f;
        float soul = SoulUtil.getSoul(player);
        float soulFraction = Toolbox.clampF(soul / maxSoul, 0.0f, 1.0f);
        if (soulFraction < lastManaFraction) {
            CROSSHAIR_ATTENTION = 5.0f;
        } else if (!standingStill) {
            CROSSHAIR_ATTENTION = Math.max(0.0f, CROSSHAIR_ATTENTION - (deltaFrame ? 0.05f : 0.0f));
        } else if (CROSSHAIR_ATTENTION < 1.0f) {
            CROSSHAIR_ATTENTION += deltaFrame ? 0.05f : 0.0f;
        }
        int drawnBlobs = 1;
        ArrayList<class_3545<Float, Float>> drawnBlobFractions = new ArrayList<class_3545<Float, Float>>();
        switch ((String)Geomancy.CONFIG.soulCrosshairMath.value()) {
            case "linear": {
                float workMaxSoul = 10.0f;
                float workSoulLeft = soul;
                float workBlobMaxSoul = 10.0f;
                workSoulLeft -= workBlobMaxSoul;
                while (workMaxSoul < maxSoul) {
                    workMaxSoul += (workBlobMaxSoul *= 1.5f);
                    ++drawnBlobs;
                    workSoulLeft -= workBlobMaxSoul;
                }
                workBlobMaxSoul = maxSoul / (float)drawnBlobs;
                workSoulLeft = soul;
                for (i = 0; i < drawnBlobs; ++i) {
                    float soulForThisBlob = Math.min(workBlobMaxSoul, workSoulLeft);
                    workSoulLeft -= soulForThisBlob;
                    drawnBlobFractions.add(new class_3545((Object)Float.valueOf(Toolbox.clampF(soulForThisBlob / workBlobMaxSoul, 0.0f, 1.0f)), (Object)Float.valueOf(workBlobMaxSoul)));
                }
                break;
            }
            default: {
                float workMaxSoul = 10.0f;
                float workSoulLeft = soul;
                float workBlobMaxSoul = 10.0f;
                drawnBlobFractions.add(new class_3545((Object)Float.valueOf(Toolbox.clampF(workSoulLeft / workBlobMaxSoul, 0.0f, 1.0f)), (Object)Float.valueOf(workBlobMaxSoul)));
                workSoulLeft -= workBlobMaxSoul;
                while (workMaxSoul < maxSoul) {
                    workMaxSoul += (workBlobMaxSoul *= 1.5f);
                    ++drawnBlobs;
                    drawnBlobFractions.add(new class_3545((Object)Float.valueOf(Toolbox.clampF(workSoulLeft / workBlobMaxSoul, 0.0f, 1.0f)), (Object)Float.valueOf(workBlobMaxSoul)));
                    workSoulLeft -= workBlobMaxSoul;
                }
                break block4;
            }
        }
        ArrayList<Float> newBlobBreakage = new ArrayList<Float>();
        for (int i2 = 0; i2 < drawnBlobs && i2 < PREV_DRAWN_BLOB_FRACTIONS.size(); ++i2) {
            float fractionDiff = ((Float)((class_3545)drawnBlobFractions.get(i2)).method_15442()).floatValue() - ((Float)PREV_DRAWN_BLOB_FRACTIONS.get(i2).method_15442()).floatValue();
            if (((Float)((class_3545)drawnBlobFractions.get(i2)).method_15442()).floatValue() < 0.1f && fractionDiff <= -0.15f) {
                newBlobBreakage.add(Float.valueOf(1.0f));
                continue;
            }
            newBlobBreakage.add(Float.valueOf(BLOB_BREAKAGE.size() > i2 ? Math.max(0.0f, BLOB_BREAKAGE.get(i2).floatValue() - (deltaFrame ? 0.1f : 0.0f)) : 0.0f));
        }
        BLOB_BREAKAGE = newBlobBreakage;
        float minXOffset = -20.0f;
        float alpha = 0.2f + Toolbox.clampF(CROSSHAIR_ATTENTION, 0.0f, 1.0f) * 0.5f;
        switch ((String)Geomancy.CONFIG.soulCrosshairType.value()) {
            case "pyramid": {
                int currentBaseSize = 1;
                int currentLayer = 0;
                int layerI = 0;
                float heightPerLayer = 8.0f;
                float yOffset = 30.0f;
                for (int i3 = 0; i3 < drawnBlobs; ++i3) {
                    float offsetAmount = 10.0f;
                    float y = centerY - 3.6000001f + (float)currentLayer * heightPerLayer + yOffset;
                    boolean swapped = layerI % 2 == 0;
                    float x = centerX - 3.6000001f - offsetAmount * (currentLayer % 2 == 1 ? 0.5f : 0.0f) + offsetAmount * (float)((layerI + 1) / 2) * (float)(swapped ? -1 : 1);
                    ModHudRenderer.drawCrosshairBlob(context, drawnBlobFractions, i3, x, y);
                    if (++layerI < currentBaseSize) continue;
                    ++currentBaseSize;
                    layerI = 0;
                    ++currentLayer;
                }
                break;
            }
            case "hourglass": {
                int currentBaseSize = 1;
                int currentLayer = 0;
                int layerI = 0;
                float heightPerLayer = 8.0f;
                float yBuffer = 30.0f;
                for (int i4 = 0; i4 < drawnBlobs; ++i4) {
                    float offsetAmount = 10.0f;
                    int yFactor = i4 % 2 == 0 ? 1 : -1;
                    int sectionLayerI = layerI / 2;
                    float y = centerY - 3.6000001f + (float)currentLayer * heightPerLayer * (float)yFactor + yBuffer * (float)yFactor;
                    boolean swapped = sectionLayerI % 2 == 0;
                    float x = centerX - 3.6000001f - offsetAmount * (currentLayer % 2 == 1 ? 0.5f : 0.0f) + offsetAmount * (float)((sectionLayerI + 1) / 2) * (float)(swapped ? -1 : 1);
                    ModHudRenderer.drawCrosshairBlob(context, drawnBlobFractions, i4, x, y);
                    if (++layerI < currentBaseSize * 2) continue;
                    ++currentBaseSize;
                    layerI = 0;
                    ++currentLayer;
                }
                break;
            }
            case "focus": {
                int currentBaseSize = 1;
                int currentLayer = 0;
                int layerI = 0;
                float heightPerLayer = 8.0f;
                float yBuffer = 30.0f;
                for (int i5 = 0; i5 < drawnBlobs; ++i5) {
                    float offsetAmount = 10.0f;
                    int yFactor = i5 % 2 == 0 ? 1 : -1;
                    int sectionLayerI = layerI / 2;
                    float xOffset = (float)currentLayer * heightPerLayer * (float)yFactor + yBuffer * (float)yFactor;
                    if (xOffset < minXOffset) {
                        minXOffset = xOffset;
                    }
                    float x = centerX - 3.6000001f + xOffset;
                    boolean swapped = sectionLayerI % 2 == 0;
                    float y = centerY - 3.6000001f - offsetAmount * (currentLayer % 2 == 1 ? 0.5f : 0.0f) + offsetAmount * (float)((sectionLayerI + 1) / 2) * (float)(swapped ? -1 : 1);
                    ModHudRenderer.drawCrosshairBlob(context, drawnBlobFractions, i5, x, y);
                    if (++layerI < currentBaseSize * 2) continue;
                    ++currentBaseSize;
                    layerI = 0;
                    ++currentLayer;
                }
                break;
            }
            default: {
                for (i = 0; i < drawnBlobs; ++i) {
                    float angle = (float)Math.PI * 2 * (float)i / (float)drawnBlobs;
                    float offsetAmount = 20.0f;
                    if (drawnBlobs > 8) {
                        offsetAmount = 15.0f + (float)i * (2.0f / (1.0f + (float)i / 20.0f));
                        angle = (float)Math.PI * 2 * (float)i / 8.0f / (1.0f + (float)i / ((float)Math.PI * 10));
                    }
                    Vector2f offset = Toolbox.rotateVector(new Vector2f(0.0f, offsetAmount), angle);
                    float x = centerX + offset.x - 3.6000001f;
                    float y = centerY + offset.y - 3.6000001f;
                    if (offset.x < minXOffset) {
                        minXOffset = offset.x;
                    }
                    ModHudRenderer.drawCrosshairBlob(context, drawnBlobFractions, i, x, y);
                }
            }
        }
        if (selectedGrid != null && selectedGrid.displayStack != null) {
            float x = centerX + minXOffset - 20.0f - 4.5f;
            float y = centerY - 8.0f;
            DrawHelper.drawItem(context, (class_1309)player, player.method_37908(), selectedGrid.displayStack, x, y, 0, 1.0f, 1.0f, 1.0f, 1.0f, alpha);
        }
        PREV_DRAWN_BLOB_FRACTIONS = drawnBlobFractions;
    }

    private static void drawCrosshairBlob(class_332 context, List<class_3545<Float, Float>> drawnBlobFractions, int i, float x, float y) {
        class_3545<Float, Float> blobFraction = drawnBlobFractions.get(i);
        float breakageAnimation = BLOB_BREAKAGE.size() > i ? BLOB_BREAKAGE.get(i).floatValue() : 0.0f;
        boolean breaking = breakageAnimation > 0.0f;
        int fillage = Math.round(((Float)blobFraction.method_15442()).floatValue() * 6.0f);
        if (breaking) {
            fillage = Math.round((float)Math.floor((1.0f - breakageAnimation) * 4.0f));
        }
        int u = fillage * 9;
        int v = 32 + (breaking ? 16 : 0);
        int col = ModColorizationHandler.octanguliteItemBarNoise(((Float)blobFraction.method_15442()).floatValue(), 1.0f, i * 4, 0.0f, 0.0f);
        Vector3f colVec = Toolbox.colorIntToVec(col);
        float alpha = 0.2f + Toolbox.clampF(CROSSHAIR_ATTENTION, 0.0f, 1.0f) * 0.5f;
        DrawHelper.drawTexturedQuad(context.method_51448(), ICON_TEXTURE, x, x + 7.2000003f, y, y + 7.2000003f, 0.0f, (float)u / 256.0f, (float)(u + 9) / 256.0f, (float)v / 256.0f, (float)(v + 9) / 256.0f, colVec.x, colVec.y, colVec.z, alpha);
    }

    public static void tick() {
        manaUseShake = class_3532.method_16439((float)0.1f, (float)manaUseShake, (float)0.0f);
        manaShakeX = (int)Math.round(Math.sin(Math.PI * 4 * (double)GeomancyClient.tick / 20.0) * (double)manaUseShake * 20.0);
        manaShakeY = (int)Math.round(Math.sin(22.965042117978015 * (double)GeomancyClient.tick / 20.0) * (double)manaUseShake * 10.0);
        if (ModHudRenderer.showAmbientMana() && class_310.method_1551() != null && class_310.method_1551().field_1719 != null) {
            ambientManaArrowProgress += 1.25E-4f * SoulUtil.getAmbientSoulsPerBlock((class_1937)class_310.method_1551().field_1687, class_310.method_1551().field_1719.method_24515());
            ambientManaArrowProgress %= 1.0f;
        }
    }

    public static boolean showAmbientMana() {
        return true;
    }
}

