/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client.screen;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1143;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_3518;
import net.minecraft.class_437;
import net.minecraft.class_5195;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5819;
import net.minecraft.class_8020;
import org.apache.commons.lang3.StringUtils;
import org.oxytocina.geomancy.Geomancy;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class GeomancyCreditsScreen
extends class_437 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 VIGNETTE_TEXTURE = new class_2960("textures/misc/vignette.png");
    private static final class_2561 SEPARATOR_LINE = class_2561.method_43470((String)"============").method_27692(class_124.field_1068);
    private static final String CENTERED_LINE_PREFIX = "           ";
    private static final String OBFUSCATION_PLACEHOLDER = String.valueOf(class_124.field_1068) + String.valueOf(class_124.field_1051) + String.valueOf(class_124.field_1060) + String.valueOf(class_124.field_1075);
    private static final float SPACE_BAR_SPEED_MULTIPLIER = 5.0f;
    private static final float CTRL_KEY_SPEED_MULTIPLIER = 15.0f;
    private final boolean endCredits;
    private final Runnable finishAction;
    private float time;
    private List<class_5481> credits;
    private IntSet centeredLines;
    private int creditsHeight;
    private boolean spaceKeyPressed;
    private final IntSet pressedCtrlKeys = new IntOpenHashSet();
    private float speed;
    private final float baseSpeed;
    private int speedMultiplier;
    private final class_8020 logoDrawer = new class_8020(false);
    private final class_437 parent;

    public GeomancyCreditsScreen(class_437 parent, boolean endCredits, Runnable finishAction) {
        super(class_333.field_18967);
        this.parent = parent;
        this.endCredits = endCredits;
        this.finishAction = finishAction;
        this.baseSpeed = !endCredits ? 0.75f : 0.5f;
        this.speedMultiplier = 1;
        this.speed = this.baseSpeed;
    }

    private float getSpeed() {
        return this.spaceKeyPressed ? this.baseSpeed * (5.0f + (float)this.pressedCtrlKeys.size() * 15.0f) * (float)this.speedMultiplier : this.baseSpeed * (float)this.speedMultiplier;
    }

    public void method_25393() {
        this.field_22787.method_1538().method_18669();
        this.field_22787.method_1483().method_18670(false);
        float f = this.creditsHeight + this.field_22790 + this.field_22790 + 24;
        if (this.time > f) {
            this.closeScreen();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.speedMultiplier = -1;
        } else if (keyCode != 341 && keyCode != 345) {
            if (keyCode == 32) {
                this.spaceKeyPressed = true;
            }
        } else {
            this.pressedCtrlKeys.add(keyCode);
        }
        this.speed = this.getSpeed();
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.speedMultiplier = 1;
        }
        if (keyCode == 32) {
            this.spaceKeyPressed = false;
        } else if (keyCode == 341 || keyCode == 345) {
            this.pressedCtrlKeys.remove(keyCode);
        }
        this.speed = this.getSpeed();
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.closeScreen();
    }

    private void closeScreen() {
        this.finishAction.run();
        this.field_22787.method_1507(this.parent);
    }

    protected void method_25426() {
        if (this.credits == null) {
            this.credits = Lists.newArrayList();
            this.centeredLines = new IntOpenHashSet();
            if (this.endCredits) {
                this.load("texts/end.txt", this::readPoem);
            }
            this.load("texts/credits.json", this::readCredits);
            this.creditsHeight = this.credits.size() * 12;
        }
    }

    private void load(String id, CreditsReader reader) {
        try (BufferedReader reader2 = this.field_22787.method_1478().openAsReader(Geomancy.locate(id));){
            reader.read(reader2);
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load credits", (Throwable)exception);
        }
    }

    private void readPoem(Reader reader) throws IOException {
        int i;
        Object string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        class_5819 random = class_5819.method_43049((long)8124371L);
        while ((string = bufferedReader.readLine()) != null) {
            string = ((String)string).replaceAll("PLAYERNAME", this.field_22787.method_1548().method_1676());
            while ((i = ((String)string).indexOf(OBFUSCATION_PLACEHOLDER)) != -1) {
                String string2 = ((String)string).substring(0, i);
                String string3 = ((String)string).substring(i + OBFUSCATION_PLACEHOLDER.length());
                string = string2 + String.valueOf(class_124.field_1068) + String.valueOf(class_124.field_1051) + "XXXXXXXX".substring(0, random.method_43048(4) + 3) + string3;
            }
            this.addText((String)string);
            this.addEmptyLine();
        }
        for (i = 0; i < 8; ++i) {
            this.addEmptyLine();
        }
    }

    private void readCredits(Reader reader) {
        for (JsonElement jsonElement : class_3518.method_37165((Reader)reader)) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            String string = jsonObject.get("section").getAsString();
            this.addText(SEPARATOR_LINE, true);
            this.addText((class_2561)class_2561.method_43470((String)string).method_27692(class_124.field_1054), true);
            this.addText(SEPARATOR_LINE, true);
            this.addEmptyLine();
            for (JsonElement jsonElement2 : jsonObject.getAsJsonArray("disciplines")) {
                JsonObject jsonObject2 = jsonElement2.getAsJsonObject();
                String string2 = jsonObject2.get("discipline").getAsString();
                if (StringUtils.isNotEmpty((CharSequence)string2)) {
                    this.addText((class_2561)class_2561.method_43470((String)string2).method_27692(class_124.field_1054), true);
                    this.addEmptyLine();
                }
                for (JsonElement jsonElement3 : jsonObject2.getAsJsonArray("titles")) {
                    JsonObject jsonObject3 = jsonElement3.getAsJsonObject();
                    String string3 = jsonObject3.get("title").getAsString();
                    JsonArray jsonArray4 = jsonObject3.getAsJsonArray("names");
                    if (StringUtils.isNotEmpty((CharSequence)string3)) {
                        this.addText((class_2561)class_2561.method_43470((String)string3).method_27692(class_124.field_1080), false);
                    }
                    for (JsonElement jsonElement4 : jsonArray4) {
                        String string4 = jsonElement4.getAsString();
                        this.addText((class_2561)class_2561.method_43470((String)CENTERED_LINE_PREFIX).method_27693(string4).method_27692(class_124.field_1068), false);
                    }
                    this.addEmptyLine();
                }
            }
        }
    }

    private void addEmptyLine() {
        this.credits.add(class_5481.field_26385);
    }

    private void addText(String text) {
        this.credits.addAll(this.field_22787.field_1772.method_1728((class_5348)class_2561.method_43470((String)text), 256));
    }

    private void addText(class_2561 text, boolean centered) {
        if (centered) {
            this.centeredLines.add(this.credits.size());
        }
        this.credits.add(text.method_30937());
    }

    public void method_25420(class_332 context) {
        int i = this.field_22789;
        float f = this.time * 0.5f;
        int j = 64;
        float k = (float)(this.creditsHeight + this.field_22790 + this.field_22790 + 24) / this.baseSpeed;
        float g = this.time / this.baseSpeed;
        float l = (k - 20.0f - g) * 0.005f;
        float h = g * 0.02f;
        if (l < h) {
            h = l;
        }
        if (h > 1.0f) {
            h = 1.0f;
        }
        h *= h;
        h = h * 96.0f / 255.0f;
        context.method_51422(h, h, h, 1.0f);
        context.method_25291(field_44669, 0, 0, 0, 0.0f, f, i, this.field_22790, 64, 64);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.time = Math.max(0.0f, this.time + delta * this.speed);
        this.method_25420(context);
        int i = this.field_22789 / 2 - 128;
        int j = this.field_22790 + 50;
        float f = -this.time;
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, f, 0.0f);
        int k = j + 0;
        for (int l = 0; l < this.credits.size(); ++l) {
            float g;
            if (l == this.credits.size() - 1 && (g = (float)k + f - (float)(this.field_22790 / 2 - 6)) < 0.0f) {
                context.method_51448().method_46416(0.0f, -g, 0.0f);
            }
            if ((float)k + f + 12.0f + 8.0f > 0.0f && (float)k + f < (float)this.field_22790) {
                class_5481 orderedText = this.credits.get(l);
                if (this.centeredLines.contains(l)) {
                    context.method_35719(this.field_22793, orderedText, i + 128, k, 0xFFFFFF);
                } else {
                    context.method_35720(this.field_22793, orderedText, i, k, 0xFFFFFF);
                }
            }
            k += 12;
        }
        context.method_51448().method_22909();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR);
        context.method_25291(VIGNETTE_TEXTURE, 0, 0, 0, 0.0f, 0.0f, this.field_22789, this.field_22790, this.field_22789, this.field_22790);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25432() {
        this.field_22787.method_1538().method_50025(class_1143.field_5578);
    }

    public class_5195 method_50024() {
        return class_1143.field_5578;
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    static interface CreditsReader {
        public void read(Reader var1) throws IOException;
    }
}

