/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.client.GeomancyClient;
import org.oxytocina.geomancy.items.ISpellSelectorItem;
import org.oxytocina.geomancy.items.SpellStoringItem;
import org.oxytocina.geomancy.networking.packet.C2S.CasterChangeSelectedSpellC2S;
import org.oxytocina.geomancy.networking.packet.C2S.OpenStorageItemScreenC2SPacket;
import org.oxytocina.geomancy.spells.SpellGrid;
import org.oxytocina.geomancy.util.DrawHelper;
import org.oxytocina.geomancy.util.SimplexNoise;
import org.oxytocina.geomancy.util.Toolbox;

public class SpellSelectScreen
extends class_437 {
    public static final int bgWidth = 200;
    public static final int bgHeight = 200;
    public final class_1661 playerInventory;
    public int backgroundWidth;
    public int backgroundHeight;
    public int x;
    public int y;
    public final class_1799 parent;
    public final class_1799 initialParent;
    public final int parentSlot;
    public final class_1657 player;
    public final ISpellSelectorItem selector;
    public List<SlotInfo> slots;
    public List<SlotInfo> spellSlots;
    public SlotInfo focusedSlot;
    public static final int CENTER_POS_X = 100;
    public static final int CENTER_POS_Y = 100;
    public static final int[] DISTANCES_FROM_CENTER = new int[]{25, 50, 75, 100};
    public static final class_2960 SLOT_BG = Geomancy.locate("textures/gui/slot.png");

    public SpellSelectScreen(class_1657 player, class_1799 stack, int slot, class_2561 title) {
        super(title);
        this.playerInventory = player.method_31548();
        this.player = player;
        this.playerInventory.method_5435(this.player);
        this.parent = stack;
        this.selector = (ISpellSelectorItem)stack.method_7909();
        this.initialParent = this.parent.method_7972();
        this.parentSlot = slot;
        class_1799 storageStack = new class_1799((class_1935)class_1802.field_8106);
        this.slots = new ArrayList<SlotInfo>();
        this.spellSlots = new ArrayList<SlotInfo>();
        this.rebuildSlots();
    }

    void rebuildSlots() {
        this.slots.clear();
        this.spellSlots.clear();
        ArrayList<class_1799> installedSpells = this.selector.getCastableSpellItems(this.parent);
        for (int i = 0; i < installedSpells.size(); ++i) {
        }
        int[] ringCounts = new int[]{Math.min(2, installedSpells.size()), Math.min(8, installedSpells.size() - 2), Math.min(18, installedSpells.size() - 2 - 8), installedSpells.size() - 2 - 8 - 18};
        int j = 0;
        for (int ring = 0; ring < 4; ++ring) {
            for (int i = 0; i < ringCounts[ring]; ++i) {
                boolean selected;
                class_1799 container = installedSpells.get(j);
                SpellGrid grid = SpellStoringItem.readGrid(container);
                class_1799 display = grid.getDisplayStack(container);
                boolean bl = selected = j == this.selector.getSelectedSpellIndex(this.parent);
                if (selected) {
                    display.method_7978(class_1893.field_9119, 1);
                }
                ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
                tooltip.add((class_2561)grid.getName());
                float angle = (float)((double)((float)i / (float)ringCounts[ring] + 0.25f) * Math.PI * 2.0);
                Vector2f offset = Toolbox.rotateVector(new Vector2f((float)DISTANCES_FROM_CENTER[ring], 0.0f), angle);
                SlotInfo slot = new SlotInfo(this, 100.0f + offset.x, 100.0f + offset.y, display, grid, tooltip, selected);
                this.slots.add(slot);
                this.spellSlots.add(slot);
                ++j;
            }
        }
        SlotInfo slot = new SlotInfo(this, 100.0f, 100.0f, new class_1799((class_1935)class_1802.field_8106), null, List.of(class_2561.method_43471((String)"geomancy.spellstorage.open_storage")), false);
        this.slots.add(slot);
    }

    protected void method_25426() {
        this.backgroundWidth = 200;
        this.backgroundHeight = 200;
        super.method_25426();
        this.x = this.field_22789 / 2 - this.backgroundWidth / 2;
        this.y = this.field_22790 / 2 - this.backgroundHeight / 2;
        this.method_37067();
    }

    public void method_25393() {
        super.method_25393();
        if (this.parent.method_7909() != this.initialParent.method_7909() || this.parent.method_7947() != this.initialParent.method_7947()) {
            this.method_25419();
        }
        for (SlotInfo s : this.slots) {
            s.tick();
        }
    }

    public void method_16014(double mouseX, double mouseY) {
        this.recalculateFocusedSlot(mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.focusedSlot != null) {
            this.onSlotClicked(this.focusedSlot);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void recalculateFocusedSlot(double mouseX, double mouseY) {
        this.focusedSlot = null;
        float minDist = 100000.0f;
        for (int i = 0; i < this.slots.size(); ++i) {
            SlotInfo slot = this.slots.get(i);
            float dist = Vector2f.distance((float)((float)mouseX), (float)((float)mouseY), (float)slot.getDrawX(), (float)slot.getDrawY());
            if (!(dist < minDist)) continue;
            this.focusedSlot = slot;
            minDist = dist;
        }
        if (minDist > 150.0f) {
            this.focusedSlot = null;
        }
    }

    public void onSlotClicked(SlotInfo slot) {
        SpellGrid grid = slot.grid;
        if (grid != null) {
            int index = ((ISpellSelectorItem)this.parent.method_7909()).getSpellIndexOfSpell(this.parent, grid.name);
            CasterChangeSelectedSpellC2S.send(this.parent, this.parentSlot, index);
            this.method_25419();
        } else {
            OpenStorageItemScreenC2SPacket.send(this.parentSlot);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)SLOT_BG);
        int[] ringCountsFull = new int[]{2, 8, 18, this.spellSlots.size() - 2 - 8 - 18};
        int[] ringCounts = new int[]{Math.min(2, this.spellSlots.size()), Math.min(8, this.spellSlots.size() - 2), Math.min(18, this.spellSlots.size() - 2 - 8), this.spellSlots.size() - 2 - 8 - 18};
        for (int ring = 0; ring < 4 && ringCounts[ring] > 0; ++ring) {
            int segments = Math.max(32, ringCountsFull[ring] * 8);
            for (int i = 0; i < segments; ++i) {
                int j = (i + 1) % segments;
                float angle = (float)((double)((float)i / (float)segments + 0.25f) * Math.PI * 2.0);
                Vector2f offset1 = Toolbox.rotateVector(new Vector2f((float)DISTANCES_FROM_CENTER[ring], 0.0f), angle);
                angle = (float)((double)((float)j / (float)segments + 0.25f) * Math.PI * 2.0);
                Vector2f offset2 = Toolbox.rotateVector(new Vector2f((float)DISTANCES_FROM_CENTER[ring], 0.0f), angle);
                offset1.add((Vector2fc)this.getNoiseOffset(offset1).mul((float)(4 + ring * 2)));
                offset2.add((Vector2fc)this.getNoiseOffset(offset2).mul((float)(4 + ring * 2)));
                DrawHelper.drawLine(context, (float)(this.x + 100) + offset1.x, (float)(this.y + 100) + offset1.y, (float)(this.x + 100) + offset2.x, (float)(this.y + 100) + offset2.y, 1.0f, Toolbox.colorFromRGBA(0.6f, 0.8f, 0.8f, 1.0f));
            }
        }
        for (int i = 0; i < this.slots.size(); ++i) {
            SlotInfo slot = this.slots.get(i);
            this.drawSlot(context, slot);
        }
        if (this.focusedSlot != null) {
            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
            SpellGrid grid = this.focusedSlot.grid;
            if (grid != null) {
                tooltip.add(grid.getName());
            } else {
                tooltip.add(class_2561.method_43471((String)"geomancy.spellstorage.open_storage"));
            }
            context.method_51437(this.field_22793, tooltip, Optional.empty(), (int)this.focusedSlot.getDrawX(), (int)this.focusedSlot.getDrawY());
        }
    }

    private Vector2f getNoiseOffset(Vector2f where) {
        double scale = 0.02;
        double x = (double)where.x * 0.02;
        double y = (double)where.y * 0.02;
        double z = (float)GeomancyClient.tick / 20.0f / 3.0f;
        return new Vector2f(SimplexNoise.noiseNormalized(x, y, z) - 0.5f, SimplexNoise.noiseNormalized(x + (double)0.3f, y + (double)0.6f, z + (double)0.2f) - 0.5f);
    }

    private float getDrawY() {
        return this.y;
    }

    private float getDrawX() {
        return this.x;
    }

    public final void drawSlot(class_332 context, SlotInfo slot) {
        class_1799 itemStack = slot.displayStack;
        Object countOverride = null;
        float x = slot.getDrawX();
        float y = slot.getDrawY();
        class_4587.class_4665 posMatrix = context.method_51448().method_23760();
        Vector3f trans = new Vector3f();
        posMatrix.method_23761().getTranslation(trans);
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        context.method_51448().method_22905(slot.scale, slot.scale, 1.0f);
        Vector3f col = Toolbox.colorIntToVec(Toolbox.colorFromHSV(0.0f, 0.0f, slot.selected ? 0.5f : 1.0f));
        DrawHelper.drawItem(context, null, (class_1937)class_310.method_1551().field_1687, itemStack, (x /= slot.scale) - 8.0f, (y /= slot.scale) - 8.0f, (int)x + (int)y * this.backgroundWidth, 0.0f, col.x, col.y, col.z);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_51448().method_22909();
    }

    public static class SlotInfo {
        public SpellSelectScreen screen;
        public float x;
        public float y;
        public class_1799 displayStack;
        public SpellGrid grid;
        public List<class_2561> tooltip;
        public boolean selected;
        public float scale = 1.0f;

        public SlotInfo(SpellSelectScreen screen, float x, float y, class_1799 stack, SpellGrid grid, List<class_2561> tooltip, boolean selected) {
            this.screen = screen;
            this.x = x;
            this.y = y;
            this.displayStack = stack;
            this.grid = grid;
            this.tooltip = tooltip;
            this.selected = selected;
        }

        public float getDrawX() {
            return this.x + this.screen.getDrawX();
        }

        public float getDrawY() {
            return this.y + this.screen.getDrawY();
        }

        public void tick() {
            float desiredScale = this.focused() ? 2.0f : 1.0f;
            this.scale = class_3532.method_16439((float)0.3f, (float)this.scale, (float)desiredScale);
        }

        public boolean focused() {
            return this.screen.focusedSlot == this;
        }
    }
}

