/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_7842;
import net.minecraft.class_8021;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.client.screen.SpellSelectScreen;
import org.oxytocina.geomancy.client.screen.SpellmakerScreenHandler;
import org.oxytocina.geomancy.client.screen.widgets.SpellmakerButton;
import org.oxytocina.geomancy.client.screen.widgets.SpellmakerCheckbox;
import org.oxytocina.geomancy.client.screen.widgets.SpellmakerTextInput;
import org.oxytocina.geomancy.items.ModItems;
import org.oxytocina.geomancy.networking.ModMessages;
import org.oxytocina.geomancy.sound.ModSoundEvents;
import org.oxytocina.geomancy.spells.SpellBlock;
import org.oxytocina.geomancy.spells.SpellBlocks;
import org.oxytocina.geomancy.spells.SpellComponent;
import org.oxytocina.geomancy.util.TextUtil;
import org.oxytocina.geomancy.util.Toolbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpellmakerScreen
extends class_465<SpellmakerScreenHandler> {
    private static final class_2960 TEXTURE = new class_2960("geomancy", "textures/gui/spellmaker_block_gui.png");
    private static final Logger log = LoggerFactory.getLogger(SpellmakerScreen.class);
    private final SpellmakerScreenHandler handler;
    public static final int bgWidth = 176;
    public static final int bgHeight = 189;
    private boolean inspecting = false;
    private boolean placingNewComponent = false;
    public List<SpellmakerTextInput> textInputs;
    public SpellmakerButton[] sideConfigButtons = new SpellmakerButton[12];
    public List<class_8021> widgets = new ArrayList<class_8021>();
    public HashMap<class_8021, Integer> initialWidgetOffsets = new HashMap();
    public SpellmakerButton[] selectNewCompScrollBtns = new SpellmakerButton[2];
    public boolean moving;
    public static final HashMap<class_1799, String> hints = new LinkedHashMap<class_1799, String>();
    public Pair<class_1799, String> currentHint;
    public int desiredBgWidth;
    public float currentBgWidth;
    public int shiftHoldOver;

    public SpellmakerScreen(SpellmakerScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.moving = (Boolean)Geomancy.CONFIG.noSpellmakerMove.value() == false;
        this.currentHint = null;
        this.desiredBgWidth = 176;
        this.currentBgWidth = 176.0f;
        this.shiftHoldOver = 0;
        this.handler = handler;
        handler.screen = this;
        this.textInputs = new ArrayList<SpellmakerTextInput>();
    }

    protected void method_37432() {
        super.method_37432();
        this.handler.tick();
        for (SpellmakerTextInput t : this.textInputs) {
            t.method_1865();
        }
        this.tick2();
    }

    private void ensureTextEditFinish() {
        for (SpellmakerTextInput t : this.textInputs) {
            if (!t.method_25370()) continue;
            t.onEditFinished();
            t.method_25365(false);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || keyCode == 257) {
            for (SpellmakerTextInput t : this.textInputs) {
                if (!t.method_25370()) continue;
                this.ensureTextEditFinish();
                return true;
            }
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            for (SpellmakerTextInput t : this.textInputs) {
                if (!t.method_25370()) continue;
                t.method_25404(keyCode, scanCode, modifiers);
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_25426() {
        class_7842 tipWidget;
        int infoPosY;
        int infoPosX;
        int bgPosY;
        int bgPosX;
        this.ensureTextEditFinish();
        this.desiredBgWidth = 176 + (this.handler.hasGrid() || !this.moving ? 200 : 0);
        this.field_2792 = this.moving ? (int)this.currentBgWidth : this.desiredBgWidth;
        this.field_2779 = 189;
        super.method_25426();
        this.field_25268 = -1000;
        this.field_25270 = -1000;
        this.method_37067();
        this.widgets.clear();
        if (!this.placingNewComponent || this.handler.hasGrid()) {
            // empty if block
        }
        if (!this.placingNewComponent && !this.inspecting && this.handler.hasGrid()) {
            bgPosX = (this.field_22789 - this.getBackgroundWidth()) / 2;
            bgPosY = (this.field_22790 - this.getBackgroundHeight()) / 2;
            infoPosX = bgPosX + 176 + 10;
            infoPosY = bgPosY + 10 + 10;
            SpellmakerTextInput textInput = new SpellmakerTextInput(this, class_310.method_1551().field_1772, infoPosX, infoPosY, 100, 15, (class_2561)class_2561.method_43470((String)this.handler.currentGrid.name));
            textInput.method_1852(this.handler.currentGrid.name);
            textInput.method_1863(s -> {
                this.playUISound(textInput.prevText.length() < s.length() ? ModSoundEvents.SPELLMAKER_TYPE : ModSoundEvents.SPELLMAKER_TYPE_BACK);
                textInput.prevText = s;
            });
            textInput.onEditFinished = s -> {
                this.playUISound(ModSoundEvents.SPELLMAKER_TEXTFIELD_FINISHED);
                class_2540 data = PacketByteBufs.create();
                data.method_10807(this.handler.blockEntity.method_11016());
                data.method_10814(s);
                ClientPlayNetworking.send((class_2960)ModMessages.SPELLMAKER_TRY_CHANGE_GRIDNAME, (class_2540)data);
                textInput.validInput = true;
            };
            this.textInputs.add(textInput);
            this.method_37063((class_364)textInput);
            this.widgets.add((class_8021)textInput);
            SpellmakerCheckbox libCheckBox = new SpellmakerCheckbox(this, infoPosX, infoPosY + 20, 20, 20, (class_2561)class_2561.method_43471((String)"geomancy.spellmaker.grid.lib"), this.handler.currentGrid.library);
            libCheckBox.onPressed = () -> {
                class_2540 data = PacketByteBufs.create();
                data.method_10807(this.handler.blockEntity.method_11016());
                data.writeBoolean(libCheckBox.method_20372());
                ClientPlayNetworking.send((class_2960)ModMessages.SPELLMAKER_TRY_CHANGE_GRIDLIB, (class_2540)data);
                return true;
            };
            this.method_37063((class_364)libCheckBox);
            this.widgets.add((class_8021)libCheckBox);
        }
        if (!this.placingNewComponent && this.inspecting && this.handler.selectedComponent != null) {
            bgPosX = (this.field_22789 - this.getBackgroundWidth()) / 2;
            bgPosY = (this.field_22790 - this.getBackgroundHeight()) / 2;
            SpellComponent component = this.handler.selectedComponent;
            int infoPosX2 = bgPosX + 176 + 10;
            int infoPosY2 = bgPosY + 10;
            this.sideConfigButtons = new SpellmakerButton[12];
            for (int i = 0; i < component.sideConfigs.length; ++i) {
                SpellComponent.SideConfig conf = component.sideConfigs[i];
                int endX = infoPosX2 + 85;
                int endY = infoPosY2 + i * 15;
                String typeButtonText = switch (conf.activeMode()) {
                    default -> throw new IncompatibleClassChangeError();
                    case SpellComponent.SideConfig.Mode.Input -> "->";
                    case SpellComponent.SideConfig.Mode.Output -> "<-";
                    case SpellComponent.SideConfig.Mode.Blocked -> "x";
                };
                int sideIndex = i;
                int newMode = (conf.selectedMode + 1) % conf.modes.size();
                SpellmakerButton typeBtn = new SpellmakerButton(this, endX, endY, 0, 0, 20, 15, (class_2561)class_2561.method_43470((String)typeButtonText), button -> {
                    class_2540 data = PacketByteBufs.create();
                    class_2487 nbt = new class_2487();
                    component.writeNbt(nbt);
                    data.method_10794(nbt);
                    data.method_10807(this.handler.blockEntity.method_11016());
                    data.writeInt(sideIndex);
                    data.writeInt(newMode);
                    ClientPlayNetworking.send((class_2960)ModMessages.SPELLMAKER_TRY_CHANGE_TYPE, (class_2540)data);
                }, ModSoundEvents.SPELLMAKER_CHANGE_VAR, new class_2561[0]);
                typeBtn.field_22763 = conf.modes.size() > 1;
                this.method_37063((class_364)typeBtn);
                this.widgets.add((class_8021)typeBtn);
                this.sideConfigButtons[i * 2] = typeBtn;
                String nextVar = "";
                switch (conf.activeMode()) {
                    case Input: {
                        String first = null;
                        boolean nextIsRes = false;
                        for (String name : component.function.inputs.keySet()) {
                            if (nextIsRes) {
                                nextVar = name;
                                break;
                            }
                            if (first == null) {
                                first = name;
                            }
                            if (!Objects.equals(name, conf.varName)) continue;
                            nextIsRes = true;
                        }
                        if (nextVar != "") break;
                        nextVar = first != null ? first : "";
                        break;
                    }
                    case Output: {
                        String first = null;
                        boolean nextIsRes = false;
                        for (String name : component.function.outputs.keySet()) {
                            if (nextIsRes) {
                                nextVar = name;
                                break;
                            }
                            if (first == null) {
                                first = name;
                            }
                            if (!Objects.equals(name, conf.varName)) continue;
                            nextIsRes = true;
                        }
                        if (nextVar != "") break;
                        nextVar = first != null ? first : "";
                        break;
                    }
                }
                String nextVar2 = nextVar;
                SpellmakerButton varBtn = new SpellmakerButton(this, endX + 20, endY, 0, 0, 80, 15, (class_2561)class_2561.method_43471((String)("geomancy.spellmaker.types." + conf.getSignal((SpellComponent)component).type.toString().toLowerCase())).method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)(" " + conf.varName)).method_27692(class_124.field_1080)), button -> {
                    class_2540 data = PacketByteBufs.create();
                    class_2487 nbt = new class_2487();
                    component.writeNbt(nbt);
                    data.method_10794(nbt);
                    data.method_10807(this.handler.blockEntity.method_11016());
                    data.writeInt(sideIndex);
                    data.method_10814(nextVar2);
                    ClientPlayNetworking.send((class_2960)ModMessages.SPELLMAKER_TRY_CHANGE_VAR, (class_2540)data);
                }, ModSoundEvents.SPELLMAKER_CHANGE_VAR, new class_2561[0]);
                boolean bl = varBtn.field_22764 = conf.activeMode() != SpellComponent.SideConfig.Mode.Blocked;
                varBtn.field_22763 = conf.isInput() ? component.function.inputs.size() > 1 : conf.isOutput() && component.function.outputs.size() > 1;
                this.method_37063((class_364)varBtn);
                this.widgets.add((class_8021)varBtn);
                this.sideConfigButtons[i * 2 + 1] = varBtn;
            }
            this.textInputs.clear();
            List paramNames = component.function.parameters.keySet().stream().toList();
            if (!paramNames.isEmpty()) {
                int height = 0;
                block15: for (int i = 0; i < paramNames.size(); ++i) {
                    String paramName = (String)paramNames.get(i);
                    SpellBlock.Parameter param = component.function.parameters.get(paramName);
                    SpellComponent.ConfiguredParameter configuredParam = component.getParam(paramName);
                    int posX = infoPosX2 + 85;
                    int posY = infoPosY2 + 90 + height + 10 + 15 + 10;
                    switch (param.type) {
                        case ConstantBoolean: {
                            SpellmakerCheckbox checkbox = new SpellmakerCheckbox(this, posX, posY, 100, 20, (class_2561)class_2561.method_43470((String)param.name), configuredParam.getSignal().getBooleanValue());
                            checkbox.onPressed = () -> {
                                class_2540 data = PacketByteBufs.create();
                                class_2487 nbt = new class_2487();
                                component.writeNbt(nbt);
                                data.method_10794(nbt);
                                data.method_10807(this.handler.blockEntity.method_11016());
                                data.method_10814(paramName);
                                data.method_10814(checkbox.method_20372() ? "1" : "0");
                                ClientPlayNetworking.send((class_2960)ModMessages.SPELLMAKER_TRY_CHANGE_PARAM, (class_2540)data);
                                return true;
                            };
                            this.method_37063((class_364)checkbox);
                            height += 20;
                            continue block15;
                        }
                        default: {
                            SpellmakerTextInput textInput = new SpellmakerTextInput(this, class_310.method_1551().field_1772, posX, posY, 100, 15, (class_2561)class_2561.method_43470((String)param.name));
                            textInput.method_1852(configuredParam.getSignal().getTextValue());
                            textInput.method_1863(s -> {
                                textInput.validInput = configuredParam.canAccept((String)s);
                                this.playUISound(textInput.prevText.length() < s.length() ? ModSoundEvents.SPELLMAKER_TYPE : ModSoundEvents.SPELLMAKER_TYPE_BACK);
                                textInput.prevText = s;
                            });
                            textInput.onEditFinished = s -> {
                                if (configuredParam.canAccept((String)s)) {
                                    this.playUISound(ModSoundEvents.SPELLMAKER_TEXTFIELD_FINISHED);
                                    class_2540 data = PacketByteBufs.create();
                                    class_2487 nbt = new class_2487();
                                    component.writeNbt(nbt);
                                    data.method_10794(nbt);
                                    data.method_10807(this.handler.blockEntity.method_11016());
                                    data.method_10814(paramName);
                                    data.method_10814(s);
                                    ClientPlayNetworking.send((class_2960)ModMessages.SPELLMAKER_TRY_CHANGE_PARAM, (class_2540)data);
                                    textInput.validInput = true;
                                } else {
                                    textInput.validInput = false;
                                }
                            };
                            this.textInputs.add(textInput);
                            this.method_37063((class_364)textInput);
                            this.widgets.add((class_8021)textInput);
                            height += 25;
                        }
                    }
                }
            }
            SpellmakerButton removeBtn = new SpellmakerButton(this, infoPosX2, infoPosY2 + SpellmakerScreenHandler.previewHeight + 10, 0, 0, 35, 15, (class_2561)class_2561.method_43471((String)"geomancy.spellmaker.delete"), button -> {
                class_2540 data = PacketByteBufs.create();
                class_2487 nbt = new class_2487();
                component.writeNbt(nbt);
                data.method_10794(nbt);
                data.method_10807(this.handler.blockEntity.method_11016());
                ClientPlayNetworking.send((class_2960)ModMessages.SPELLMAKER_TRY_REMOVE_COMPONENT, (class_2540)data);
                this.handler.selectedComponentPosition = null;
                this.handler.selectedComponentChanged();
            }, ModSoundEvents.SPELLMAKER_REMOVE_COMPONENT, new class_2561[0]);
            this.method_37063((class_364)removeBtn);
            this.widgets.add((class_8021)removeBtn);
            Object rotateBtn = new SpellmakerButton(this, infoPosX2 + 35, infoPosY2 + SpellmakerScreenHandler.previewHeight + 10, 0, 0, 35, 15, (class_2561)class_2561.method_43471((String)"geomancy.spellmaker.rotate"), button -> {
                class_2540 data = PacketByteBufs.create();
                class_2487 nbt = new class_2487();
                component.writeNbt(nbt);
                data.method_10794(nbt);
                data.method_10807(this.handler.blockEntity.method_11016());
                data.writeInt(1);
                ClientPlayNetworking.send((class_2960)ModMessages.SPELLMAKER_TRY_ROTATE_COMPONENT, (class_2540)data);
            }, ModSoundEvents.SPELLMAKER_ROTATE, new class_2561[0]);
            this.method_37063((class_364)rotateBtn);
            this.widgets.add((class_8021)rotateBtn);
        }
        if (!this.handler.hasGrid() && !this.moving) {
            this.repickHint();
            bgPosX = (this.field_22789 - this.getBackgroundWidth()) / 2;
            bgPosY = (this.field_22790 - this.getBackgroundHeight()) / 2;
            infoPosX = bgPosX + 176 + 10;
            infoPosY = bgPosY + 10;
            tipWidget = new class_7842(infoPosX, infoPosY - 10, 150, 15, (class_2561)class_2561.method_43471((String)"geomancy.spellmaker.tip").method_27692(class_124.field_1062), class_310.method_1551().field_1772);
            this.method_37063((class_364)tipWidget);
            this.widgets.add((class_8021)tipWidget);
            class_7842 nameWidget = new class_7842(infoPosX, infoPosY, 150, 15, (class_2561)class_2561.method_43471((String)("geomancy.spellmaker.tip." + (String)this.currentHint.getSecond())), class_310.method_1551().field_1772);
            this.method_37063((class_364)nameWidget);
            this.widgets.add((class_8021)nameWidget);
            int i = 0;
            for (String t : TextUtil.wrapString(class_2561.method_43471((String)("geomancy.spellmaker.tip." + (String)this.currentHint.getSecond() + ".desc")).getString(), 150, class_310.method_1551().field_1772)) {
                class_7842 textWidget = new class_7842(infoPosX, infoPosY + 48 + 10 * i, 150, 10, (class_2561)class_2561.method_43470((String)t).method_27692(class_124.field_1080), class_310.method_1551().field_1772);
                this.method_37063((class_364)textWidget);
                this.widgets.add((class_8021)textWidget);
                ++i;
            }
        }
        if (!this.handler.hasGrid()) {
            bgPosX = (this.field_22789 - this.getBackgroundWidth()) / 2;
            bgPosY = (this.field_22790 - this.getBackgroundHeight()) / 2;
            int gridPosX = bgPosX + 8;
            int gridPosY = bgPosY + 8;
            tipWidget = new class_7842(gridPosX, gridPosY, 160, 112, (class_2561)class_2561.method_43471((String)"geomancy.spellmaker.insertiontip"), class_310.method_1551().field_1772);
            this.method_37063((class_364)tipWidget);
            this.widgets.add((class_8021)tipWidget);
        }
        bgPosX = (this.field_22789 - this.getBackgroundWidth()) / 2;
        bgPosY = (this.field_22790 - this.getBackgroundHeight()) / 2;
        int spellCompInvPosX = bgPosX + 8 + 126;
        int spellCompInvPosY = bgPosY + 124;
        int endX = spellCompInvPosX;
        for (int i = 0; i < 2; ++i) {
            int endY = spellCompInvPosY + i * 18;
            String btnText = i == 0 ? "/\\" : "\\/";
            int scroll = i == 0 ? -1 : 1;
            SpellmakerButton scrollBtn = new SpellmakerButton(this, endX, endY, 0, 0, 16, 16, (class_2561)class_2561.method_43470((String)btnText), button -> {
                this.handler.changeComponentViewScroll(scroll);
                this.refreshScrollButtons();
            }, ModSoundEvents.SPELLMAKER_ROTATE, new class_2561[0]);
            scrollBtn.field_22764 = this.handler.componentScrollVisible();
            scrollBtn.field_22763 = this.handler.componentScrollActive(i);
            this.method_37063((class_364)scrollBtn);
            this.widgets.add((class_8021)scrollBtn);
            this.selectNewCompScrollBtns[i] = scrollBtn;
        }
    }

    void tick2() {
        if (!this.moving) {
            return;
        }
        int prevW = (int)this.currentBgWidth;
        this.currentBgWidth = class_3532.method_16439((float)Toolbox.clampF(((Float)Geomancy.CONFIG.spellmakerUiSpeed.value()).floatValue(), 0.1f, 1.0f), (float)this.currentBgWidth, (float)this.desiredBgWidth);
        int newW = (int)this.currentBgWidth;
        if (newW != prevW) {
            int shift = newW - prevW;
            this.shiftHoldOver += shift;
            if (Math.abs(this.shiftHoldOver) > 1) {
                int widgetShift = this.shiftHoldOver / 2;
                this.shiftHoldOver -= widgetShift * 2;
                this.field_2792 = (int)this.currentBgWidth;
                super.method_25426();
                for (class_8021 w : this.widgets) {
                    w.method_46421(w.method_46426() - widgetShift);
                }
            }
        }
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        context.method_25302(TEXTURE, x, y, 0, 0, 176, 189);
        this.renderProgressArrow(context, x, y);
    }

    private void renderProgressArrow(class_332 context, int x, int y) {
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.handler.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.handler.mouseClicked(mouseX, mouseY, button);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.handler.mouseReleased(mouseX, mouseY, button);
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.handler.mouseScrolled(mouseX, mouseY, amount);
        return super.method_25401(mouseX, mouseY, amount);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        class_1799 cursorStack;
        this.method_25420(context);
        this.handler.appearanceSlot.setEnabled(!this.inspecting);
        super.method_25394(context, mouseX, mouseY, delta);
        class_1799 class_17992 = cursorStack = this.field_2782.method_7960() ? this.handler.method_34255() : this.field_2782;
        if (cursorStack.method_7960()) {
            RenderSystem.disableDepthTest();
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)this.field_2776, (float)this.field_2800, 0.0f);
            cursorStack = this.handler.getHeldNewComponentStack();
            String text = String.valueOf(class_124.field_1062) + "+";
            this.method_2382(context, cursorStack, mouseX - this.field_2776 - 8, mouseY - this.field_2800 - 8, text);
            context.method_51448().method_22909();
            RenderSystem.enableDepthTest();
        }
        if (this.currentHint != null && !this.handler.hasGrid() && !this.moving) {
            RenderSystem.disableDepthTest();
            int bgPosX = (this.field_22789 - this.getBackgroundWidth()) / 2;
            int bgPosY = (this.field_22790 - this.getBackgroundHeight()) / 2;
            int infoPosX = bgPosX + 176 + 10;
            int infoPosY = bgPosY + 10;
            class_1799 stack = (class_1799)this.currentHint.getFirst();
            this.method_2382(context, stack, infoPosX - 8 + 75, infoPosY + 15, null);
            RenderSystem.enableDepthTest();
        }
        if (this.handler.hasGrid() && !this.inspecting) {
            int infoPosX = this.field_2776 + 176 + 10;
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)SpellSelectScreen.SLOT_BG);
            context.method_25290(SpellSelectScreen.SLOT_BG, infoPosX, this.field_2800 + 70, 0.0f, 0.0f, 18, 18, 18, 18);
            if (this.field_2787 == this.handler.appearanceSlot) {
                SpellmakerScreen.method_33285((class_332)context, (int)(infoPosX + 1), (int)(this.field_2800 + 70 + 1), (int)0);
            }
        }
        this.handler.render(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    public void setComponentInspected(boolean inspected) {
        this.inspecting = inspected;
        this.method_25426();
    }

    public int getBackgroundWidth() {
        return this.field_2792;
    }

    public int getBackgroundHeight() {
        return this.field_2779;
    }

    public void playUISound(class_3414 event) {
        if (this.handler.blockEntity.method_10997() instanceof class_638) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)event, (float)1.0f));
        }
    }

    protected boolean sideConfigButtonHovered(int i) {
        return this.sideConfigButtons[i] != null && this.sideConfigButtons[i].method_49606();
    }

    public boolean hoveredOverSideConfig(int i) {
        return this.sideConfigButtonHovered(i * 2) || this.sideConfigButtonHovered(i * 2 + 1);
    }

    public boolean hoveredOverAnySideConfig() {
        for (int i = 0; i < 12; ++i) {
            if (!this.sideConfigButtonHovered(i)) continue;
            return true;
        }
        return false;
    }

    public void refreshScrollButtons() {
        for (int j = 0; j < 2; ++j) {
            this.selectNewCompScrollBtns[j].field_22763 = this.handler.componentScrollActive(j);
        }
    }

    public void setNewComponentSelected(boolean b) {
        this.placingNewComponent = b;
        this.method_25426();
    }

    public void repickHint() {
        List list = hints.keySet().stream().toList();
        class_1799 key = (class_1799)list.get(Toolbox.random.nextInt(list.size()));
        this.currentHint = new Pair((Object)key, (Object)hints.get(key));
    }

    static {
        hints.put(SpellBlocks.FUNCTION.copyItemStack(), "references");
        hints.put(SpellBlocks.SUM.copyItemStack(), "sum");
        hints.put(SpellBlocks.DIMHOP.copyItemStack(), "dimhop");
        hints.put(ModItems.CASTER_LEGGINGS.method_7854(), "casterleggings");
        hints.put(ModItems.CASTER_BOOTS.method_7854(), "casterboots");
        hints.put(ModItems.CASTER_HELMET.method_7854(), "casterhelmet");
        hints.put(ModItems.CASTER_CHESTPLATE.method_7854(), "casterchestplate");
        hints.put(SpellBlocks.DEGRADE_BLOCK.copyItemStack(), "degrading");
        hints.put(SpellBlocks.ENTITIES_NEAR.copyItemStack(), "nearbyentities");
        hints.put(SpellBlocks.DEBUG.copyItemStack(), "debugging");
        hints.put(SpellBlocks.ACTIVATE.copyItemStack(), "activate");
        hints.put(ModItems.VARSTORAGE_SMALL.method_7854(), "varpots");
        hints.put(ModItems.VARSTORAGE_LARGE.method_7854(), "varpots2");
        hints.put(class_1802.field_20391.method_7854(), "rockandstone");
    }
}

