/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.client.screen.ModScreenHandlers;
import org.oxytocina.geomancy.client.screen.StorageItemScreen;
import org.oxytocina.geomancy.client.screen.slots.StorageItemContainedSlot;
import org.oxytocina.geomancy.items.IStorageItem;
import org.oxytocina.geomancy.networking.ModMessages;
import org.oxytocina.geomancy.util.Toolbox;

public class StorageItemScreenHandler
extends class_1703 {
    public static StorageItemScreenHandler current;
    private final class_1263 containedItems;
    public final int rows;
    public List<StorageItemContainedSlot> containedItemSlots;
    private final class_3913 propertyDelegate;
    public final class_1799 parent;
    public final class_1799 initialParent;
    public final int parentSlot;
    public final class_1657 player;
    public final class_6862<class_1792> storableKey;
    private boolean dirty = false;
    private boolean initialized = false;
    public static final int STORAGE_DISPLAY_SLOTS_WIDTH = 9;
    public static final int STORAGE_DISPLAY_X = 8;
    public static final int STORAGE_DISPLAY_Y = 18;
    public static final int INVENTORY_DISPLAY_X = 8;
    public static final int INVENTORY_DISPLAY_Y = 8;
    public static final int HOTBAR_DISPLAY_Y = 144;
    public StorageItemScreen screen;
    public class_1799 currentOutput;
    public static final class_2960 spellstorerGuiTexture;

    public StorageItemScreenHandler(int syncID, class_1661 inventory, class_2540 buf) {
        this(syncID, inventory, inventory.method_5438(buf.readInt()), (class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)buf.method_10810()), (class_3913)new class_3919(3));
    }

    public StorageItemScreenHandler(int syncID, class_1661 playerInventory, class_1799 parent, class_6862<class_1792> storableKey, class_3913 arrayPropertyDelegate) {
        super(ModScreenHandlers.STORAGE_ITEM_SCREEN_HANDLER, syncID);
        current = this;
        this.player = playerInventory.field_7546;
        playerInventory.method_5435(this.player);
        this.propertyDelegate = arrayPropertyDelegate;
        this.parent = parent;
        this.initialParent = parent.method_7972();
        this.parentSlot = playerInventory.method_7395(parent);
        this.storableKey = storableKey;
        this.containedItems = ((IStorageItem)parent.method_7909()).getInventory(parent);
        this.rows = Math.round((float)Math.ceil((float)this.containedItems.method_5439() / 9.0f));
        this.addPlayerHotbar(playerInventory);
        this.addPlayerInventory(playerInventory);
        this.method_17360(arrayPropertyDelegate);
        this.outputItemChanged();
        this.currentOutput = this.getOutput();
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 spe = (class_3222)class_16572;
            class_1792 class_17922 = parent.method_7909();
            if (class_17922 instanceof IStorageItem) {
                IStorageItem storer = (IStorageItem)class_17922;
                Toolbox.playSound(storer.getOpenSound(), spe.method_37908(), spe.method_24515(), class_3419.field_15248, 0.5f, Toolbox.randomPitch());
            }
        }
    }

    public class_1263 getInventory() {
        return this.containedItems;
    }

    public void outputItemChanged() {
        this.rebuildSlots();
    }

    public void rebuildSlots() {
        if (this.containedItemSlots == null) {
            this.containedItemSlots = this.addInventory(this.containedItems, 0, this.containedItems.method_5439(), 9, 8, 18);
        }
    }

    public void method_34254(class_1799 stack) {
        super.method_34254(stack);
    }

    public class_1799 getOutput() {
        return this.parent;
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot2 = (class_1735)this.field_7761.get(invSlot);
        if (slot2 != null && slot2.method_7681()) {
            class_1799 itemStack2 = slot2.method_7677();
            itemStack = itemStack2.method_7972();
            if (invSlot < 36 ? !this.method_7616(itemStack2, 36, this.field_7761.size(), true) : !this.method_7616(itemStack2, 0, 36, false)) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot2.method_48931(class_1799.field_8037);
            } else {
                slot2.method_7668();
            }
        }
        return itemStack;
    }

    public boolean method_7597(class_1657 player) {
        return this.getInventory().method_5443(player);
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.method_7621(new class_1735((class_1263)playerInventory, l + i * 9 + 9, 8 + l * 18, this.getInventoryOffsetY() + i * 18));
            }
        }
    }

    public int getInventoryOffsetY() {
        return this.getScreenHeight() - 82;
    }

    public int getScreenHeight() {
        return 8 + this.rows * 18 + 20 + 14 + 76;
    }

    private void addPlayerHotbar(class_1661 playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, this.getInventoryOffsetY() + 54 + 4));
        }
    }

    private List<StorageItemContainedSlot> addInventory(class_1263 inventory, int slotIndexOffset, int count, int width, int x, int y) {
        ArrayList<StorageItemContainedSlot> res = new ArrayList<StorageItemContainedSlot>();
        for (int i = 0; i < count; ++i) {
            if (i >= inventory.method_5439()) {
                return res;
            }
            res.add((StorageItemContainedSlot)this.method_7621(new StorageItemContainedSlot(inventory, slotIndexOffset + i, x + i % width * 18, y + i / width * 18, this, this.storableKey)));
        }
        return res;
    }

    public void tick() {
        if (this.parent.method_7909() != this.initialParent.method_7909() || this.parent.method_7947() != this.initialParent.method_7947()) {
            this.screen.method_25419();
        }
        if (this.dirty) {
            this.writeInventory();
            this.dirty = false;
        }
        this.initialized = true;
    }

    public void method_7595(class_1657 player) {
        if (this.dirty) {
            this.writeInventory();
            this.dirty = false;
        }
        if (player instanceof class_3222) {
            class_3222 spe = (class_3222)player;
            class_1792 class_17922 = this.parent.method_7909();
            if (class_17922 instanceof IStorageItem) {
                IStorageItem storer = (IStorageItem)class_17922;
                Toolbox.playSound(storer.getCloseSound(), spe.method_37908(), spe.method_24515(), class_3419.field_15248, 0.5f, Toolbox.randomPitch());
            }
        }
        super.method_7595(player);
    }

    public void markDirty() {
        if (!this.initialized) {
            return;
        }
        this.dirty = true;
    }

    public void writeInventory() {
        class_1792 class_17922;
        if (class_310.method_1551() == null) {
            return;
        }
        class_1799 output = this.getOutput();
        if (output == null || output.method_7960() || !((class_17922 = output.method_7909()) instanceof IStorageItem)) {
            return;
        }
        IStorageItem storage = (IStorageItem)class_17922;
        for (int i = 0; i < this.containedItems.method_5439() && i < storage.getStorageSize(output); ++i) {
            storage.setStack(output, i, this.containedItems.method_5438(i));
        }
        class_2540 data = PacketByteBufs.create();
        class_2487 nbt = output.method_7969();
        data.writeInt(this.parentSlot);
        data.method_10794(nbt);
        ClientPlayNetworking.send((class_2960)ModMessages.STORAGE_ITEM_TRY_UPDATE, (class_2540)data);
    }

    public static void checkPanicClose(class_3222 spe, class_1799 storage) {
        class_1703 class_17032 = spe.field_7512;
        if (class_17032 instanceof StorageItemScreenHandler) {
            StorageItemScreenHandler sish = (StorageItemScreenHandler)class_17032;
            if (sish.parent == storage) {
                spe.method_7346();
            }
        }
    }

    static {
        spellstorerGuiTexture = Geomancy.locate("textures/gui/spellstorer_block_gui.png");
    }
}

