/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.compat;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import org.oxytocina.geomancy.compat.modonomicon.ModonomiconCompat;

public class GeomancyIntegrationPacks {
    protected static final Map<String, ModIntegrationPack> INTEGRATION_PACKS = new HashMap<String, ModIntegrationPack>();
    public static final String CONNECTOR_ID = "connectormod";
    public static final String AE2_ID = "ae2";
    public static final String GOBBER_ID = "gobber2";
    public static final String ALLOY_FORGERY_ID = "alloy_forgery";
    public static final String TRAVELERS_BACKPACK_ID = "travelersbackpack";
    public static final String BOTANIA_ID = "botania";
    public static final String MODONOMICON_ID = "modonomicon";
    public static final String CREATE_ID = "create";
    public static final String FARMERSDELIGHT_ID = "farmersdelight";
    public static final String NEEPMEAT_ID = "neepmeat";
    public static final String MALUM_ID = "malum";
    public static final String EXCLUSIONS_LIB_ID = "exclusions_lib";

    protected static void registerIntegrationPack(String modId, Supplier<ModIntegrationPack> container) {
        if (FabricLoader.getInstance().isModLoaded(modId)) {
            INTEGRATION_PACKS.put(modId, container.get());
        }
    }

    public static void register() {
        GeomancyIntegrationPacks.registerIntegrationPack(MODONOMICON_ID, () -> new ModonomiconCompat());
        if (!FabricLoader.getInstance().isModLoaded(CONNECTOR_ID)) {
            // empty if block
        }
        for (ModIntegrationPack container : INTEGRATION_PACKS.values()) {
            container.register();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClient() {
        for (ModIntegrationPack container : INTEGRATION_PACKS.values()) {
            container.registerClient();
        }
    }

    public static boolean isIntegrationPackActive(String modId) {
        return INTEGRATION_PACKS.containsKey(modId);
    }

    public static boolean isCreative() {
        if (class_310.method_1551() != null && class_310.method_1551().field_1724 != null) {
            return class_310.method_1551().field_1724.method_7337();
        }
        return false;
    }

    public static abstract class ModIntegrationPack {
        public abstract void register();

        public abstract void registerClient();
    }
}

