/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.compat.emi;

import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_3956;
import org.oxytocina.geomancy.blocks.ModBlocks;
import org.oxytocina.geomancy.client.screen.ModScreenHandlers;
import org.oxytocina.geomancy.compat.emi.ModEMIRecipeCategories;
import org.oxytocina.geomancy.compat.emi.handlers.SmitheryRecipeHandler;
import org.oxytocina.geomancy.compat.emi.handlers.SoulForgeRecipeHandler;
import org.oxytocina.geomancy.compat.emi.recipes.GeodeEMIRecipe;
import org.oxytocina.geomancy.compat.emi.recipes.SmitheryEMIRecipe;
import org.oxytocina.geomancy.compat.emi.recipes.SoulForgeEMIRecipe;
import org.oxytocina.geomancy.registries.ModRecipeTypes;

public class ModEMIPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        this.registerCategories(registry);
        this.registerRecipes(registry);
        this.registerRecipeHandlers(registry);
    }

    public void registerCategories(EmiRegistry registry) {
        registry.addCategory(ModEMIRecipeCategories.SMITHING);
        registry.addWorkstation(ModEMIRecipeCategories.SMITHING, (EmiIngredient)EmiStack.of((class_1935)ModBlocks.SMITHERY));
        registry.addCategory(ModEMIRecipeCategories.SOUL_FORGE);
        registry.addWorkstation(ModEMIRecipeCategories.SOUL_FORGE, (EmiIngredient)EmiStack.of((class_1935)ModBlocks.SOUL_FORGE));
        registry.addCategory(ModEMIRecipeCategories.GEODE);
        registry.addWorkstation(ModEMIRecipeCategories.GEODE, (EmiIngredient)EmiStack.of((class_1935)ModBlocks.SMITHERY));
    }

    public void registerRecipes(EmiRegistry registry) {
        this.addAll(registry, ModRecipeTypes.SMITHING, SmitheryEMIRecipe::new);
        this.addAll(registry, ModRecipeTypes.GEODE, GeodeEMIRecipe::new);
        this.addAll(registry, ModRecipeTypes.SOULFORGE_SIMPLE, SoulForgeEMIRecipe::new);
    }

    public void registerRecipeHandlers(EmiRegistry registry) {
        registry.addRecipeHandler(ModScreenHandlers.SMITHERY_SCREEN_HANDLER, (EmiRecipeHandler)new SmitheryRecipeHandler());
        registry.addRecipeHandler(ModScreenHandlers.SOULFORGE_SCREEN_HANDLER, (EmiRecipeHandler)new SoulForgeRecipeHandler());
    }

    public <C extends class_1263, T extends class_1860<C>> void addAll(EmiRegistry registry, class_3956<T> type, Function<T, EmiRecipe> constructor) {
        for (class_1860 recipe : registry.getRecipeManager().method_30027(type)) {
            registry.addRecipe(constructor.apply(recipe));
        }
    }
}

