/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.compat.emi.recipes;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.compat.emi.GatedModEMIRecipe;
import org.oxytocina.geomancy.compat.emi.ModEMIRecipeCategories;
import org.oxytocina.geomancy.recipe.smithery.SmitheryRecipe;
import org.oxytocina.geomancy.recipe.smithery.SmithingIngredient;

public class SmitheryEMIRecipe
extends GatedModEMIRecipe<SmitheryRecipe> {
    public static final class_2960 TEXTURE = Geomancy.locate("textures/gui/smithery_block_gui_rei.png");
    public static final int WIDTH = 176;
    public static final int HEIGHT = 80;

    public SmitheryEMIRecipe(SmitheryRecipe recipe) {
        super(ModEMIRecipeCategories.SMITHING, recipe, 176, 80);
        this.inputs = SmitheryEMIRecipe.getIngredients(recipe);
    }

    @Override
    public boolean isUnlocked() {
        return super.isUnlocked();
    }

    private static List<EmiIngredient> getIngredients(SmitheryRecipe recipe) {
        if (recipe == null) {
            return Collections.emptyList();
        }
        ArrayList<EmiIngredient> list = new ArrayList<EmiIngredient>();
        class_2371<SmithingIngredient> ingredients = recipe.getSmithingIngredients();
        if (recipe.isShapeless()) {
            for (SmithingIngredient ing : ingredients) {
                list.add(EmiIngredient.of((class_1856)ing.ingredient));
            }
        } else {
            block1: for (int i = 0; i < 9; ++i) {
                for (SmithingIngredient ing : ingredients) {
                    if (ing.slot != i) continue;
                    list.add(EmiIngredient.of((class_1856)ing.ingredient));
                    continue block1;
                }
                list.add(EmiIngredient.of((class_1856)class_1856.field_9017));
            }
        }
        return list;
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgets) {
        class_2960 backgroundTexture = TEXTURE;
        int x = 15;
        int y = 15;
        if (((SmitheryRecipe)this.recipe).isShapeless()) {
            widgets.addTexture(EmiTexture.SHAPELESS, 94, 0);
            for (int i = 0; i < this.inputs.size(); ++i) {
                widgets.addSlot((EmiIngredient)this.inputs.get(i), 15 + i % 3 * 18, 15 + i / 3 * 18).drawBack(true);
            }
        } else {
            for (int i = 0; i < this.inputs.size(); ++i) {
                widgets.addSlot((EmiIngredient)this.inputs.get(i), 15 + i % 3 * 18, 15 + i / 3 * 18).drawBack(true);
            }
        }
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 143, 29).large(true).drawBack(true).recipeContext((EmiRecipe)this);
        widgets.addTexture(TEXTURE, 84, 25, 35, 32, 87, 30);
    }
}

