/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.compat.emi.recipes;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.compat.emi.GatedModEMIRecipe;
import org.oxytocina.geomancy.compat.emi.ModEMIRecipeCategories;
import org.oxytocina.geomancy.items.ModItems;
import org.oxytocina.geomancy.recipe.NbtIngredient;
import org.oxytocina.geomancy.recipe.soulforge.SoulForgeRecipe;

public class SoulForgeEMIRecipe
extends GatedModEMIRecipe<SoulForgeRecipe> {
    public static final class_2960 TEXTURE = Geomancy.locate("textures/gui/soulforge_gui_rei.png");
    public static final int WIDTH = 176;
    public static final int HEIGHT = 80;

    public SoulForgeEMIRecipe(SoulForgeRecipe recipe) {
        super(ModEMIRecipeCategories.SOUL_FORGE, recipe, 176, 80);
        this.inputs = SoulForgeEMIRecipe.getIngredients(recipe);
    }

    @Override
    public boolean isUnlocked() {
        return super.isUnlocked();
    }

    private static List<EmiIngredient> getIngredients(SoulForgeRecipe recipe) {
        if (recipe == null) {
            return Collections.emptyList();
        }
        ArrayList<EmiIngredient> list = new ArrayList<EmiIngredient>();
        List<NbtIngredient> ingredients = recipe.getNbtIngredients(null);
        class_1799 soulStack = ModItems.SOUL_PREVIEW.getRequirementStack(recipe.getCost());
        list.add(EmiIngredient.of((class_1856)class_1856.method_8101((class_1799[])new class_1799[]{soulStack})));
        if (recipe.isShapeless()) {
            for (NbtIngredient ing : ingredients) {
                list.add((EmiIngredient)ItemEmiStack.of((class_1799)ing.getStack()));
            }
        } else {
            block1: for (int i = 0; i < 9; ++i) {
                for (NbtIngredient ing : ingredients) {
                    if (ing.slot != i) continue;
                    list.add((EmiIngredient)ItemEmiStack.of((class_1799)ing.getStack()));
                    continue block1;
                }
                list.add((EmiIngredient)ItemEmiStack.EMPTY);
            }
        }
        return list;
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgets) {
        class_2960 backgroundTexture = TEXTURE;
        int x = 15;
        int y = 15;
        if (((SoulForgeRecipe)this.recipe).isShapeless()) {
            widgets.addTexture(EmiTexture.SHAPELESS, 94, 0);
            for (int i = 0; i < this.inputs.size(); ++i) {
                widgets.addSlot((EmiIngredient)this.inputs.get(i), 15 + i % 3 * 18, 15 + i / 3 * 18).drawBack(true);
            }
        } else {
            for (int i = 0; i < this.inputs.size(); ++i) {
                widgets.addSlot((EmiIngredient)this.inputs.get(i), 15 + i % 3 * 18, 15 + i / 3 * 18).drawBack(true);
            }
        }
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 143, 29).large(true).drawBack(true).recipeContext((EmiRecipe)this);
        widgets.addTexture(TEXTURE, 84, 25, 35, 32, 87, 30);
    }
}

