/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.entity;

import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.entity.StateSaverAndLoader;
import org.oxytocina.geomancy.items.ISoulStoringItem;
import org.oxytocina.geomancy.util.SoulUtil;

public class SoulStoringItemData {
    public static final HashMap<UUID, class_1799> stackMap = new HashMap();
    public static final HashMap<UUID, SoulStoringItemData> clientMap = new HashMap();
    public float mana = 0.0f;
    public float maxMana = 0.0f;
    public float speedMultiplier = 1.0f;
    public UUID uuid = null;

    public SoulStoringItemData() {
    }

    public SoulStoringItemData(float mana, float maxMana, float speedMultiplier) {
        this.mana = mana;
        this.maxMana = maxMana;
        this.speedMultiplier = speedMultiplier;
    }

    public SoulStoringItemData(UUID uuid) {
        this.uuid = uuid;
    }

    public SoulStoringItemData(UUID uuid, class_1799 base) {
        this.uuid = uuid;
        this.mana = ((ISoulStoringItem)base.method_7909()).getInitialMana(base);
        this.maxMana = ((ISoulStoringItem)base.method_7909()).getBaseSoulCapacity(base);
    }

    public static SoulStoringItemData fromNbt(class_2487 nbt) {
        SoulStoringItemData res = new SoulStoringItemData();
        res.uuid = nbt.method_25926("uuid");
        res.mana = nbt.method_10583("mana");
        if (Float.isNaN(res.mana)) {
            Geomancy.logError("mana item data had NaN as mana!");
            res.mana = 0.0f;
        }
        res.maxMana = nbt.method_10583("maxMana");
        res.speedMultiplier = nbt.method_10583("speedMultiplier");
        return res;
    }

    public static SoulStoringItemData fromBuf(class_2540 buf) {
        SoulStoringItemData res = new SoulStoringItemData();
        res.uuid = buf.method_10790();
        res.mana = buf.readFloat();
        res.maxMana = buf.readFloat();
        res.speedMultiplier = buf.readFloat();
        return res;
    }

    public static UUID getNextUUID() {
        return UUID.randomUUID();
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_25927("uuid", this.uuid);
        nbt.method_10548("mana", this.mana);
        nbt.method_10548("maxMana", this.maxMana);
        nbt.method_10548("speedMultiplier", this.speedMultiplier);
    }

    public void writeBuf(class_2540 buf) {
        buf.method_10797(this.uuid);
        buf.writeFloat(this.mana);
        buf.writeFloat(this.maxMana);
        buf.writeFloat(this.speedMultiplier);
    }

    public static SoulStoringItemData from(class_1937 world, class_1799 stack, UUID uuid) {
        if (world.field_9236) {
            if (clientMap.containsKey(uuid)) {
                return clientMap.get(uuid);
            }
            return new SoulStoringItemData(0.0f, 0.0f, 0.0f);
        }
        if (stackMap.containsKey(uuid) && stackMap.get(uuid) != stack) {
            SoulStoringItemData newData = StateSaverAndLoader.getManaStoringItemData(world, uuid, stack).clone();
            newData.uuid = UUID.randomUUID();
            ISoulStoringItem.setUUID(stack, newData.uuid);
            stackMap.put(newData.uuid, stack);
            uuid = newData.uuid;
            StateSaverAndLoader.setManaStoringItemData(world, uuid, newData);
            SoulUtil.syncItemSoul(world, stack);
            return newData;
        }
        if (!stackMap.containsKey(uuid)) {
            stackMap.put(uuid, stack);
        }
        return StateSaverAndLoader.getManaStoringItemData(world, uuid, stack);
    }

    public SoulStoringItemData clone() {
        return new SoulStoringItemData(this.mana, this.maxMana, this.speedMultiplier);
    }

    @Environment(value=EnvType.CLIENT)
    public static void setFromBuffer(class_2540 buf) {
        SoulStoringItemData newData = SoulStoringItemData.fromBuf(buf);
        if (!clientMap.containsKey(newData.uuid)) {
            clientMap.put(newData.uuid, newData);
        }
        SoulStoringItemData.clientMap.get((Object)newData.uuid).mana = newData.mana;
        SoulStoringItemData.clientMap.get((Object)newData.uuid).maxMana = newData.maxMana;
        SoulStoringItemData.clientMap.get((Object)newData.uuid).speedMultiplier = newData.speedMultiplier;
    }
}

