/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.entity;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.oxytocina.geomancy.entity.PlayerData;
import org.oxytocina.geomancy.entity.SoulStoringItemData;

public class StateSaverAndLoader
extends class_18 {
    public HashMap<UUID, PlayerData> players = new HashMap();
    public HashMap<UUID, SoulStoringItemData> manaStoringItemData = new HashMap();

    public class_2487 method_75(class_2487 nbt) {
        class_2487 playersNbt = new class_2487();
        this.players.forEach((uuid, playerData) -> {
            class_2487 playerNbt = new class_2487();
            playerData.writeNbt(playerNbt);
            playersNbt.method_10566(uuid.toString(), (class_2520)playerNbt);
        });
        nbt.method_10566("players", (class_2520)playersNbt);
        class_2487 manaStoringItemDataNbt = new class_2487();
        this.manaStoringItemData.forEach((uuid, data) -> {
            if (data.mana <= 0.0f) {
                return;
            }
            class_2487 manaDataNbt = new class_2487();
            data.writeNbt(manaDataNbt);
            manaStoringItemDataNbt.method_10566(uuid.toString(), (class_2520)manaDataNbt);
        });
        nbt.method_10566("manaStoringItemData", (class_2520)manaStoringItemDataNbt);
        return nbt;
    }

    public static StateSaverAndLoader createFromNbt(class_2487 tag) {
        StateSaverAndLoader state = new StateSaverAndLoader();
        class_2487 playersNbt = tag.method_10562("players");
        playersNbt.method_10541().forEach(key -> {
            PlayerData playerData = PlayerData.fromNbt(playersNbt.method_10562(key));
            UUID uuid = UUID.fromString(key);
            state.players.put(uuid, playerData);
        });
        class_2487 manaStoringItemDataNbt = tag.method_10562("manaStoringItemData");
        manaStoringItemDataNbt.method_10541().forEach(key -> {
            SoulStoringItemData data = SoulStoringItemData.fromNbt(manaStoringItemDataNbt.method_10562(key));
            UUID uuid = UUID.fromString(key);
            state.manaStoringItemData.put(uuid, data);
        });
        return state;
    }

    public static StateSaverAndLoader createNew() {
        StateSaverAndLoader state = new StateSaverAndLoader();
        state.players = new HashMap();
        state.manaStoringItemData = new HashMap();
        return state;
    }

    public static StateSaverAndLoader getServerState(class_1937 world) {
        if (!(world instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)world;
        class_26 persistentStateManager = serverWorld.method_8503().method_30002().method_17983();
        StateSaverAndLoader state = (StateSaverAndLoader)persistentStateManager.method_17924(StateSaverAndLoader::createFromNbt, StateSaverAndLoader::createNew, "geomancy");
        state.method_80();
        return state;
    }

    public static PlayerData getPlayerState(class_1309 player) {
        if (!(player instanceof class_3222)) {
            return PlayerData.getOrCreate(player.method_5667());
        }
        StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(player.method_37908());
        PlayerData playerState = serverState.players.computeIfAbsent(player.method_5667(), uuid -> new PlayerData());
        return playerState;
    }

    public static SoulStoringItemData getManaStoringItemData(class_1937 world, UUID uuid, class_1799 stack) {
        if (!(world instanceof class_3218)) {
            return new SoulStoringItemData(uuid);
        }
        class_3218 serverWorld = (class_3218)world;
        StateSaverAndLoader serverState = StateSaverAndLoader.getServerState((class_1937)serverWorld);
        SoulStoringItemData state = serverState.manaStoringItemData.computeIfAbsent(uuid, uuid1 -> new SoulStoringItemData((UUID)uuid1, stack));
        return state;
    }

    public static void setManaStoringItemData(class_1937 world, UUID uuid, SoulStoringItemData data) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        StateSaverAndLoader serverState = StateSaverAndLoader.getServerState((class_1937)serverWorld);
        serverState.manaStoringItemData.put(uuid, data);
    }
}

