/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import net.minecraft.class_746;
import org.oxytocina.geomancy.items.SpellStoringItem;
import org.oxytocina.geomancy.items.tools.IVariableStoringItem;
import org.oxytocina.geomancy.items.tools.StorageItem;
import org.oxytocina.geomancy.spells.SpellGrid;

public interface ISpellSelectorItem {
    default public boolean setSelectedSpell(class_1799 stack, String spellName) {
        int index = this.getSpellIndexOfSpell(stack, spellName);
        if (index == -1) {
            return false;
        }
        this.setSelectedSpellIndex(stack, index);
        return true;
    }

    default public int getSpellIndexOfSpell(class_1799 stack, String spellName) {
        ArrayList<class_1799> selectable = this.getCastableSpellItems(stack);
        for (int i = 0; i < selectable.size(); ++i) {
            SpellGrid spell = SpellStoringItem.readGrid(selectable.get(i));
            if (spell == null || !Objects.equals(spell.name, spellName)) continue;
            this.setSelectedSpellIndex(stack, i);
            return i;
        }
        return -1;
    }

    default public ArrayList<class_1799> getSpellItems(class_1799 stack, Function<SpellGrid, Boolean> predicate) {
        if (!(stack.method_7909() instanceof ISpellSelectorItem)) {
            return null;
        }
        ArrayList<class_1799> res = new ArrayList<class_1799>();
        for (int i = 0; i < this.getStorageSize(stack); ++i) {
            SpellGrid grid;
            class_1799 spell = this.getStack(stack, i);
            if (!(spell.method_7909() instanceof SpellStoringItem) || (grid = SpellStoringItem.readGrid(spell)) == null || !predicate.apply(grid).booleanValue()) continue;
            res.add(spell);
        }
        return res;
    }

    default public ArrayList<class_1799> getCastableSpellItems(class_1799 stack) {
        return this.getSpellItems(stack, g -> !g.library);
    }

    public class_1799 getStack(class_1799 var1, int var2);

    public int getStorageSize(class_1799 var1);

    default public int getSelectedSpellIndex(class_1799 stack) {
        if (!stack.method_7948().method_10573("selected", 3)) {
            return 0;
        }
        int res = stack.method_7969().method_10550("selected");
        int installed = this.getInstalledSpellsCount(stack);
        if (installed <= 0) {
            return 0;
        }
        res = (res % installed + installed) % installed;
        return res;
    }

    default public void setSelectedSpellIndex(class_1799 stack, int index) {
        int installed = this.getInstalledSpellsCount(stack);
        index = installed <= 0 ? 0 : (index % installed + installed) % installed;
        stack.method_7948().method_10569("selected", index);
    }

    default public int getInstalledSpellsCount(class_1799 stack) {
        return this.getCastableSpellItems(stack).size();
    }

    default public SpellGrid getSpell(class_1799 casterItem, String name) {
        class_1792 class_17922;
        if (casterItem == null || !((class_17922 = casterItem.method_7909()) instanceof ISpellSelectorItem)) {
            return null;
        }
        ISpellSelectorItem caster = (ISpellSelectorItem)class_17922;
        for (int i = 0; i < caster.getStorageSize(casterItem); ++i) {
            class_1799 contender = caster.getStack(casterItem, i);
            class_1792 class_17923 = contender.method_7909();
            if (!(class_17923 instanceof SpellStoringItem)) continue;
            SpellStoringItem storer = (SpellStoringItem)class_17923;
            SpellGrid grid = SpellStoringItem.readGrid(contender);
            if (grid == null || !Objects.equals(grid.name, name)) continue;
            return grid;
        }
        return null;
    }

    default public class_1799 getSpellStorageStack(class_1799 casterItem, String name) {
        class_1792 class_17922 = casterItem.method_7909();
        if (!(class_17922 instanceof ISpellSelectorItem)) {
            return null;
        }
        ISpellSelectorItem caster = (ISpellSelectorItem)class_17922;
        for (int i = 0; i < caster.getStorageSize(casterItem); ++i) {
            class_1799 contender = caster.getStack(casterItem, i);
            class_1792 class_17923 = contender.method_7909();
            if (!(class_17923 instanceof SpellStoringItem)) continue;
            SpellStoringItem storer = (SpellStoringItem)class_17923;
            SpellGrid grid = SpellStoringItem.readGrid(contender);
            if (grid == null || !Objects.equals(grid.name, name)) continue;
            return contender;
        }
        return null;
    }

    public static Map<class_1799, List<class_1799>> getAllVariableStorageItems(class_1263 inv) {
        LinkedHashMap<class_1799, List<class_1799>> res = new LinkedHashMap<class_1799, List<class_1799>>();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 mainInvStack = inv.method_5438(i);
            if (mainInvStack.method_7909() instanceof IVariableStoringItem) {
                if (!res.containsKey(null)) {
                    res.put(null, new ArrayList());
                }
                ((List)res.get(null)).add(mainInvStack);
                continue;
            }
            class_1792 class_17922 = mainInvStack.method_7909();
            if (!(class_17922 instanceof ISpellSelectorItem)) continue;
            ISpellSelectorItem sps = (ISpellSelectorItem)class_17922;
            res.put(mainInvStack, sps.getVariableStorageItems(mainInvStack));
        }
        return res;
    }

    public static class_3545<class_1799, class_1799> pickVariableStorageItem(class_1263 inv, String name) {
        class_1799 container = null;
        class_1799 res = null;
        Map<class_1799, List<class_1799>> containers = ISpellSelectorItem.getAllVariableStorageItems(inv);
        for (class_1799 contender : containers.keySet()) {
            class_1799 picked = ISpellSelectorItem.pickVariableStorageItem(containers.get(contender), name);
            if (picked == null) continue;
            container = contender;
            res = picked;
            break;
        }
        return new class_3545(container, res);
    }

    public static class_1799 pickVariableStorageItem(List<class_1799> items, String name) {
        for (int i = 0; i < items.size(); ++i) {
            class_1799 item = items.get(i);
            IVariableStoringItem itemItem = (IVariableStoringItem)item.method_7909();
            if (!itemItem.getAccessorPrefix(item).equals(name)) continue;
            return item;
        }
        return null;
    }

    public static void markDirtyStatic(class_1799 stack) {
        if (stack == null) {
            return;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof ISpellSelectorItem) {
            ISpellSelectorItem sps = (ISpellSelectorItem)item;
            sps.markDirty(stack);
            return;
        }
        if (item instanceof StorageItem) {
            StorageItem storer = (StorageItem)item;
            storer.markDirty(stack);
            return;
        }
    }

    default public List<class_1799> getVariableStorageItems(class_1799 stack) {
        if (!(stack.method_7909() instanceof ISpellSelectorItem)) {
            return null;
        }
        ArrayList<class_1799> res = new ArrayList<class_1799>();
        for (int i = 0; i < this.getStorageSize(stack); ++i) {
            class_1799 contender = this.getStack(stack, i);
            if (!(contender.method_7909() instanceof IVariableStoringItem)) continue;
            res.add(contender);
        }
        return res;
    }

    default public class_1799 getVariableStorageItem(class_1799 stack, String name) {
        List<class_1799> items = this.getVariableStorageItems(stack);
        for (int i = 0; i < items.size(); ++i) {
            class_1799 item = items.get(i);
            IVariableStoringItem itemItem = (IVariableStoringItem)item.method_7909();
            if (!itemItem.getAccessorPrefix(item).equals(name)) continue;
            return item;
        }
        return null;
    }

    public void markDirty(class_1799 var1);

    @Environment(value=EnvType.CLIENT)
    public void onSpellChanged(class_1799 var1, class_746 var2, int var3);

    default public boolean spellPresent(class_1799 stack, String spellName) {
        return this.getSpellIndexOfSpell(stack, spellName) != -1;
    }

    default public SpellGrid getSelectedSpell(class_1799 stack) {
        ArrayList<class_1799> spells = this.getCastableSpellItems(stack);
        if (spells.isEmpty()) {
            return null;
        }
        return SpellStoringItem.readGrid(spells.get(this.getSelectedSpellIndex(stack)));
    }
}

