/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items;

import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.enchantments.ModEnchantments;
import org.oxytocina.geomancy.spells.SpellBlock;
import org.oxytocina.geomancy.spells.SpellBlockArgs;
import org.oxytocina.geomancy.spells.SpellComponent;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.spells.SpellGrid;
import org.oxytocina.geomancy.util.StellgeUtil;

public class SpellStoringItem
extends class_1792 {
    public final int width;
    public final int height;

    public SpellStoringItem(class_1792.class_1793 settings, int width, int height) {
        super(settings);
        this.width = width;
        this.height = height;
    }

    public static SpellGrid getOrCreateGrid(class_1799 stack) {
        SpellGrid existing = SpellStoringItem.readGrid(stack);
        if (existing != null) {
            return existing;
        }
        return SpellStoringItem.createDefaultGrid(stack);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected static SpellGrid createDefaultGrid(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof SpellStoringItem)) {
            return null;
        }
        SpellStoringItem storage = (SpellStoringItem)class_17922;
        SpellGrid grid = new SpellGrid(storage.getWidth(), storage.getHeight());
        SpellStoringItem.writeGrid(stack, grid);
        return grid;
    }

    public static SpellGrid readGrid(class_1799 stack) {
        if (stack == null || !stack.method_7985()) {
            return null;
        }
        class_2487 Nbt = stack.method_7969();
        if (!Nbt.method_10573("spell", 10)) {
            return null;
        }
        class_2487 subNbt = Nbt.method_10562("spell");
        return new SpellGrid(stack, subNbt);
    }

    public static void writeGrid(class_1799 stack, SpellGrid grid) {
        if (stack == null) {
            return;
        }
        class_2487 spellCompound = new class_2487();
        grid.writeNbt(spellCompound);
        stack.method_7959("spell", (class_2520)spellCompound);
    }

    public void cast(class_1799 caster, class_1799 spellstorage, class_1309 user, SpellBlockArgs args, SpellContext.SoundBehavior soundBehavior, boolean activatedByHotkey) {
        SpellGrid grid = SpellStoringItem.getOrCreateGrid(spellstorage);
        if (grid == null) {
            return;
        }
        grid.run(caster, spellstorage, user, null, null, args, soundBehavior, activatedByHotkey);
    }

    public float getSoulCostMultiplier(class_1799 stack) {
        return 1.0f * (1.0f - 0.15f * this.getSoulSaverLevel(stack));
    }

    public float getSoulSaverLevel(class_1799 stack) {
        return ModEnchantments.getLevel(stack, ModEnchantments.SOUL_SAVER);
    }

    public class_2561 method_7864(class_1799 stack) {
        SpellGrid grid = SpellStoringItem.readGrid(stack);
        return class_2561.method_43471((String)this.method_7866(stack)).method_10852((class_2561)class_2561.method_43470((String)" [").method_10852((class_2561)(grid == null ? class_2561.method_43471((String)"geomancy.spellstorage.empty") : (Objects.equals(grid.name, "") ? class_2561.method_43471((String)"geomancy.spellstorage.unnamed") : class_2561.method_43470((String)grid.name)))).method_27693("]").method_27692(class_124.field_1080));
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        class_5250 compText;
        super.method_7851(stack, world, tooltip, context);
        SpellGrid grid = SpellStoringItem.readGrid(stack);
        if (grid == null) {
            return;
        }
        if (grid.library) {
            tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.spellmaker.grid.lib").method_27692(class_124.field_1063));
        }
        if (grid.displayStack != null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.spellmaker.grid.displaysas").method_27693(" ").method_27693(grid.displayStack.method_7964().getString()).method_27692(class_124.field_1080));
        }
        int i = 0;
        int truncation = (Integer)Geomancy.CONFIG.spellcradleTooltipTruncation.value();
        for (SpellComponent comp : grid.components.values()) {
            if (i >= truncation && grid.components.size() > truncation + 1) {
                tooltip.add((class_2561)class_2561.method_43469((String)"geomancy.storage_item.more", (Object[])new Object[]{grid.components.size() - truncation}).method_27692(class_124.field_1063));
                return;
            }
            if (comp.function.category != SpellBlock.Category.Effector) continue;
            compText = class_2561.method_43471((String)("geomancy.spellcomponent." + comp.function.identifier.method_12832()));
            if (comp.isObfuscated()) {
                compText = class_2561.method_43473().method_10852((class_2561)StellgeUtil.stellgify(compText));
            }
            tooltip.add((class_2561)compText.method_27692(class_124.field_1080));
            ++i;
        }
        if (i <= truncation) {
            for (SpellComponent comp : grid.components.values()) {
                if (i >= truncation && grid.components.size() > truncation + 1) {
                    tooltip.add((class_2561)class_2561.method_43469((String)"geomancy.storage_item.more", (Object[])new Object[]{grid.components.size() - truncation}).method_27692(class_124.field_1063));
                    return;
                }
                if (comp.function.category == SpellBlock.Category.Effector) continue;
                compText = class_2561.method_43471((String)("geomancy.spellcomponent." + comp.function.identifier.method_12832()));
                if (comp.isObfuscated()) {
                    compText = class_2561.method_43473().method_10852((class_2561)StellgeUtil.stellgify(compText));
                }
                tooltip.add((class_2561)compText.method_27692(class_124.field_1063));
                ++i;
            }
        }
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }

    public int method_7837() {
        return 14;
    }
}

