/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items.jewelry;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import org.oxytocina.geomancy.client.rendering.ModColorizationHandler;
import org.oxytocina.geomancy.items.ModItems;
import org.oxytocina.geomancy.items.jewelry.GemSlot;
import org.oxytocina.geomancy.items.jewelry.JewelryItemSettings;

public interface IJewelryItem {
    public static final ArrayList<class_1792> List = new ArrayList();

    public static ArrayList<GemSlot> getSlots(class_1799 stack) {
        class_2499 nbt = stack.method_7948().method_10554("gems", 10);
        ArrayList<GemSlot> res = new ArrayList<GemSlot>();
        for (int i = 0; i < nbt.size(); ++i) {
            class_2487 slotNbt = nbt.method_10602(i);
            res.add(GemSlot.fromNbt(slotNbt));
        }
        return res;
    }

    public static void setSlots(class_1799 stack, ArrayList<GemSlot> slots) {
        class_2499 nbt = new class_2499();
        for (GemSlot slot : slots) {
            nbt.add((Object)GemSlot.toNbt(slot));
        }
        stack.method_7959("gems", (class_2520)nbt);
    }

    public int getGemSlotCount();

    public JewelryItemSettings getSettings();

    default public int getColor(class_1799 stack, int tintIndex) {
        if (--tintIndex < 0 || tintIndex >= this.getGemSlotCount()) {
            return this.getBaseColor(stack);
        }
        ArrayList<GemSlot> slots = IJewelryItem.getSlots(stack);
        return slots.size() > tintIndex ? slots.get(tintIndex).getColor() : this.getEmptyColor(tintIndex);
    }

    default public int getBaseColor(class_1799 stack) {
        if (class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832().contains("octangulite")) {
            return ModColorizationHandler.octanguliteItemNoise(stack, 0, 0.03f, true);
        }
        return -1;
    }

    default public int getEmptyColor(int tintIndex) {
        return -1;
    }

    default public float getHasGemPredicate(class_1799 stack) {
        return (float)IJewelryItem.getSlots(stack).size() / (float)this.getGemSlotCount();
    }

    default public int getMishapWeight() {
        return this.getSettings().baseMishapWeight;
    }

    default public List<class_1799> UnSmith(class_1799 stack, boolean preview) {
        ArrayList<class_1799> res = new ArrayList<class_1799>();
        class_1799 base = stack.method_7972();
        base.method_7983("gems");
        if (preview) {
            base.method_7959("preview", (class_2520)class_2481.method_23234((boolean)true));
        }
        res.add(base);
        ArrayList<GemSlot> gems = IJewelryItem.getSlots(stack);
        for (GemSlot gem : gems) {
            res.add(new class_1799((class_1935)gem.gemItem));
        }
        return res;
    }

    default public class_1799 addSlot(class_1799 stack, GemSlot slot) {
        class_2499 nbt = stack.method_7948().method_10554("gems", 10);
        nbt.add((Object)GemSlot.toNbt(slot));
        stack.method_7959("gems", (class_2520)nbt);
        return stack;
    }

    public static float getXPMultiplier(class_1309 wearer) {
        float res = 1.0f;
        List<class_1799> wornJewelry = IJewelryItem.getAllWornJewelryItems(wearer);
        for (class_1799 jewelryItem : wornJewelry) {
            res += IJewelryItem.getXPMultiplier(jewelryItem, wearer);
        }
        return res;
    }

    public static float getXPMultiplier(class_1799 stack, class_1309 wearer) {
        float res = 0.0f;
        IJewelryItem jewelryItem = (IJewelryItem)stack.method_7909();
        if (jewelryItem.isPendant()) {
            return res;
        }
        ArrayList<GemSlot> gems = IJewelryItem.getSlots(stack);
        for (GemSlot gem : gems) {
            res += gem.getXPMultiplier(stack, wearer);
        }
        return res;
    }

    public static List<class_1799> getAllWornJewelryItems(class_1309 wearer) {
        ArrayList<class_1799> res = new ArrayList<class_1799>();
        if (wearer == null) {
            return res;
        }
        Optional trinkComp = TrinketsApi.getTrinketComponent((class_1309)wearer);
        if (trinkComp.isPresent()) {
            List pairs = ((TrinketComponent)trinkComp.get()).getAllEquipped();
            for (class_3545 pair : pairs) {
                class_1799 stack = (class_1799)pair.method_15441();
                if (!(stack.method_7909() instanceof IJewelryItem)) continue;
                res.add(stack);
            }
        }
        for (int i = 0; i < 4; ++i) {
            class_1792 class_17922;
            class_1799 stack = wearer.method_6118(switch (i) {
                case 0 -> class_1304.field_6166;
                case 1 -> class_1304.field_6172;
                case 2 -> class_1304.field_6174;
                default -> class_1304.field_6169;
            });
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof IJewelryItem)) continue;
            IJewelryItem je = (IJewelryItem)class_17922;
            res.add(stack);
        }
        return res;
    }

    public static float getManaRegenMultiplier(class_1309 wearer) {
        float res = 1.0f;
        return res;
    }

    public static float getManaRegenMultiplier(class_1799 stack, class_1309 wearer) {
        float res = 0.0f;
        IJewelryItem jewelryItem = (IJewelryItem)stack.method_7909();
        if (jewelryItem.isPendant()) {
            return res;
        }
        ArrayList<GemSlot> gems = IJewelryItem.getSlots(stack);
        for (GemSlot gem : gems) {
            res += gem.getManaRegenMultiplier(stack, wearer);
        }
        return res;
    }

    public static float getManaCapacityMultiplier(class_1799 stack, class_1309 entity) {
        float res = 1.0f;
        IJewelryItem jewelryItem = (IJewelryItem)stack.method_7909();
        if (jewelryItem.isPendant()) {
            return res;
        }
        ArrayList<GemSlot> gems = IJewelryItem.getSlots(stack);
        for (GemSlot gem : gems) {
            res += gem.getManaCapacityMultiplier(stack, entity);
        }
        return res;
    }

    public static float getGemQualityMultiplierFor(GemSlot gem, class_1799 onItem, class_1309 wearer) {
        float res = 1.0f;
        if (wearer == null) {
            return res;
        }
        if (IJewelryItem.isPendant(onItem)) {
            return res;
        }
        List<class_1799> wornJewelry = IJewelryItem.getAllWornJewelryItems(wearer);
        for (class_1799 jewelryItem : wornJewelry) {
            if (!IJewelryItem.isPendant(jewelryItem)) continue;
            res += IJewelryItem.getGemQualityMultiplier(gem, jewelryItem, wearer);
        }
        return res;
    }

    public static float getGemQualityMultiplier(GemSlot refgem, class_1799 stack, class_1309 wearer) {
        float res = 0.0f;
        ArrayList<GemSlot> gems = IJewelryItem.getSlots(stack);
        for (GemSlot gem : gems) {
            if (gem.gemItem != refgem.gemItem) continue;
            res += 0.3f * gem.getEffectiveQuality(stack, wearer);
        }
        return res;
    }

    default public boolean isPendant() {
        return this.getSettings().pendant;
    }

    public static boolean isPendant(class_1799 stack) {
        IJewelryItem j;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof IJewelryItem && (j = (IJewelryItem)class_17922).isPendant();
    }

    public static float getFortuneBonus(class_1799 jewelryItem, class_1309 wearer) {
        IJewelryItem ji;
        if (wearer == null) {
            return 0.0f;
        }
        float res = 0.0f;
        class_1792 class_17922 = jewelryItem.method_7909();
        if (!(class_17922 instanceof IJewelryItem) || (ji = (IJewelryItem)class_17922).isPendant()) {
            return res;
        }
        ArrayList<GemSlot> gsls = IJewelryItem.getSlots(jewelryItem);
        for (GemSlot gsl : gsls) {
            res += gsl.getFortuneBonus(jewelryItem, wearer);
        }
        return res;
    }

    public static float getFortuneBonus(class_1309 entity) {
        float res = 0.0f;
        List<class_1799> jis = IJewelryItem.getAllWornJewelryItems(entity);
        for (class_1799 ji : jis) {
            res += IJewelryItem.getFortuneBonus(ji, entity);
        }
        return res;
    }

    public static void populateItemGroup() {
        ItemGroupEvents.modifyEntriesEvent(ModItems.JEWELRY_ITEM_GROUP_KEY).register(itemGroup -> {
            for (class_1792 i : List) {
                for (class_1792 gem : GemSlot.settingsMap.keySet()) {
                    class_1799 fullJewelry = new class_1799((class_1935)i);
                    IJewelryItem jewelryItem = (IJewelryItem)i;
                    for (int j = 0; j < jewelryItem.getGemSlotCount(); ++j) {
                        jewelryItem.addSlot(fullJewelry, new GemSlot(gem, 1.0f));
                    }
                    itemGroup.method_45420(fullJewelry);
                }
            }
        });
    }
}

